/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;

public class SquareGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Square Waveforme";
    protected double[] currents = new double[8];
    protected double[] timing = new double[8];
    private int phase = 0;
    private double nextPhase;
    private double startPhase;
    private double[] slope = new double[8];

    public SquareGenerator() {
        this.signal = 0.0;
        this.nextPhase = Double.POSITIVE_INFINITY;
        this.startPhase = 0.0;
        this.updateOutput();
    }

    public void computeNextTic() {
        double d = Clock.sharedInstance.getTime();
        if (d >= this.nextPhase) {
            ++this.phase;
            this.phase %= 8;
            this.signal = this.currents[this.phase];
            this.startPhase = this.nextPhase;
            this.nextPhase += this.timing[this.phase];
        } else {
            this.signal = this.currents[this.phase] + this.slope[this.phase] * (d - this.startPhase);
        }
    }

    public double getIHigh() {
        return this.currents[2];
    }

    public double getILow() {
        return this.currents[6];
    }

    public double getIOffset() {
        return this.currents[0];
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public Coordinate2D getRange() {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < 8) {
            if (d < this.currents[n]) {
                d = this.currents[n];
            }
            if (d2 > this.currents[n]) {
                d2 = this.currents[n];
            }
            ++n;
        }
        return new Coordinate2D(d2, d);
    }

    public double getTiming(int n) {
        return this.timing[n];
    }

    public void init(double d, double d2, double d3, double[] dArray) {
        this.phase = 0;
        this.startPhase = 0.0;
        this.timing = dArray;
        this.nextPhase = dArray[0];
        this.currents[2] = this.currents[3] = d2;
        this.currents[6] = this.currents[7] = d3;
        this.currents[4] = this.currents[5] = d;
        this.currents[1] = this.currents[5];
        this.currents[0] = this.currents[5];
        this.signal = this.currents[5];
        int n = 0;
        while (n < 8) {
            this.slope[n] = (this.currents[(n + 1) % 8] - this.currents[n]) / dArray[n];
            n += 2;
        }
        this.updateOutput();
    }

    public void resetTime() {
        this.phase = 0;
        this.startPhase = Clock.sharedInstance.getInitialTime();
        this.signal = this.currents[0];
        this.nextPhase = this.startPhase + this.timing[0];
        this.updateOutput();
    }

    public void setIHigh(double d) {
        this.currents[2] = this.currents[3] = d;
        this.slope[1] = (this.currents[2] - this.currents[1]) / this.timing[1];
        this.slope[3] = (this.currents[4] - this.currents[3]) / this.timing[3];
    }

    public void setILow(double d) {
        this.currents[6] = this.currents[7] = d;
        this.slope[5] = (this.currents[6] - this.currents[5]) / this.timing[5];
        this.slope[7] = (this.currents[0] - this.currents[7]) / this.timing[7];
    }

    public void setIOffset(double d) {
        this.currents[4] = this.currents[5] = d;
        this.currents[1] = this.currents[5];
        this.currents[0] = this.currents[5];
        int n = 1;
        while (n < 8) {
            this.slope[n] = (this.currents[(n + 1) % 8] - this.currents[n]) / this.timing[n];
            n += 2;
        }
    }

    public void setTiming(int n, double d) {
        this.timing[n] = d;
        this.slope[n] = (this.currents[(n + 1) % 8] - this.currents[n]) / d;
    }
}

