/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;

public class StepGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Step Generator";
    protected double iInitial = 0.0;
    protected double iFinal = 0.0;
    protected double raiseTimeRatio = 0.0;
    private boolean initialized;
    private double raiseTime;

    public StepGenerator() {
        this.signal = 0.0;
        this.updateOutput();
        this.initialized = false;
        this.raiseTime = 0.0;
    }

    public void computeNextTic() {
        double d = Clock.sharedInstance.getTime();
        if (!this.initialized) {
            this.initialized = true;
            this.raiseTime += Clock.sharedInstance.getDuration() * this.raiseTimeRatio;
        }
        this.signal = d < this.raiseTime ? this.iInitial : this.iFinal;
    }

    public double getFinalCurrent() {
        return this.iFinal;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public double getInitialCurrent() {
        return this.iInitial;
    }

    public double getRaiseTimeRatio() {
        return this.raiseTimeRatio;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(Math.min(this.iInitial, this.iFinal), Math.max(this.iInitial, this.iFinal));
    }

    public void init(double d, double d2, double d3) {
        this.iInitial = d;
        this.iFinal = d2;
        this.raiseTimeRatio = d3;
    }

    public void resetTime() {
        this.signal = this.iInitial;
        this.updateOutput();
        this.raiseTime = Clock.sharedInstance.getInitialTime();
        this.initialized = false;
    }

    public void setFinalCurrent(double d) {
        this.iFinal = d;
    }

    public void setInitialCurrent(double d) {
        this.iInitial = d;
    }

    public void setRaiseTimeRatio(double d) {
        this.raiseTimeRatio = d;
    }
}

