/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.math;

import java.util.Random;

public class RandomDistribution
extends Random {
    public static final RandomDistribution sharedInstance = new RandomDistribution();

    public RandomDistribution() {
    }

    public RandomDistribution(long l) {
        super(l);
    }

    public static double fact(double d) {
        if (d < 0.0 || Math.ceil(d) != d) {
            return 0.0;
        }
        double d2 = 1.0;
        long l = 2L;
        while (l <= (long)d) {
            d2 *= (double)l;
            ++l;
        }
        return d2;
    }

    public static long fact(long l) {
        long l2 = 1L;
        long l3 = 2L;
        while (l3 <= l) {
            l2 *= l3;
            ++l3;
        }
        return l2;
    }

    public boolean nextBernoulli(double d) {
        return this.nextDouble() < d;
    }

    public double nextBeta(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        d = 1.0 / d;
        d2 = 1.0 / d2;
        do {
            d5 = this.nextDouble();
            d3 = this.nextDouble();
        } while ((d6 = Math.pow(d5, d)) + (d4 = Math.pow(d3, d2)) > 1.0);
        return d6 / (d6 + d4);
    }

    public int nextBinomial(int n, double d) {
        int n2;
        double d2;
        if (d <= 1.0E-20) {
            return 0;
        }
        if (d >= 1.0) {
            return n;
        }
        if (n < 200) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (this.nextBernoulli(d)) {
                    ++n3;
                }
                ++n4;
            }
            return n3;
        }
        int n5 = 200;
        int n6 = n;
        int n7 = 0;
        double d3 = d;
        do {
            if (d3 < (d2 = this.nextBeta(n2 = (int)Math.ceil((double)n6 * d3) + 1, n6 + 1 - n2))) {
                d3 /= d2;
                n6 = n2 - 1;
                continue;
            }
            n7 += n2;
            d3 = (d3 - d2) / (1.0 - d2);
            n6 -= n2;
        } while (n6 > 200);
        n2 = 0;
        while (n2 < n6) {
            d2 = this.nextDouble();
            if (d2 < d) {
                ++n7;
            }
            ++n6;
        }
        return n7;
    }

    public double nextCauchy() {
        double d;
        double d2;
        double d3;
        while ((d3 = this.nextDouble()) * d3 + (d2 = 2.0 * (d = this.nextDouble()) - 1.0) * d2 >= 1.0) {
        }
        return d2 / d3;
    }

    public double nextExponential(double d) {
        return Math.log(this.nextDouble()) / -d;
    }

    public long nextGeometrical(double d) {
        return d >= 1.0 ? 1L : (long)Math.ceil(this.nextExponential(-Math.log(1.0 - d)));
    }

    public double nextNormal(double d, double d2) {
        return this.nextGaussian() * d2 + d;
    }

    public int nextPoisson(int n) {
        if (n <= 50) {
            float f;
            float f2 = 1.0f;
            float f3 = (float)Math.exp(-n);
            int n2 = 0;
            do {
                f = this.nextFloat();
                ++n2;
            } while ((f2 *= f) >= f3);
            return --n2;
        }
        if (n <= 250) {
            double d;
            double d2 = 0.767 - 3.36 / (double)n;
            double d3 = Math.PI / Math.sqrt(3.0 * (double)n);
            double d4 = d3 * (double)n;
            double d5 = Math.log(d2) - (double)n - Math.log(d3);
            while (true) {
                double d6;
                double d7;
                if ((d7 = (d4 - Math.log(1.0 - (d6 = this.nextDouble())) / d6) / d3) <= -0.5) {
                    continue;
                }
                d = Math.ceil(d7 + 0.5);
                double d8 = this.nextDouble();
                if (!(d4 - d3 * d7 + Math.log(d8 / Math.sqrt(1.0 + Math.exp(d4 - d3 * d7))) > d5 + d * Math.log(n) - Math.log(RandomDistribution.fact(d)))) break;
            }
            return (int)d;
        }
        return (int)this.nextNormal(n, n);
    }

    public double nextUnif(double d) {
        return this.nextDouble() * d;
    }

    public float nextUnif(float f) {
        return this.nextFloat() * f;
    }

    public int nextUnif(int n) {
        return this.nextInt() % n;
    }

    public long nextUnif(long l) {
        return this.nextLong() % l;
    }

    public double nextVNexponential(double d) {
        int n = 0;
        while (true) {
            double d2;
            double d3;
            double d4 = d3 = this.nextDouble();
            do {
                double d5;
                d2 = this.nextDouble();
                if (!(d3 <= d5)) continue;
                return (double)n + d4;
            } while ((d3 = this.nextDouble()) < d2);
            ++n;
        }
    }
}

