/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.math;

import java.awt.Dimension;
import java.awt.Point;
import spikingneuron.math.Coordinate2D;

public class Screen2D {
    public Point scrUpperLeft;
    public Point scrLowerRight;
    public Coordinate2D usrUpperLeft;
    public Coordinate2D usrLowerRight;
    public Coordinate2D ratio;
    public boolean reverseAbscissa;

    public Screen2D(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, boolean bl) {
        this.reverseAbscissa = bl;
        this.scrUpperLeft = new Point(n, n2);
        this.scrLowerRight = new Point(n3, n4);
        this.usrUpperLeft = new Coordinate2D(d, d2);
        this.usrLowerRight = new Coordinate2D(d3, d4);
        this.ratio = new Coordinate2D();
        this.computeRatio();
    }

    public Screen2D(Dimension dimension, Coordinate2D coordinate2D, boolean bl) {
        this.reverseAbscissa = this.reverseAbscissa;
        this.scrUpperLeft = new Point(0, 0);
        this.scrLowerRight = new Point(dimension.width - 1, dimension.height - 1);
        this.usrUpperLeft = new Coordinate2D(0.0, 0.0);
        this.usrLowerRight = new Coordinate2D(coordinate2D);
        this.ratio = new Coordinate2D();
        this.computeRatio();
    }

    public Screen2D(Point point, Dimension dimension, Coordinate2D coordinate2D, Coordinate2D coordinate2D2, boolean bl) {
        this.reverseAbscissa = this.reverseAbscissa;
        this.scrUpperLeft = new Point(point);
        this.scrLowerRight = new Point(point.x + dimension.width - 1, point.y + dimension.height - 1);
        this.usrUpperLeft = new Coordinate2D(coordinate2D);
        this.usrLowerRight = new Coordinate2D(coordinate2D);
        this.usrLowerRight.add(coordinate2D2);
        this.ratio = new Coordinate2D();
        this.computeRatio();
    }

    public Screen2D(Point point, Point point2, Coordinate2D coordinate2D, Coordinate2D coordinate2D2, boolean bl) {
        this.reverseAbscissa = bl;
        this.scrUpperLeft = new Point(point);
        this.scrLowerRight = new Point(point2);
        this.usrUpperLeft = new Coordinate2D(coordinate2D);
        this.usrLowerRight = new Coordinate2D(coordinate2D2);
        this.ratio = new Coordinate2D();
        this.computeRatio();
    }

    private void computeRatio() {
        this.ratio.setX((double)(this.scrLowerRight.x - this.scrUpperLeft.x) / (this.usrLowerRight.getX() - this.usrUpperLeft.getX()));
        if (this.reverseAbscissa) {
            this.ratio.setY((double)(this.scrLowerRight.y - this.scrUpperLeft.y) / (this.usrUpperLeft.getY() - this.usrLowerRight.getY()));
        } else {
            this.ratio.setY((double)(this.scrLowerRight.y - this.scrUpperLeft.y) / (this.usrLowerRight.getY() - this.usrUpperLeft.getY()));
        }
    }

    public int getScrHeight() {
        return this.scrLowerRight.y - this.scrUpperLeft.y + 1;
    }

    public Point getScrLocation() {
        return this.scrUpperLeft;
    }

    public Point getScrLowerRight() {
        return this.scrLowerRight;
    }

    public int getScrMaxX() {
        return this.scrLowerRight.x;
    }

    public int getScrMaxY() {
        return this.scrLowerRight.y;
    }

    public int getScrMinX() {
        return this.scrUpperLeft.x;
    }

    public int getScrMinY() {
        return this.scrUpperLeft.y;
    }

    public Dimension getScrSize() {
        return new Dimension(this.scrLowerRight.x - this.scrUpperLeft.x + 1, this.scrLowerRight.y - this.scrUpperLeft.y + 1);
    }

    public Point getScrUpperLeft() {
        return this.scrUpperLeft;
    }

    public int getScrWidth() {
        return this.scrLowerRight.x - this.scrUpperLeft.x + 1;
    }

    public Coordinate2D getUsrLocation() {
        return this.usrUpperLeft;
    }

    public Coordinate2D getUsrLowerRight() {
        return this.usrLowerRight;
    }

    public double getUsrMaxX() {
        return this.usrLowerRight.getX();
    }

    public double getUsrMaxY() {
        if (this.reverseAbscissa) {
            return this.usrUpperLeft.getY();
        }
        return this.usrLowerRight.getY();
    }

    public double getUsrMinX() {
        return this.usrUpperLeft.getX();
    }

    public double getUsrMinY() {
        if (this.reverseAbscissa) {
            return this.usrLowerRight.getY();
        }
        return this.usrUpperLeft.getY();
    }

    public Coordinate2D getUsrSize() {
        return Coordinate2D.getDistance(this.usrUpperLeft, this.usrLowerRight);
    }

    public Coordinate2D getUsrUpperLeft() {
        return this.usrUpperLeft;
    }

    public boolean mathOrientation() {
        return this.reverseAbscissa;
    }

    public Dimension scrDim(double d, double d2) {
        return new Dimension(this.scrWidth(d), this.scrHeight(d2));
    }

    public Dimension scrDim(Coordinate2D coordinate2D) {
        return new Dimension(this.scrWidth(coordinate2D.getX()), this.scrHeight(coordinate2D.getY()));
    }

    public int scrHeight(double d) {
        return (int)Math.round(d * this.ratio.getY());
    }

    public Point scrPoint(double d, double d2) {
        return new Point(this.scrX(d), this.scrY(d2));
    }

    public Point scrPoint(Coordinate2D coordinate2D) {
        return new Point(this.scrX(coordinate2D.getX()), this.scrY(coordinate2D.getY()));
    }

    public int scrWidth(double d) {
        return (int)Math.round(d * this.ratio.getX());
    }

    public int scrX(double d) {
        return (int)((long)this.scrUpperLeft.x + Math.round(this.ratio.getX() * (d - this.usrUpperLeft.getX())));
    }

    public int scrY(double d) {
        if (this.reverseAbscissa) {
            return (int)((long)this.scrUpperLeft.y + Math.round(this.ratio.getY() * (this.usrUpperLeft.getY() - d)));
        }
        return (int)((long)this.scrUpperLeft.y + Math.round(this.ratio.getY() * (d - this.usrUpperLeft.getY())));
    }

    public void setScr(int n, int n2, int n3, int n4) {
        this.scrUpperLeft.setLocation(n, n2);
        this.scrLowerRight.setLocation(n3, n4);
        this.computeRatio();
    }

    public void setScr(Point point, Point point2) {
        this.scrUpperLeft.setLocation(point);
        this.scrLowerRight.setLocation(point2);
        this.computeRatio();
    }

    public void setScrLocation(Point point) {
        this.scrLowerRight.x += point.x - this.scrUpperLeft.x;
        this.scrLowerRight.y += point.y - this.scrUpperLeft.y;
        this.scrUpperLeft.setLocation(point);
    }

    public void setScrSize(Dimension dimension) {
        this.scrLowerRight.setLocation(this.scrUpperLeft.x + dimension.width - 1, this.scrUpperLeft.y + dimension.height - 1);
        this.computeRatio();
    }

    public void setUsr(double d, double d2, double d3, double d4) {
        this.usrUpperLeft.setLocation(d, d2);
        this.usrLowerRight.setLocation(d3, d4);
        this.computeRatio();
    }

    public void setUsr(Coordinate2D coordinate2D, Coordinate2D coordinate2D2) {
        this.usrUpperLeft.setLocation(coordinate2D);
        this.usrLowerRight.setLocation(coordinate2D2);
        this.computeRatio();
    }

    public void setUsrLocation(Coordinate2D coordinate2D) {
        this.usrLowerRight.translate(Coordinate2D.getRelDistance(coordinate2D, this.usrUpperLeft));
        this.usrUpperLeft.setLocation(coordinate2D);
    }

    public void setUsrSize(Coordinate2D coordinate2D) {
        this.usrLowerRight.setX(this.usrUpperLeft.getX() + coordinate2D.getX());
        if (this.reverseAbscissa) {
            this.usrLowerRight.setY(this.usrUpperLeft.getY() - coordinate2D.getY());
        } else {
            this.usrLowerRight.setY(this.usrUpperLeft.getY() + coordinate2D.getY());
        }
    }

    public Coordinate2D usrDim(int n, int n2) {
        return new Coordinate2D(this.usrWidth(n), this.usrHeight(n2));
    }

    public Coordinate2D usrDim(Dimension dimension) {
        return new Coordinate2D(this.usrWidth(dimension.width), this.usrHeight(dimension.height));
    }

    public double usrHeight(int n) {
        return (double)n / this.ratio.getY();
    }

    public Coordinate2D usrPoint(int n, int n2) {
        return new Coordinate2D(this.usrX(n), this.usrY(n2));
    }

    public Coordinate2D usrPoint(Point point) {
        return new Coordinate2D(this.usrX(point.x), this.usrY(point.y));
    }

    public double usrWidth(int n) {
        return (double)n / this.ratio.getX();
    }

    public double usrX(int n) {
        return this.usrUpperLeft.getX() + (double)(n - this.scrUpperLeft.x) / this.ratio.getX();
    }

    public double usrY(int n) {
        if (this.reverseAbscissa) {
            return this.usrUpperLeft.getY() - (double)(n - this.scrUpperLeft.y) / this.ratio.getY();
        }
        return this.usrUpperLeft.getY() + (double)(n - this.scrUpperLeft.y) / this.ratio.getY();
    }
}

