/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import spikingneuron.math.Coordinate2D;
import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.tools.Clock;

public class IntegrateAndFire
extends NeuronBaseModel {
    public static final String IDENTITY = "Integrate & Fire Model";
    protected double resetPotential = 0.0;
    protected double tauMembrane;
    private double integrationStartTime;

    public IntegrateAndFire(int n) {
        super(n);
    }

    public void computeNextTic() {
        super.computeNextTic();
        double d = Clock.sharedInstance.getTime();
        double d2 = Clock.sharedInstance.getDeltaT();
        if (this.integrationStartTime > d) {
            this.membranePotential = Double.NEGATIVE_INFINITY;
        } else {
            double d3;
            if (this.integrationStartTime < d - d2) {
                d3 = this.membranePotential;
            } else {
                d3 = this.resetPotential;
                d2 = this.integrationStartTime - d;
            }
            double d4 = this.calculateExternalCurrent() + this.calculatePreSynapticCurrent();
            d3 += d2 * (this.resistance * d4 - d3) / this.tauMembrane;
            if (d3 >= this.threshold && this.membranePotential < d3) {
                this.membranePotential = Double.POSITIVE_INFINITY;
                this.computeEffectiveRefractoryTime();
                this.integrationStartTime = d + this.refractoryTime;
            } else {
                this.membranePotential = d3;
            }
        }
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(this.resetPotential, this.meanThreshold + this.gapThreshold);
    }

    public double getResetPotential() {
        return this.resetPotential;
    }

    public double getTauMembrane() {
        return this.tauMembrane;
    }

    public void ifInit(double d, double d2) {
        this.tauMembrane = d;
        this.resetPotential = d2;
        this.integrationStartTime = 0.0;
        this.membranePotential = d2;
    }

    public void resetTime() {
        super.resetTime();
        this.integrationStartTime = Clock.sharedInstance.getInitialTime();
        this.membranePotential = this.resetPotential;
        this.updateOutput();
    }

    public void setResetPotential(double d) {
        this.resetPotential = d;
    }

    public void setTauMembrane(double d) {
        this.tauMembrane = d;
    }
}

