/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import spikingneuron.drawable.LayeredDrawable;
import spikingneuron.tools.Tools;

public class NetworkView
extends JPanel
implements ComponentListener {
    public static final Color DEFAULT_BK_COLOR = UIManager.getColor("Panel.background");
    public static final int MAX_COLORS = 128;
    public static final int SPIKE_COLOR = 128;
    public static final int REFRACTORY_COLOR = 129;
    public static Color[] neuronsColor = new Color[130];
    protected Image[] neuronImg;
    protected Image buffer;
    protected Graphics graphicsBuffer;
    protected Dimension dim;
    protected Insets borderSize;
    protected int userWidth;
    protected int userHeight;
    protected int netWidth;
    protected int netHeight;
    protected Font font;
    protected Vector items;
    protected Vector changed;
    protected Dimension neuronBoundle;
    protected int currentItem;
    protected int topologieMode;

    static {
        int n = 0;
        while (n < 128) {
            NetworkView.neuronsColor[n] = new Color(256 * n / 128, 255 - 256 * n / 128, 0);
            ++n;
        }
        NetworkView.neuronsColor[128] = Color.white;
        NetworkView.neuronsColor[129] = Color.black;
    }

    public NetworkView(int n, int n2, Font font) {
        super(true);
        this.setOpaque(true);
        this.borderSize = this.getInsets();
        this.dim = new Dimension(n, n2);
        this.neuronBoundle = new Dimension();
        this.font = font;
        this.netWidth = 0;
        this.netHeight = 0;
        this.currentItem = 0;
        this.topologieMode = 0;
        this.addComponentListener(this);
        this.userWidth = n - this.borderSize.right - this.borderSize.left;
        this.userHeight = n2 - this.borderSize.top - this.borderSize.bottom;
        this.neuronImg = new Image[3];
        this.neuronImg[0] = Tools.loadImageIcon(this.getClass(), "/images/full.gif", "").getImage();
        this.neuronImg[1] = Tools.loadImageIcon(this.getClass(), "/images/4neighbor.gif", "").getImage();
        this.neuronImg[2] = Tools.loadImageIcon(this.getClass(), "/images/8neighbor.gif", "").getImage();
        this.buffer = null;
        this.graphicsBuffer = null;
        this.items = new Vector(500, 200);
        this.changed = new Vector(500, 200);
    }

    public void addChangedItem(LayeredDrawable layeredDrawable) {
        this.changed.addElement(layeredDrawable);
    }

    public Rectangle addItem(LayeredDrawable layeredDrawable) {
        Point point = new Point();
        point.x = this.currentItem % this.netWidth * this.neuronBoundle.width;
        point.y = this.currentItem / this.netWidth * this.neuronBoundle.height;
        this.items.addElement(layeredDrawable);
        ++this.currentItem;
        return new Rectangle(point, this.neuronBoundle);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Point point = new Point();
        this.dim = this.getSize();
        this.borderSize = this.getInsets();
        this.userWidth = this.dim.width - this.borderSize.right - this.borderSize.left;
        this.userHeight = this.dim.height - this.borderSize.top - this.borderSize.bottom;
        this.neuronBoundle.width = this.userWidth / this.netWidth;
        this.neuronBoundle.height = this.userHeight / this.netHeight;
        this.buffer = this.createImage(this.userWidth, this.userHeight);
        if (this.buffer != null) {
            this.graphicsBuffer = this.buffer.getGraphics();
            this.graphicsBuffer.setFont(this.font);
            this.drawBackground();
            int n = 0;
            while (n < this.currentItem) {
                point.x = n % this.netWidth * this.neuronBoundle.width;
                point.y = n / this.netWidth * this.neuronBoundle.height;
                ((LayeredDrawable)this.items.elementAt(n)).resize(this.graphicsBuffer, new Rectangle(point, this.neuronBoundle));
                ++n;
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    protected void drawBackground() {
        if (this.graphicsBuffer != null) {
            this.graphicsBuffer.setColor(DEFAULT_BK_COLOR);
            this.graphicsBuffer.fillRect(0, 0, this.userWidth, this.userHeight);
            int n = 0;
            while (n < this.netHeight * this.netWidth) {
                this.graphicsBuffer.drawImage(this.neuronImg[this.topologieMode], n % this.netWidth * this.neuronBoundle.width, n / this.netWidth * this.neuronBoundle.height, this.neuronBoundle.width, this.neuronBoundle.height, this);
                ++n;
            }
        }
    }

    public Graphics getBufferedGraphics() {
        return this.graphicsBuffer;
    }

    public synchronized Dimension getMinimumSize() {
        return this.dim;
    }

    public Image getNeuronBackImage() {
        return this.neuronImg[this.topologieMode];
    }

    public Dimension getNeuronSpace() {
        return this.neuronBoundle;
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void paint(Graphics graphics) {
        Enumeration enumeration;
        if (!this.dim.equals(this.getSize())) {
            this.componentResized(null);
        }
        if (this.graphicsBuffer == null) {
            this.buffer = this.createImage(this.userWidth, this.userHeight);
            this.graphicsBuffer = this.buffer.getGraphics();
            this.graphicsBuffer.setFont(this.font);
            enumeration = this.items.elements();
            while (enumeration.hasMoreElements()) {
                ((LayeredDrawable)enumeration.nextElement()).setBufferGraphics(this.graphicsBuffer);
            }
        }
        this.drawBackground();
        enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            ((LayeredDrawable)enumeration.nextElement()).paintAt(LayeredDrawable.LAYER_ONE);
        }
        super.paint(graphics);
        graphics.drawImage(this.buffer, this.borderSize.left, this.borderSize.right, this);
    }

    public void removeItems() {
        this.items.removeAllElements();
        this.currentItem = 0;
    }

    public void repaintNeurons() {
        Graphics graphics = this.getGraphics();
        Enumeration enumeration = this.changed.elements();
        while (enumeration.hasMoreElements()) {
            ((LayeredDrawable)enumeration.nextElement()).paintAt(LayeredDrawable.LAYER_ONE);
        }
        this.changed.removeAllElements();
        graphics.drawImage(this.buffer, this.borderSize.left, this.borderSize.right, this);
    }

    public void setNetworkSize(int n, int n2) {
        this.netWidth = n;
        this.netHeight = n2;
        this.currentItem = 0;
        this.neuronBoundle.width = this.userWidth / this.netWidth;
        this.neuronBoundle.height = this.userHeight / this.netHeight;
        this.drawBackground();
    }

    public void setTopologie(int n) {
        this.topologieMode = n;
    }
}

