/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import java.util.Enumeration;
import java.util.Vector;
import spikingneuron.generators.DiscreteNoisyGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.math.RandomDistribution;
import spikingneuron.tools.Clock;
import spikingneuron.tools.RealFlowProducer;
import spikingneuron.tools.SpikeFlowProducer;

public abstract class NeuronBaseModel
implements RealFlowProducer,
SpikeFlowProducer {
    public static final double SPIKE_POTENTIAL = Double.POSITIVE_INFINITY;
    public static final double REFRACTORY_POTENTIAL = Double.NEGATIVE_INFINITY;
    public static final String IDENTITY = "Abstract Neural Model";
    protected static int nbSpike = 0;
    protected double meanThreshold;
    protected double gapThreshold;
    protected double meanRefractoryTime;
    protected double gapRefractoryTime;
    protected double resistance;
    protected double tauSynaptic;
    protected DiscreteNoisyGenerator noisyCurrent;
    protected double threshold;
    protected double refractoryTime;
    protected double membranePotential;
    protected Vector spikeTrain;
    protected int id;
    protected double output;
    protected Vector dendrites;
    protected Vector externalStimulus;

    protected NeuronBaseModel(int n) {
        this.id = n;
        this.meanThreshold = 0.0;
        this.gapThreshold = 0.0;
        this.meanRefractoryTime = 0.0;
        this.gapRefractoryTime = 0.0;
        this.tauSynaptic = 0.0;
        this.resistance = 0.0;
        this.refractoryTime = 0.0;
        this.threshold = 0.0;
        this.membranePotential = 0.0;
        this.output = 0.0;
        this.noisyCurrent = new DiscreteNoisyGenerator();
        this.externalStimulus = new Vector(2, 5);
        this.dendrites = new Vector(10, 50);
        this.spikeTrain = new Vector(20, 20);
    }

    public void addExternalInput(RealFlowProducer realFlowProducer) {
        this.externalStimulus.addElement(realFlowProducer);
    }

    public Dendrite addInput(SpikeFlowProducer spikeFlowProducer, double d, double d2) {
        Dendrite dendrite = new Dendrite(spikeFlowProducer, d, d2);
        this.dendrites.addElement(dendrite);
        return dendrite;
    }

    protected double calculateExternalCurrent() {
        double d = this.noisyCurrent.getRealOutput();
        Enumeration enumeration = this.externalStimulus.elements();
        while (enumeration.hasMoreElements()) {
            d += ((RealFlowProducer)enumeration.nextElement()).getRealOutput();
        }
        return d;
    }

    protected double calculatePreSynapticCurrent() {
        double d = 0.0;
        double d2 = Clock.sharedInstance.getTime();
        double d3 = 0.0;
        Enumeration enumeration = this.dendrites.elements();
        while (enumeration.hasMoreElements()) {
            Dendrite dendrite = (Dendrite)enumeration.nextElement();
            Enumeration enumeration2 = dendrite.axon.getSpikesOutput();
            while (enumeration2.hasMoreElements()) {
                d = d2 - (Double)enumeration2.nextElement() - dendrite.delay;
                if (!(d > 0.0)) continue;
                d3 += dendrite.efficacityFactor * (d /= this.tauSynaptic) / this.tauSynaptic * Math.exp(-d);
            }
        }
        return d3;
    }

    protected void computeEffectiveRefractoryTime() {
        this.refractoryTime = Math.abs(RandomDistribution.sharedInstance.nextNormal(this.meanRefractoryTime, this.gapRefractoryTime));
    }

    private void computeEffectiveThreshold() {
        this.threshold = RandomDistribution.sharedInstance.nextNormal(this.meanThreshold, this.gapThreshold);
    }

    public void computeNextTic() {
        this.noisyCurrent.computeNextTic();
    }

    public Enumeration getExternalInputs() {
        return this.externalStimulus.elements();
    }

    public static synchronized int getFireCounter() {
        return nbSpike;
    }

    public double getGapAbsoluteRefractoryTime() {
        return this.gapRefractoryTime;
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public Enumeration getInputs() {
        return this.dendrites.elements();
    }

    public double getMeanAbsoluteRefractoryTime() {
        return this.meanRefractoryTime;
    }

    public double getMeanThreshold() {
        return this.meanThreshold;
    }

    public double getNoiseAmplitude() {
        return this.noisyCurrent.getAmplitude();
    }

    public abstract Coordinate2D getRange();

    public double getRealOutput() {
        return this.output;
    }

    public double getResistance() {
        return this.resistance;
    }

    public Enumeration getSpikesOutput() {
        return this.spikeTrain.elements();
    }

    public double getTauSynaptic() {
        return this.tauSynaptic;
    }

    public static synchronized void incrementFireCounter() {
        ++nbSpike;
    }

    public void nbmInit(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.meanThreshold = d;
        this.gapThreshold = d2;
        this.meanRefractoryTime = d3;
        this.gapRefractoryTime = d4;
        this.resistance = d5;
        this.tauSynaptic = d6;
        this.noisyCurrent.setAmplitude(d7);
    }

    public void removeExternalInput(RealFlowProducer realFlowProducer) {
        this.externalStimulus.removeElement(realFlowProducer);
    }

    public void removeExternalInputs() {
        this.externalStimulus.removeAllElements();
    }

    public void removeInput(Dendrite dendrite) {
        this.dendrites.removeElement(dendrite);
    }

    public void removeInputs() {
        this.dendrites.removeAllElements();
    }

    public static synchronized void resetFireCounter() {
        nbSpike = 0;
    }

    public void resetTime() {
        this.noisyCurrent.resetTime();
        this.computeEffectiveThreshold();
        this.spikeTrain.removeAllElements();
    }

    public void setAbsoluteRefractoryTime(double d, double d2) {
        this.meanRefractoryTime = d;
        this.gapRefractoryTime = d2;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setInput(Dendrite dendrite, double d, double d2) {
        dendrite.delay = d2;
        dendrite.efficacityFactor = d;
    }

    public void setInputs(double d, double d2) {
        Enumeration enumeration = this.dendrites.elements();
        while (enumeration.hasMoreElements()) {
            Dendrite dendrite = (Dendrite)enumeration.nextElement();
            dendrite.delay = d2;
            dendrite.efficacityFactor = d;
        }
    }

    public void setNoiseAmplitude(double d) {
        this.noisyCurrent.setAmplitude(d);
    }

    public void setResistance(double d) {
        this.resistance = d;
    }

    public void setTauSynaptic(double d) {
        this.tauSynaptic = d;
    }

    public void setThreshold(double d, double d2) {
        this.meanThreshold = d;
        this.gapThreshold = d2;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public void updateOutput() {
        this.noisyCurrent.updateOutput();
        this.output = this.membranePotential;
        if (this.output == Double.POSITIVE_INFINITY) {
            this.computeEffectiveThreshold();
            NeuronBaseModel.incrementFireCounter();
            if (this.spikeTrain.size() == 20) {
                this.spikeTrain.removeElementAt(0);
            }
            this.spikeTrain.addElement(new Double(Clock.sharedInstance.getTime()));
        }
    }

    public class Dendrite {
        public SpikeFlowProducer axon;
        public double efficacityFactor;
        public double delay;

        Dendrite(SpikeFlowProducer spikeFlowProducer, double d, double d2) {
            this.axon = spikeFlowProducer;
            this.efficacityFactor = d;
            this.delay = d2;
        }
    }
}

