/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.tools.Clock;
import spikingneuron.tools.RealFlowProducer;

public class PopulationActivity
implements RealFlowProducer {
    protected double output;
    protected double activity;
    protected double dt;
    protected int populationSize;
    protected double nextSample;
    private double factor;

    public PopulationActivity(int n, double d) {
        this.dt = d;
        this.populationSize = n;
        this.output = 0.0;
        this.activity = 0.0;
        this.nextSample = d;
    }

    public void computeNextTic() {
        if (Clock.sharedInstance.getTime() >= this.nextSample) {
            this.activity = (double)NeuronBaseModel.getFireCounter() / this.factor;
            NeuronBaseModel.resetFireCounter();
            this.nextSample += this.dt;
        }
    }

    public double getDeltaT() {
        return this.dt;
    }

    public int getPopulationsize() {
        return this.populationSize;
    }

    public double getRealOutput() {
        return this.output;
    }

    public void resetTime() {
        this.output = 0.0;
        this.activity = 0.0;
        this.nextSample = this.dt + Clock.sharedInstance.getInitialTime();
        this.factor = this.dt * (double)this.populationSize;
        NeuronBaseModel.resetFireCounter();
    }

    public void setDeltaT(double d) {
        this.dt = d;
    }

    public void setPopulationSize(int n) {
        this.populationSize = n;
    }

    public void updateOutput() {
        this.output = this.activity;
    }
}

