/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import spikingneuron.drawable.LayeredDrawable;
import spikingneuron.neurons.NetworkView;
import spikingneuron.neurons.SRMLongMemory;

public class SRMLongDrawable
extends SRMLongMemory
implements LayeredDrawable {
    protected NetworkView view;
    protected Rectangle boundle;
    protected Graphics g;
    protected Point center;
    protected Point textPos;
    protected int diametre;
    protected int colorId;
    protected double colorRatio;
    protected boolean initialized;

    public SRMLongDrawable(int n, NetworkView networkView) {
        super(n);
        this.view = networkView;
        this.boundle = networkView.addItem(this);
        this.g = networkView.getBufferedGraphics();
        this.diametre = Math.min(20, Math.min(this.boundle.width - 2, this.boundle.height - 2));
        this.center = new Point(this.boundle.x + (this.boundle.width - this.diametre) / 2, this.boundle.y + (this.boundle.height - this.diametre) / 2);
        this.textPos = new Point(this.center.x - this.diametre / 2, this.center.y + this.diametre);
        this.colorId = 0;
        this.colorRatio = 0.0;
        this.initialized = false;
    }

    public void paintAt(Integer n) {
        if (n == LayeredDrawable.LAYER_ONE) {
            this.g.setColor(NetworkView.neuronsColor[this.colorId]);
            this.g.fillOval(this.center.x, this.center.y, this.diametre - 1, this.diametre - 1);
            this.g.setColor(Color.black);
            this.g.drawOval(this.center.x, this.center.y, this.diametre, this.diametre);
            this.g.drawOval(this.center.x, this.center.y, this.diametre - 1, this.diametre - 1);
            this.g.drawString(this.toString(), this.textPos.x, this.textPos.y);
        } else {
            this.g.drawImage(this.view.getNeuronBackImage(), this.boundle.x, this.boundle.y, this.boundle.width, this.boundle.height, this.view);
        }
    }

    public void resize(Graphics graphics, Rectangle rectangle) {
        this.boundle = rectangle;
        this.diametre = Math.min(15, Math.min(this.boundle.width - 2, this.boundle.height - 2));
        this.center.x = this.boundle.x + (this.boundle.width - this.diametre) / 2;
        this.center.y = this.boundle.y + (this.boundle.height - this.diametre) / 2;
        this.textPos.x = this.center.x - this.diametre / 2;
        this.textPos.y = this.center.y + this.diametre;
        this.g = graphics;
    }

    public void setBufferGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void updateOutput() {
        int n = this.colorId;
        super.updateOutput();
        if (this.output == Double.POSITIVE_INFINITY || this.output == Double.NEGATIVE_INFINITY || !this.initialized) {
            this.initialized = true;
            this.colorRatio = 128.0 / (this.threshold - (this.meanThreshold + this.eta0));
            if (this.output == Double.POSITIVE_INFINITY) {
                this.colorId = 128;
            } else if (this.output == Double.NEGATIVE_INFINITY) {
                this.colorId = 129;
            } else {
                this.colorId = (int)((this.output - (this.meanThreshold + this.eta0)) * this.colorRatio);
                this.colorId = Math.max(0, Math.min(128, this.colorId));
            }
        } else {
            this.colorId = (int)((this.output - (this.meanThreshold + this.eta0)) * this.colorRatio);
            this.colorId = Math.max(0, Math.min(128, this.colorId));
        }
        if (this.colorId != n) {
            this.view.addChangedItem(this);
        }
    }
}

