/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.neurons;

import spikingneuron.math.Coordinate2D;
import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.tools.Clock;

public abstract class SpikeResponseModel
extends NeuronBaseModel {
    protected double eta0 = 0.0;
    protected double tauEta = 0.0;
    protected double hExternal = 0.0;
    protected double integrationStartTime = Clock.sharedInstance.getInitialTime();

    public SpikeResponseModel(int n) {
        super(n);
        this.membranePotential = 0.0;
    }

    public void computeNextTic() {
        super.computeNextTic();
        double d = Clock.sharedInstance.getTime();
        double d2 = Clock.sharedInstance.getDeltaT();
        if (this.integrationStartTime > d) {
            this.membranePotential = Double.NEGATIVE_INFINITY;
        } else {
            this.updateStimulus(d2, this.calculateExternalCurrent());
            double d3 = this.hExternal + this.calculatePreSynapticCurrent() * this.resistance;
            double d4 = this.myFiringResponse(d) + d3;
            if (d4 >= this.threshold && this.membranePotential < d4) {
                this.membranePotential = Double.POSITIVE_INFINITY;
                this.computeEffectiveRefractoryTime();
                this.integrationStartTime = d + this.refractoryTime;
            } else {
                this.membranePotential = d4;
            }
        }
    }

    protected double eta(double d) {
        return this.eta0 * Math.exp(-d / this.tauEta);
    }

    public double getEta0() {
        return this.eta0;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(Math.min(this.meanThreshold - this.gapThreshold, this.meanThreshold - this.gapThreshold + this.eta0), Math.max(this.meanThreshold + this.gapThreshold, this.meanThreshold + this.gapThreshold + this.eta0));
    }

    public double getTauEta() {
        return this.tauEta;
    }

    protected abstract double myFiringResponse(double var1);

    public void resetTime() {
        super.resetTime();
        this.hExternal = 0.0;
        this.integrationStartTime = Clock.sharedInstance.getInitialTime();
        this.membranePotential = 0.0;
        this.updateOutput();
    }

    public void setEta0(double d) {
        this.eta0 = d;
    }

    public void setTauEta(double d) {
        this.tauEta = d;
    }

    public void srInit(double d, double d2) {
        this.eta0 = d;
        this.tauEta = d2;
        this.hExternal = 0.0;
        this.integrationStartTime = Clock.sharedInstance.getInitialTime();
        this.membranePotential = 0.0;
    }

    protected void updateStimulus(double d, double d2) {
        this.hExternal += d * (this.resistance * d2 - this.hExternal / this.tauSynaptic);
    }
}

