/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.tools;

import spikingneuron.tools.DataFlowAgent;

public class Clock
implements DataFlowAgent {
    public static final Clock sharedInstance = new Clock();
    protected double time;
    protected double delta;
    protected double initialTime;
    protected double maxTime;

    public Clock() {
        this.time = 0.0;
        this.delta = 0.0;
        this.maxTime = 0.0;
        this.initialTime = 0.0;
    }

    public Clock(double d) {
        this.time = 0.0;
        this.delta = d;
        this.maxTime = 0.0;
        this.initialTime = 0.0;
    }

    public Clock(double d, double d2) {
        this.time = d;
        this.delta = d2;
        this.maxTime = 0.0;
        this.initialTime = d;
    }

    public Clock(double d, double d2, double d3) {
        this.time = d;
        this.delta = d2;
        this.maxTime = d3;
        this.initialTime = d;
    }

    public void computeNextTic() {
        this.time += this.delta;
    }

    public double getDeltaT() {
        return this.delta;
    }

    public double getDuration() {
        return this.maxTime - this.initialTime;
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getMaximalTime() {
        return this.maxTime;
    }

    public double getRealOutput() {
        return this.time;
    }

    public double getTime() {
        return this.time;
    }

    public void resetTime() {
        this.time = this.initialTime;
    }

    public void set(double d, double d2, double d3, double d4) {
        this.delta = d2;
        this.time = d;
        this.maxTime = d4;
        this.initialTime = d3;
    }

    public void setDeltaT(double d) {
        this.delta = d;
    }

    public void setInitialTime(double d) {
        this.initialTime = d;
    }

    public void setMaximalTime(double d) {
        this.maxTime = d;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public boolean tic() {
        if (this.time < this.maxTime) {
            this.computeNextTic();
            return true;
        }
        return false;
    }

    public void updateOutput() {
    }
}

