/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import spikingneuron.drawable.DisplayContext;
import spikingneuron.drawable.Drawable;
import spikingneuron.math.Coordinate2D;
import spikingneuron.math.Screen2D;

public class GraphCanvas
extends JPanel {
    private static final double LOG_E = 0.4342944818;
    public Color pntColor;
    public Color axesColor;
    public Color gridColor;
    public Color borderColor;
    public Color backgroundColor;
    public boolean axes;
    public boolean grid;
    public boolean border;
    public Font fontLabel;
    public double xFactor;
    public double yFactor;
    protected Dimension dim;
    protected Insets borderSize;
    protected Screen2D view;
    protected Vector drawableItems;
    protected FontMetrics fontLabelMetrics;
    protected DisplayContext displayCtx;

    public GraphCanvas(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        super(true);
        this.setOpaque(true);
        this.fontLabel = this.getFont();
        if (this.fontLabel == null) {
            this.fontLabel = UIManager.getFont("Panel.font");
        }
        this.fontLabelMetrics = ((Component)this).getFontMetrics(this.fontLabel);
        this.axes = true;
        this.grid = false;
        this.border = true;
        this.pntColor = Color.red;
        this.axesColor = Color.darkGray;
        this.gridColor = Color.gray;
        this.borderColor = Color.black;
        this.backgroundColor = Color.white;
        this.xFactor = 1.0;
        this.yFactor = 1.0;
        this.drawableItems = new Vector(100, 20);
        this.dim = new Dimension(n, n2);
        this.borderSize = this.getInsets();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GraphCanvas.this.dim = GraphCanvas.this.getSize();
                GraphCanvas.this.view.setScr(GraphCanvas.this.borderSize.left + 2, GraphCanvas.this.borderSize.top, GraphCanvas.this.dim.width - GraphCanvas.this.borderSize.right - 1, GraphCanvas.this.dim.height - GraphCanvas.this.borderSize.bottom - 1);
                GraphCanvas.this.displayCtx.resetGraphics();
            }
        });
        double d7 = d * (d3 - d2);
        double d8 = d4 * (d6 - d5);
        this.view = new Screen2D(this.borderSize.left + 2, this.borderSize.top, this.dim.width - this.borderSize.right - 1, this.dim.height - this.borderSize.bottom - 1, d2 -= d7, d6 += d8, d3 += d7, d5 -= d8, true);
        this.displayCtx = new DisplayContext(this, this.view);
    }

    public void addItem(Drawable drawable) {
        this.drawableItems.addElement(drawable);
    }

    public void addSynchronizedItem(Drawable drawable) {
        this.drawableItems.addElement(drawable);
        drawable.addDisplayContext(this.displayCtx);
        drawable.setDisplaySynchro(true);
    }

    public void changeVirtualBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d * (d3 - d2);
        double d8 = d4 * (d6 - d5);
        this.view.setUsr(d2 - d7, d6 + d8, d3 + d7, d5 - d8);
    }

    protected void drawAxes(Graphics graphics, double d, double d2, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        double d3;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl3 = d > 0.0 && n > 0;
        boolean bl4 = d2 > 0.0 && n2 > 0;
        graphics.setColor(this.axesColor);
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = this.view.getUsrMinY() < 0.0 && this.view.getUsrMaxY() > 0.0;
        boolean bl8 = this.view.getUsrMinX() < 0.0 && this.view.getUsrMaxX() > 0.0;
        int n11 = this.view.getScrMaxX() - 2;
        if (bl7) {
            n10 = this.view.scrY(0.0);
            n9 = n10 + n / 2;
            n8 = n10 - n / 2;
        } else {
            bl6 = this.view.getUsrMaxY() < 0.0 ^ true;
            if (!bl6) {
                n9 = n10 = this.view.getScrMaxY();
                n8 = n10 + n2 / 2;
            } else {
                n10 = this.view.getScrMinY();
                n9 = n10 - n2 / 2;
                n8 = n10;
            }
        }
        graphics.drawLine(this.view.getScrMinX(), n10, n11, n10);
        if (n3 > 0) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n11, n10);
            polygon.addPoint(n11 - n3, n10 - n3 / 2);
            polygon.addPoint(n11 - n3, n10 + n3 / 2);
            graphics.fillPolygon(polygon);
        }
        int n12 = 0;
        int n13 = 0;
        if (bl3) {
            int n14;
            double d4 = this.view.getUsrMaxX();
            double d5 = this.view.getUsrMinX();
            double d6 = 0.0;
            while ((d6 += d) < d4) {
                n14 = this.view.scrX(d6);
                graphics.drawLine(n14, n9, n14, n8);
                ++n12;
            }
            d6 = 0.0;
            while ((d6 -= d) > d5) {
                n14 = this.view.scrX(d6);
                graphics.drawLine(n14, n9, n14, n8);
                ++n13;
            }
        }
        int n15 = this.view.getScrMinY() + 2;
        if (bl8) {
            n7 = this.view.scrX(0.0);
            n6 = n7 - n2 / 2;
            n5 = n7 + n2 / 2;
        } else {
            bl5 = this.view.getUsrMaxX() < 0.0 ^ true;
            if (!bl5) {
                n7 = this.view.getScrMaxX();
                n6 = n7 - n2 / 2;
                n5 = n7;
            } else {
                n6 = n7 = this.view.getScrMinX();
                n5 = n7 + n2 / 2;
            }
        }
        graphics.drawLine(n7, this.view.getScrMaxY(), n7, n15);
        if (n3 > 0) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n7, n15);
            polygon.addPoint(n7 - n3 / 2, n15 + n3);
            polygon.addPoint(n7 + n3 / 2, n15 + n3);
            graphics.fillPolygon(polygon);
        }
        int n16 = 0;
        int n17 = 0;
        if (bl4) {
            int n18;
            double d7 = this.view.getUsrMaxY();
            double d8 = this.view.getUsrMinY();
            d3 = 0.0;
            while ((d3 += d2) < d7) {
                n18 = this.view.scrY(d3);
                graphics.drawLine(n6, n18, n5, n18);
                ++n16;
            }
            d3 = 0.0;
            while ((d3 -= d2) > d8) {
                n18 = this.view.scrY(d3);
                graphics.drawLine(n6, n18, n5, n18);
                ++n17;
            }
        }
        if (bl2) {
            graphics.setFont(this.fontLabel);
            this.setForeground(Color.black);
            n4 = this.fontLabelMetrics.getHeight() / 2 - 2;
            if (bl4) {
                double d9 = this.view.usrY(n15 + n3);
                d3 = this.view.getUsrMinY();
                boolean bl9 = true;
                int n19 = n5 + 3;
                double d10 = 0.0;
                while ((d10 += d2) < d9) {
                    if (!(bl9 ^= true)) continue;
                    graphics.drawString(Float.toString((float)(d10 * this.yFactor)), n19, this.view.scrY(d10) + n4);
                }
                d10 = 0.0;
                bl9 = true;
                while ((d10 -= d2) > d3) {
                    if (!(bl9 ^= true)) continue;
                    graphics.drawString(Float.toString((float)(d10 * this.yFactor)), n19, this.view.scrY(d10) + n4);
                }
            }
        }
        if (bl) {
            graphics.setFont(this.fontLabel);
            this.setForeground(Color.black);
            if (bl4) {
                n4 = bl8 || bl6 ? n9 + this.fontLabelMetrics.getHeight() - 2 : n8;
                double d11 = (double)(n12 / 2) * d;
                String string = new String(Float.toString((float)(d11 * this.xFactor)));
                int n20 = this.fontLabelMetrics.stringWidth(string);
                graphics.drawString(string, this.view.scrX(d11) - n20 / 2, n4);
            }
        }
    }

    public synchronized Dimension getMinimumSize() {
        return this.dim;
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void paint(Graphics graphics) {
        Object object;
        if (!this.dim.equals(this.getSize())) {
            this.dim = this.getSize();
            this.view.setScr(this.borderSize.left + 2, this.borderSize.top, this.dim.width - this.borderSize.right - 1, this.dim.height - this.borderSize.bottom - 1);
            this.displayCtx.setGraphics(graphics);
        }
        super.repaint();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(this.view.getScrMinX(), this.view.getScrMinY(), this.view.getScrWidth(), this.view.getScrHeight());
        if (this.border) {
            graphics.setColor(this.borderColor);
            graphics.drawRect(this.view.getScrMinX() - 1, this.view.getScrMinY() - 1, this.view.getScrWidth() + 2, this.view.getScrHeight() + 2);
        }
        if (this.axes) {
            object = this.view.getUsrSize();
            double d = Math.pow(10.0, Math.round(0.4342944818 * Math.log(((Coordinate2D)object).getX())) - 1L);
            double d2 = Math.pow(10.0, Math.round(0.4342944818 * Math.log(((Coordinate2D)object).getY())) - 1L);
            this.drawAxes(graphics, d, d2, 7, 7, 10, true, true);
        }
        object = this.drawableItems.elements();
        while (object.hasMoreElements()) {
            ((Drawable)object.nextElement()).redrawAt(graphics, this.view);
        }
    }

    public void removeItem(Drawable drawable) {
        this.drawableItems.removeElement(drawable);
    }

    public void setAxesLabelFactor(double d, double d2) {
        this.xFactor = d;
        this.yFactor = d2;
    }

    public void setFontLabels(Font font) {
        this.fontLabel = font;
        this.fontLabelMetrics = ((Component)this).getFontMetrics(this.fontLabel);
    }

    public void update() {
        this.update(this.getGraphics());
    }
}

