/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.CircularGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class CircularGeneratorGI
extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    DoubleGI pulsationCtrl;
    DoubleGI dephasageCtrl;

    public CircularGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/cg_descr.gif", ""));
        this.offsetCtrl = new DoubleGI(0.0, 10, "Io  [uA]", 3, 2);
        this.amplitudeCtrl = new DoubleGI(1.0, 10, "A   [uA]", 3, 2);
        this.pulsationCtrl = new DoubleGI(50.0, 10, "w   [Hz]", 3, 2);
        this.dephasageCtrl = new DoubleGI(0.0, 10, "theta 0 [\u00ba]", 3, 2);
        this.pulsationCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.makeInterface();
        this.makeToolTip();
    }

    public CircularGeneratorGI(CircularGenerator circularGenerator) {
        this();
        this.synchronizeSignifiant(circularGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.offsetCtrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/cg_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/cg_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.offsetCtrl);
        primitiveTypeGroup.add(this.amplitudeCtrl);
        primitiveTypeGroup.add(this.pulsationCtrl);
        primitiveTypeGroup.add(this.dephasageCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
        this.amplitudeCtrl.setToolTipText("Facteur d'amplitude.");
        this.pulsationCtrl.setToolTipText("Frequence d'oscillation (Pulsation).");
        this.dephasageCtrl.setToolTipText("Dephasage (angle initial de rotation).");
    }

    public void setFontLabels(Font font) {
        this.offsetCtrl.setFontLabels(font);
        this.amplitudeCtrl.setFontLabels(font);
        this.pulsationCtrl.setFontLabels(font);
        this.dephasageCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        CircularGenerator circularGenerator = (CircularGenerator)object;
        this.offsetCtrl.setValue(circularGenerator.getOffset() * 1000000.0);
        this.amplitudeCtrl.setValue(circularGenerator.getAmplitude() * 1000000.0);
        this.pulsationCtrl.setValue(circularGenerator.getPulsation());
        this.dephasageCtrl.setValue(circularGenerator.getDephasage() * 180.0 / Math.PI);
    }

    public void synchronizeSignifie(Object object) {
        CircularGenerator circularGenerator = (CircularGenerator)object;
        circularGenerator.setOffset(this.offsetCtrl.getValue() * 1.0E-6);
        circularGenerator.setAmplitude(this.amplitudeCtrl.getValue() * 1.0E-6);
        circularGenerator.setPulsation(this.pulsationCtrl.getValue());
        circularGenerator.setDephasage(this.dephasageCtrl.getValue() * Math.PI / 180.0);
    }
}

