/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.DiscreteNoisyGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class DiscreteNoisyGeneratorGI
extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    LongGI seedCtrl;

    public DiscreteNoisyGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/dng_descr.gif", ""));
        this.offsetCtrl = new DoubleGI(0.0, 10, "Io  [uA]", 3, 2);
        this.amplitudeCtrl = new DoubleGI(1.0, 10, "A max[uA]", 3, 2);
        this.seedCtrl = new LongGI(0L, 10, "Nb. Aleatoire", 3, 2);
        this.seedCtrl.onBack();
        this.makeInterface();
        this.makeToolTip();
    }

    public DiscreteNoisyGeneratorGI(DiscreteNoisyGenerator discreteNoisyGenerator) {
        this();
        this.synchronizeSignifiant(discreteNoisyGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.offsetCtrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/dng_symbolic_S.gif", "Symbolic Selected Icon")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/dng_symbolic_U.gif", "Symbolic Unselected Icon"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.offsetCtrl);
        primitiveTypeGroup.add(this.amplitudeCtrl);
        primitiveTypeGroup.add(this.seedCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
        this.amplitudeCtrl.setToolTipText("Facteur d'amplitude.");
        this.seedCtrl.setToolTipText("Graine du generateur aleatoire.");
    }

    public void setFontLabels(Font font) {
        this.offsetCtrl.setFontLabels(font);
        this.amplitudeCtrl.setFontLabels(font);
        this.seedCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        DiscreteNoisyGenerator discreteNoisyGenerator = (DiscreteNoisyGenerator)object;
        this.offsetCtrl.setValue(discreteNoisyGenerator.getOffset() * 1000000.0);
        this.amplitudeCtrl.setValue(discreteNoisyGenerator.getAmplitude() * 1000000.0);
        this.seedCtrl.setValue(discreteNoisyGenerator.getSeed());
    }

    public void synchronizeSignifie(Object object) {
        DiscreteNoisyGenerator discreteNoisyGenerator = (DiscreteNoisyGenerator)object;
        discreteNoisyGenerator.setOffset(this.offsetCtrl.getValue() * 1.0E-6);
        discreteNoisyGenerator.setAmplitude(this.amplitudeCtrl.getValue() * 1.0E-6);
        discreteNoisyGenerator.setSeed(this.seedCtrl.getValue());
    }
}

