/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import com.objectspace.jgl.Pair;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.GraphicalInterface;
import spikingneuron.userinterface.UnsupportedSynchronization;

public abstract class NeuronBaseModelGI
extends JPanel
implements GraphicalInterface {
    protected Pair symbolic = new Pair(this.getSymbolicIcon(false), this.getSymbolicIcon(true));
    protected JComponent description = null;
    protected DoubleGI mThresholdCtrl = null;
    protected DoubleGI gThresholdCtrl = null;
    protected DoubleGI mRefractoryTimeCtrl = null;
    protected DoubleGI gRefractoryTimeCtrl = null;
    protected DoubleGI resistanceCtrl = null;
    protected DoubleGI tauSynapticCtrl = null;
    protected DoubleGI noiseCtrl = null;

    protected NeuronBaseModelGI() {
    }

    public JComponent getDescription() {
        return this.description;
    }

    public Font getFontLabels() {
        return this.mThresholdCtrl.getFontLabels();
    }

    public JComponent getInterface() {
        return this;
    }

    public Object getSymbolic() {
        return this.symbolic;
    }

    protected abstract JLabel getSymbolicIcon(boolean var1);

    protected void makeToolTip() {
        this.mThresholdCtrl.setToolTipText("Valeur moyenne du seuil au-dela duquel un spike est emis [mV].");
        this.gThresholdCtrl.setToolTipText("Ecart-type du seuil d'emission des spikes [mV].");
        this.resistanceCtrl.setToolTipText("Valeur de la resistance du modele [MOhms].");
        this.tauSynapticCtrl.setToolTipText("Constante de temps de la synapse [ms].");
        this.noiseCtrl.setToolTipText("Amplitude maximale du courant de bruit [uA].");
        this.mRefractoryTimeCtrl.setToolTipText("Duree moyenne des periodes refractaires absolues [ms].");
        this.gRefractoryTimeCtrl.setToolTipText("Ecart-type de la dur\u00e9e des periodes refractaires absolues [ms].");
    }

    public void setFontLabels(Font font) {
        this.mThresholdCtrl.setFontLabels(font);
        this.gThresholdCtrl.setFontLabels(font);
        this.mRefractoryTimeCtrl.setFontLabels(font);
        this.gRefractoryTimeCtrl.setFontLabels(font);
        this.resistanceCtrl.setFontLabels(font);
        this.tauSynapticCtrl.setFontLabels(font);
        this.noiseCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant() throws UnsupportedSynchronization {
        throw new UnsupportedSynchronization();
    }

    public abstract void synchronizeSignifiant(Object var1);

    protected void synchronizeSignifiant(NeuronBaseModel neuronBaseModel) {
        this.mThresholdCtrl.setValue(neuronBaseModel.getMeanThreshold() * 1000.0);
        this.gThresholdCtrl.setValue(neuronBaseModel.getGapThreshold() * 1000.0);
        this.resistanceCtrl.setValue(neuronBaseModel.getResistance() * 1.0E-6);
        this.tauSynapticCtrl.setValue(neuronBaseModel.getTauSynaptic() * 1000.0);
        this.noiseCtrl.setValue(neuronBaseModel.getNoiseAmplitude() * 1000000.0);
        this.mRefractoryTimeCtrl.setValue(neuronBaseModel.getMeanAbsoluteRefractoryTime() * 1000.0);
        this.gRefractoryTimeCtrl.setValue(neuronBaseModel.getGapAbsoluteRefractoryTime() * 1000.0);
    }

    public void synchronizeSignifie() throws UnsupportedSynchronization {
        throw new UnsupportedSynchronization();
    }

    public abstract void synchronizeSignifie(Object var1);

    protected void synchronizeSignifie(NeuronBaseModel neuronBaseModel) {
        neuronBaseModel.setThreshold(this.mThresholdCtrl.getValue() * 0.001, this.gThresholdCtrl.getValue() * 0.001);
        neuronBaseModel.setResistance(this.resistanceCtrl.getValue() * 1000000.0);
        neuronBaseModel.setTauSynaptic(this.tauSynapticCtrl.getValue() * 0.001);
        neuronBaseModel.setNoiseAmplitude(this.noiseCtrl.getValue() * 1.0E-6);
        neuronBaseModel.setAbsoluteRefractoryTime(this.mRefractoryTimeCtrl.getValue() * 0.001, this.gRefractoryTimeCtrl.getValue() * 0.001);
    }
}

