/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.NoisyGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class NoisyGeneratorGI
extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    LongGI nbSinusCtrl;
    LongGI seedCtrl;

    public NoisyGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/ng_descr.gif", ""));
        this.offsetCtrl = new DoubleGI(0.0, 10, "Io  [uA]", 3, 2);
        this.amplitudeCtrl = new DoubleGI(1.0, 10, "A max[uA]", 3, 2);
        this.nbSinusCtrl = new LongGI(10L, 10, "Nb sinus", 3, 2);
        this.seedCtrl = new LongGI(0L, 10, "Nb. Aleatoire", 3, 2);
        this.nbSinusCtrl.setValidityDomaine(1L, Long.MAX_VALUE);
        this.seedCtrl.onBack();
        this.makeInterface();
        this.makeToolTip();
    }

    public NoisyGeneratorGI(NoisyGenerator noisyGenerator) {
        this();
        this.synchronizeSignifiant(noisyGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.offsetCtrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/ng_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/ng_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.offsetCtrl);
        primitiveTypeGroup.add(this.amplitudeCtrl);
        primitiveTypeGroup.add(this.nbSinusCtrl);
        primitiveTypeGroup.add(this.seedCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
        this.amplitudeCtrl.setToolTipText("Facteur d'amplitude.");
        this.nbSinusCtrl.setToolTipText("Nb de courbes sinusoidales composant le signal.");
        this.seedCtrl.setToolTipText("Graine du generateur aleatoire.");
    }

    public void setFontLabels(Font font) {
        this.offsetCtrl.setFontLabels(font);
        this.amplitudeCtrl.setFontLabels(font);
        this.nbSinusCtrl.setFontLabels(font);
        this.seedCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        NoisyGenerator noisyGenerator = (NoisyGenerator)object;
        this.offsetCtrl.setValue(noisyGenerator.getOffset() * 1000000.0);
        this.amplitudeCtrl.setValue(noisyGenerator.getAmplitude() * 1000000.0);
        this.nbSinusCtrl.setValue(noisyGenerator.getNbSinus());
        this.seedCtrl.setValue(noisyGenerator.getSeed());
    }

    public void synchronizeSignifie(Object object) {
        NoisyGenerator noisyGenerator = (NoisyGenerator)object;
        noisyGenerator.setOffset(this.offsetCtrl.getValue() * 1.0E-6);
        noisyGenerator.setAmplitude(this.amplitudeCtrl.getValue() * 1.0E-6);
        noisyGenerator.setNbSinus((int)this.nbSinusCtrl.getValue());
        noisyGenerator.setSeed(this.seedCtrl.getValue());
    }
}

