/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.PulsesGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class PulsesGeneratorGI
extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    LongGI nbPulsesCtrl;
    LongGI pulseWidthCtrl;

    public PulsesGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/pg_descr.gif", ""));
        this.offsetCtrl = new DoubleGI(0.0, 10, "Io  [uA]", 3, 2);
        this.amplitudeCtrl = new DoubleGI(1.0, 10, "A   [uA]", 3, 2);
        this.nbPulsesCtrl = new LongGI(10L, 10, "Nb. pulsation", 3, 2);
        this.pulseWidthCtrl = new LongGI(0L, 10, "(largeur [tic])", 3, 2);
        this.nbPulsesCtrl.setValidityDomaine(0L, Long.MAX_VALUE);
        this.pulseWidthCtrl.setValidityDomaine(1L, Long.MAX_VALUE);
        this.pulseWidthCtrl.onBack();
        this.makeInterface();
        this.makeToolTip();
    }

    public PulsesGeneratorGI(PulsesGenerator pulsesGenerator) {
        this();
        this.synchronizeSignifiant(pulsesGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.offsetCtrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/pg_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/pg_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.offsetCtrl);
        primitiveTypeGroup.add(this.amplitudeCtrl);
        primitiveTypeGroup.add(this.nbPulsesCtrl);
        primitiveTypeGroup.add(this.pulseWidthCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
        this.amplitudeCtrl.setToolTipText("Courant d'impulsion.");
        this.nbPulsesCtrl.setToolTipText("Nb d'impulsions a generer.");
        this.pulseWidthCtrl.setToolTipText("Largeur des impulsions (en tic).");
    }

    public void setFontLabels(Font font) {
        this.offsetCtrl.setFontLabels(font);
        this.amplitudeCtrl.setFontLabels(font);
        this.nbPulsesCtrl.setFontLabels(font);
        this.pulseWidthCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        PulsesGenerator pulsesGenerator = (PulsesGenerator)object;
        this.offsetCtrl.setValue(pulsesGenerator.getOffset() * 1000000.0);
        this.amplitudeCtrl.setValue(pulsesGenerator.getPulseAmplitude() * 1000000.0);
        this.nbPulsesCtrl.setValue(pulsesGenerator.getNbPulses());
        this.pulseWidthCtrl.setValue(pulsesGenerator.getPulseWidth());
    }

    public void synchronizeSignifie(Object object) {
        PulsesGenerator pulsesGenerator = (PulsesGenerator)object;
        pulsesGenerator.setOffset(this.offsetCtrl.getValue() * 1.0E-6);
        pulsesGenerator.setPulseAmplitude(this.amplitudeCtrl.getValue() * 1.0E-6);
        pulsesGenerator.setNbPulses((int)this.nbPulsesCtrl.getValue());
        pulsesGenerator.setPulseWidth((int)this.pulseWidthCtrl.getValue());
    }
}

