/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.RandomPulsesGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class RandomPulsesGeneratorGI
extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    DoubleGI lambdaCtrl;
    LongGI pulseWidthCtrl;
    LongGI seedCtrl;

    public RandomPulsesGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/rp_descr.gif", ""));
        this.offsetCtrl = new DoubleGI(0.0, 10, "Io  [uA]", 3, 2);
        this.amplitudeCtrl = new DoubleGI(1.0, 10, "A   [uA]", 3, 2);
        this.lambdaCtrl = new DoubleGI(10.0, 10, "lambda", 3, 2);
        this.pulseWidthCtrl = new LongGI(0L, 10, "(Largeur [tic])", 3, 2);
        this.seedCtrl = new LongGI(0L, 10, "Nb. Aleatoire", 3, 2);
        this.pulseWidthCtrl.setValidityDomaine(1L, Long.MAX_VALUE);
        this.lambdaCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.pulseWidthCtrl.onBack();
        this.seedCtrl.onBack();
        this.makeInterface();
        this.makeToolTip();
    }

    public RandomPulsesGeneratorGI(RandomPulsesGenerator randomPulsesGenerator) {
        this();
        this.synchronizeSignifiant(randomPulsesGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.offsetCtrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/rp_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/rp_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.offsetCtrl);
        primitiveTypeGroup.add(this.amplitudeCtrl);
        primitiveTypeGroup.add(this.lambdaCtrl);
        primitiveTypeGroup.add(this.pulseWidthCtrl);
        primitiveTypeGroup.add(this.seedCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
        this.amplitudeCtrl.setToolTipText("Courant d'impulsion.");
        this.lambdaCtrl.setToolTipText("Parametre de la distr. exponentielle.");
        this.pulseWidthCtrl.setToolTipText("Largeur des impulsions (en tic).");
        this.seedCtrl.setToolTipText("Graine du generateur aleatoire.");
    }

    public void setFontLabels(Font font) {
        this.offsetCtrl.setFontLabels(font);
        this.amplitudeCtrl.setFontLabels(font);
        this.lambdaCtrl.setFontLabels(font);
        this.pulseWidthCtrl.setFontLabels(font);
        this.seedCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        RandomPulsesGenerator randomPulsesGenerator = (RandomPulsesGenerator)object;
        this.offsetCtrl.setValue(randomPulsesGenerator.getOffset() * 1000000.0);
        this.amplitudeCtrl.setValue(randomPulsesGenerator.getPulseAmplitude() * 1000000.0);
        this.lambdaCtrl.setValue(randomPulsesGenerator.getLambda());
        this.pulseWidthCtrl.setValue(randomPulsesGenerator.getPulseWidth());
        this.seedCtrl.setValue(randomPulsesGenerator.getSeed());
    }

    public void synchronizeSignifie(Object object) {
        RandomPulsesGenerator randomPulsesGenerator = (RandomPulsesGenerator)object;
        randomPulsesGenerator.setOffset(this.offsetCtrl.getValue() * 1.0E-6);
        randomPulsesGenerator.setPulseAmplitude(this.amplitudeCtrl.getValue() * 1.0E-6);
        randomPulsesGenerator.setLambda(this.lambdaCtrl.getValue());
        randomPulsesGenerator.setPulseWidth((int)this.pulseWidthCtrl.getValue());
        randomPulsesGenerator.setSeed(this.seedCtrl.getValue());
    }
}

