/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.neurons.SRMLongMemory;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.NeuronBaseModelGI;

public class SRMLongMemoryGI
extends NeuronBaseModelGI {
    DoubleGI eta0Ctrl;
    DoubleGI tauEtaCtrl;

    public SRMLongMemoryGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/srl_descr.gif", ""));
        this.mThresholdCtrl = new DoubleGI(0.0, 5, "Thrsh [mV]", 3, 2);
        this.gThresholdCtrl = new DoubleGI(0.0, 5, "gap ", 3, 2);
        this.mRefractoryTimeCtrl = new DoubleGI(0.0, 5, "Refr. [ms]", 3, 2);
        this.gRefractoryTimeCtrl = new DoubleGI(0.0, 5, "gap ", 3, 2);
        this.resistanceCtrl = new DoubleGI(0.0, 10, "R   [MOhm]", 3, 2);
        this.tauSynapticCtrl = new DoubleGI(0.0, 10, "Tau S [ms]", 3, 2);
        this.eta0Ctrl = new DoubleGI(0.0, 10, "Eta 0 [mV]", 3, 2);
        this.tauEtaCtrl = new DoubleGI(0.0, 10, "Tau Eta[ms]", 3, 2);
        this.noiseCtrl = new DoubleGI(0.0, 5, "Courant du bruit [uA]", 3, 2);
        this.gThresholdCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.mRefractoryTimeCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.gRefractoryTimeCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.resistanceCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.tauSynapticCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.noiseCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.tauEtaCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
        this.makeInterface();
        this.makeToolTip();
    }

    public SRMLongMemoryGI(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this();
        this.mThresholdCtrl.setValue(d * 1000.0);
        this.gThresholdCtrl.setValue(d2 * 1000.0);
        this.mRefractoryTimeCtrl.setValue(d3 * 1000.0);
        this.gRefractoryTimeCtrl.setValue(d4 * 1000.0);
        this.resistanceCtrl.setValue(d5 * 1.0E-6);
        this.noiseCtrl.setValue(d9 * 1000000.0);
        this.tauSynapticCtrl.setValue(d6 * 1000.0);
        this.eta0Ctrl.setValue(d7 * 1000.0);
        this.tauEtaCtrl.setValue(d8 * 1000.0);
    }

    public SRMLongMemoryGI(SRMLongMemory sRMLongMemory) {
        this();
        this.synchronizeSignifiant((Object)sRMLongMemory);
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/srl_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/srl_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 5, 5, 0, 0, 10, 1.0, 0.0));
        this.add((Component)this.mThresholdCtrl.label, constraints.setAndGet(0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.mThresholdCtrl.signifiant, constraints.setAndGet(1, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 0.5, 0.1));
        this.add((Component)this.gThresholdCtrl.label, constraints.setAndGet(2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.0, 0.1));
        this.add((Component)this.gThresholdCtrl.signifiant, constraints.setAndGet(3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 13, 0.5, 0.1));
        this.add((Component)this.mRefractoryTimeCtrl.label, constraints.setAndGet(0, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.mRefractoryTimeCtrl.signifiant, constraints.setAndGet(1, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 0.5, 0.1));
        this.add((Component)this.gRefractoryTimeCtrl.label, constraints.setAndGet(2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.0, 0.1));
        this.add((Component)this.gRefractoryTimeCtrl.signifiant, constraints.setAndGet(3, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0, 13, 0.5, 0.1));
        this.add((Component)this.resistanceCtrl.label, constraints.setAndGet(0, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.resistanceCtrl.signifiant, constraints.setAndGet(1, 3, 0, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.1));
        this.add((Component)this.tauSynapticCtrl.label, constraints.setAndGet(0, 4, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.tauSynapticCtrl.signifiant, constraints.setAndGet(1, 4, 0, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.1));
        this.add((Component)this.eta0Ctrl.label, constraints.setAndGet(0, 5, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.eta0Ctrl.signifiant, constraints.setAndGet(1, 5, 0, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.1));
        this.add((Component)this.tauEtaCtrl.label, constraints.setAndGet(0, 6, 1, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0.0, 0.1));
        this.add((Component)this.tauEtaCtrl.signifiant, constraints.setAndGet(1, 6, 0, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.1));
        this.add((Component)this.noiseCtrl.label, constraints.setAndGet(0, 7, 2, 1, 2, 0, 0, 0, 0, 0, 0, 17, 0.5, 0.1));
        this.add((Component)this.noiseCtrl.signifiant, constraints.setAndGet(2, 7, 0, 1, 2, 0, 0, 0, 0, 0, 0, 10, 0.5, 0.1));
    }

    protected void makeToolTip() {
        super.makeToolTip();
        this.eta0Ctrl.setToolTipText("Valeur initiale de la composante inhibitrice.");
        this.tauEtaCtrl.setToolTipText("Constante de temps de la comp. inhibitrice.");
    }

    public void setFontLabels(Font font) {
        super.setFontLabels(font);
        this.eta0Ctrl.setFontLabels(font);
        this.tauEtaCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        SRMLongMemory sRMLongMemory = (SRMLongMemory)object;
        super.synchronizeSignifiant(sRMLongMemory);
        this.eta0Ctrl.setValue(sRMLongMemory.getEta0() * 1000.0);
        this.tauEtaCtrl.setValue(sRMLongMemory.getTauEta() * 1000.0);
    }

    public void synchronizeSignifie(Object object) {
        SRMLongMemory sRMLongMemory = (SRMLongMemory)object;
        super.synchronizeSignifie(sRMLongMemory);
        sRMLongMemory.setEta0(this.eta0Ctrl.getValue() * 0.001);
        sRMLongMemory.setTauEta(this.tauEtaCtrl.getValue() * 0.001);
    }
}

