/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.SquareGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class SquareGeneratorGI
extends SignalGeneratorGI {
    DoubleGI[] currentsCtrl;
    DoubleGI[] timingCtrl;

    public SquareGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/sg_descr.gif", ""));
        this.timingCtrl = new DoubleGI[8];
        this.currentsCtrl = new DoubleGI[3];
        this.currentsCtrl[0] = new DoubleGI(0.0, 5, "Io", 3, 2);
        this.currentsCtrl[1] = new DoubleGI(0.0, 5, "Ih", 3, 2);
        this.currentsCtrl[2] = new DoubleGI(0.0, 5, "Il", 3, 2);
        int n = 0;
        while (n < 8) {
            this.timingCtrl[n] = new DoubleGI(0.0, 5, "t" + (n + 1), 3, 2);
            this.timingCtrl[n].setValidityDomaine(0.0, Double.MAX_VALUE);
            ++n;
        }
        this.makeInterface();
        this.makeToolTip();
    }

    public SquareGeneratorGI(SquareGenerator squareGenerator) {
        this();
        this.synchronizeSignifiant(squareGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.currentsCtrl[0].getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/sg_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/sg_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)this.currentsCtrl[0].label, constraints.setAndGet(2, 1, 1, 1, 0, 0, 0, 0, 0, 3, 1, 13, 0.0, 0.1));
        this.add((Component)this.currentsCtrl[0].signifiant, constraints.setAndGet(3, 1, 1, 1, 2, 0, 0, 0, 0, 1, 0, 11, 0.5, 0.1));
        this.add((Component)this.currentsCtrl[1].label, constraints.setAndGet(0, 2, 1, 1, 0, 0, 0, 0, 0, 0, 1, 17, 0.0, 0.1));
        this.add((Component)this.currentsCtrl[1].signifiant, constraints.setAndGet(1, 2, 1, 1, 2, 0, 0, 0, 0, 1, 1, 17, 0.5, 0.1));
        this.add((Component)this.currentsCtrl[2].label, constraints.setAndGet(2, 2, 1, 1, 0, 0, 0, 0, 0, 3, 1, 13, 0.0, 0.1));
        this.add((Component)this.currentsCtrl[2].signifiant, constraints.setAndGet(3, 2, 1, 1, 2, 0, 0, 0, 0, 1, 0, 11, 0.5, 0.1));
        int n = 0;
        while (n < this.timingCtrl.length) {
            this.add((Component)this.timingCtrl[n].label, constraints.setAndGet(0, 3 + n, 1, 1, 0, 0, 0, 0, 0, 0, 1, 17, 0.0, 0.1));
            this.add((Component)this.timingCtrl[n++].signifiant, constraints.setAndGet(1, 2 + n, 1, 1, 2, 0, 0, 0, 0, 1, 1, 17, 0.5, 0.1));
            this.add((Component)this.timingCtrl[n].label, constraints.setAndGet(2, 2 + n, 1, 1, 0, 0, 0, 0, 0, 1, 1, 13, 0.0, 0.1));
            this.add((Component)this.timingCtrl[n++].signifiant, constraints.setAndGet(3, 1 + n, 1, 1, 2, 0, 0, 0, 0, 1, 0, 11, 0.5, 0.1));
        }
    }

    protected void makeToolTip() {
        this.currentsCtrl[0].setToolTipText("Courant d'offset (composante continue) [uA].");
        this.currentsCtrl[1].setToolTipText("Courant maximum [uA]");
        this.currentsCtrl[2].setToolTipText("Courant minimum [uA]");
        this.timingCtrl[0].setToolTipText("Duree de la 1ere phase, en milisecondes.");
        this.timingCtrl[1].setToolTipText("Duree de la 2nd phase, en milisecondes.");
        this.timingCtrl[2].setToolTipText("Duree de la 3nd phase, en milisecondes.");
        this.timingCtrl[3].setToolTipText("Duree de la 4nd phase, en milisecondes.");
        this.timingCtrl[4].setToolTipText("Duree de la 5nd phase, en milisecondes.");
        this.timingCtrl[5].setToolTipText("Duree de la 6nd phase, en milisecondes.");
        this.timingCtrl[6].setToolTipText("Duree de la 7nd phase, en milisecondes.");
        this.timingCtrl[7].setToolTipText("Duree de la 8nd phase, en milisecondes.");
    }

    public void setFontLabels(Font font) {
        int n = this.currentsCtrl.length;
        while (n > 0) {
            this.currentsCtrl[--n].setFontLabels(font);
        }
        int n2 = this.timingCtrl.length;
        while (n2 > 0) {
            this.timingCtrl[--n2].setFontLabels(font);
        }
    }

    public void synchronizeSignifiant(Object object) {
        SquareGenerator squareGenerator = (SquareGenerator)object;
        this.currentsCtrl[0].setValue(squareGenerator.getIOffset() * 1000000.0);
        this.currentsCtrl[1].setValue(squareGenerator.getIHigh() * 1000000.0);
        this.currentsCtrl[2].setValue(squareGenerator.getILow() * 1000000.0);
        int n = 0;
        while (n < 8) {
            this.timingCtrl[n].setValue(squareGenerator.getTiming(n) * 1000.0);
            ++n;
        }
    }

    public void synchronizeSignifie(Object object) {
        SquareGenerator squareGenerator = (SquareGenerator)object;
        squareGenerator.setIOffset(this.currentsCtrl[0].getValue() * 1.0E-6);
        squareGenerator.setIHigh(this.currentsCtrl[1].getValue() * 1.0E-6);
        squareGenerator.setILow(this.currentsCtrl[2].getValue() * 1.0E-6);
        int n = 0;
        while (n < 8) {
            squareGenerator.setTiming(n, this.timingCtrl[n].getValue() * 0.001);
            ++n;
        }
    }
}

