/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.userinterface;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import spikingneuron.generators.StepGenerator;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.SignalGeneratorGI;

public class StepGeneratorGI
extends SignalGeneratorGI {
    DoubleGI i0Ctrl;
    DoubleGI i1Ctrl;
    DoubleGI ratioCtrl;

    public StepGeneratorGI() {
        this.description = new JLabel(Tools.loadImageIcon(this.getClass(), "/images/stepg_descr.gif", ""));
        this.i0Ctrl = new DoubleGI(0.0, 10, "I initial [uA]", 3, 2);
        this.i1Ctrl = new DoubleGI(0.0, 10, "I final   [uA]", 3, 2);
        this.ratioCtrl = new DoubleGI(0.0, 10, "Temps du flanc [%]", 3, 2);
        this.ratioCtrl.setValidityDomaine(0.0, 100.0);
        this.makeInterface();
        this.makeToolTip();
    }

    public StepGeneratorGI(StepGenerator stepGenerator) {
        this();
        this.synchronizeSignifiant(stepGenerator);
        this.makeInterface();
        this.makeToolTip();
    }

    public Font getFontLabels() {
        return this.i0Ctrl.getFontLabels();
    }

    protected JLabel getSymbolicIcon(boolean bl) {
        return bl ? new JLabel(Tools.loadImageIcon(this.getClass(), "/images/stepg_symbolic_S.gif", "Symbolic Selected Icon representation")) : new JLabel(Tools.loadImageIcon(this.getClass(), "/images/stepg_symbolic_U.gif", "Symbolic Unselected Icon representation"));
    }

    protected void makeInterface() {
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.i0Ctrl);
        primitiveTypeGroup.add(this.i1Ctrl);
        primitiveTypeGroup.add(this.ratioCtrl);
        this.setLayout(new GridBagLayout());
        Constraints constraints = new Constraints();
        this.add((Component)this.description, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 10, 10, 0, 0, 10, 1.0, 0.0));
        this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
    }

    protected void makeToolTip() {
        this.i0Ctrl.setToolTipText("Courant de la premiere partie du signal.");
        this.i1Ctrl.setToolTipText("Courant de la seconde (derniere) partie du signal");
        this.ratioCtrl.setToolTipText("Moment d'occurence du flanc, en % par rapport au temps total simule.");
    }

    public void setFontLabels(Font font) {
        this.i0Ctrl.setFontLabels(font);
        this.i1Ctrl.setFontLabels(font);
        this.ratioCtrl.setFontLabels(font);
    }

    public void synchronizeSignifiant(Object object) {
        StepGenerator stepGenerator = (StepGenerator)object;
        this.i0Ctrl.setValue(stepGenerator.getInitialCurrent() * 1000000.0);
        this.i1Ctrl.setValue(stepGenerator.getFinalCurrent() * 1000000.0);
        this.ratioCtrl.setValue(stepGenerator.getRaiseTimeRatio() * 100.0);
    }

    public void synchronizeSignifie(Object object) {
        StepGenerator stepGenerator = (StepGenerator)object;
        stepGenerator.setInitialCurrent(this.i0Ctrl.getValue() * 1.0E-6);
        stepGenerator.setFinalCurrent(this.i1Ctrl.getValue() * 1.0E-6);
        stepGenerator.setRaiseTimeRatio(this.ratioCtrl.getValue() * 0.01);
    }
}

