/*
Rem: attention avec les innerclass... une excution dans l'appletviewer ou,
semble-t'il avec un butineur (en tout cas les versions b) requiert imprativement
le nom complet des classes lors de la cration:  inner is new ParentClass.InnerClass
Par contre, cela n'est pas ncessaire pour une application normale
- selon le Manuel de Ref du langage, une dclaration: inner is new InnerClass dans un
bloc de la classe ParentClass est tout  fait licite, d'ailleur cela ne pose pas de
problme  la compilation... mais  l'excution sous butineurs... (bug sans doute corrig
dans les versions futures).
*/

package spikingneuron;

import java.awt.*;
import java.util.*;
import java.applet.*;
import java.awt.event.*;
import javax.swing.*; 
import javax.swing.event.*; 
import javax.swing.border.*; 

import com.objectspace.jgl.Pair;
import com.objectspace.jgl.adapters.ObjectArray;

import spikingneuron.math.*;
import spikingneuron.tools.*;
import spikingneuron.neurons.*;
import spikingneuron.drawable.*;
import spikingneuron.generators.*;
import spikingneuron.userinterface.*;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base de l'application 'NeuralNetwork', permettant de visualiser l'activit d'une population
* de neurones interconnects suivant une topologie rgulire.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Dans l'tat actuel des choses, le rseau est constitu de neurones strictement identiques (mme modle, et mmes
* paramtres). Les connextions sont rgulires, et toutes ont les mme paramtres (w, deltaAx), exception bien sur
* des lments connects. <BR>
* <P>
* L'activit initiale et gnre par n pas de (pr)simultation dans une configuration donne (le gnrateur externe
* de courant ainsi que les neurones auxquelle il est reli est spcifiquement paramtrable).
* c.f. remarque gnrale de <CODE>'NeuronBaseModel'</CODE>.
* <P>
* L'affichage du rseaux ainsi que des neurones est vraiment 'bricol'. Il faudrait revoir compltement cette partie,
* en efectuant 'manuellement' le trac des connexions (surtout si l'on ajoute la possibilit de les modifier
* sparment). La seule chose qui serait  reprendre est la technique du double-buffer.
* Rem: Cette classe n'est pas directement concerne par l'affichage. Celui-ci est ralis au niveau des classes
* 'NetworkView', 'IFDrawable', 'SRMShortDrawable' et 'SRMLongDrawable'.
* <P>
* Le coef. d'efficatit des synapses devrait certainement tre multipli par un facteur (1e-6 p. ex.).
* c.f. NeuralNetwork.NetworkUI.
* <P>
* L'implmentation de la classe permet l'excution de l'application via l'interpreteur Java (avec la
* commande <CODE>java spikingneuron.SingleNeuron</CODE> (en supposant que le classpath soit correct)),
* ou via un navigateur (butineur), la classe tant une extension de JApplet. Attention, il faut utiliser
* un navigateur qui supporte java 1.1, ainsi que les JFC (<I>swing</I>). <BR>
* Rem: lors de l'excution sous forme d'application (via l'interprteur), la rservation pralable de
* suffisemment de mmoire, ainsi que la dsactivation de la vrification des classes permettent d'acclrer
* sensiblement l'excution. <BR>
* (<B>Commande:</B><CODE> java -noverify -ms20m -mx40m spikingneuron.NeuralNetwork</CODE>).
* <P>
*/


public class NeuralNetwork extends JApplet implements Runnable {

    public static final double EPSILON = 1E-15; // -> 0

    // Attributs divers .................................................
    public boolean isAnApplet; // Flag discriminant l'exc. sous forme d'app.
    public Container cp; // Conteneur global.

    SignalGenerator generator; 			// Source externe de courant.
    SignalGenerator initialGenerator; 	// Gnrateur externe pour phase initiale
    PopulationActivity populationActivity;
    NeuronBaseModel[][] network; // ensemble de NeuronBaseModel.
	
    int netX, netY;

    JTabbedPane tabbedPane;

    // Elements de l'interface utilisateur ..........................
	

    // Les polices de l'application:
    public Font defaultFont;
    public Font boldFont;
    public Font bigFont;
    public Font bigBoldFont;
    public Font smallMonoFont;
    public Border loweredBorder;
    public Border raisedBorder;

    // Les controles globaux:
    NeuralNetwork.StartJButton computeBtn; // Le bouton permettant de lancer la simulation.
    NeuralNetwork.StopJButton stopBtn;

    DoubleGI time; // Temps simul.
    DoubleGI tMax; // Contrle permettant  l'utilisateur de fixer la borne max de la simulation.
    DoubleGI deltaT; // Contrle permettant  l'utilisateur de fixer le pas de la simulation.
    DoubleGI durationInitialPhase; // Contrle de la dure de l'activit initiale (temps ngatif).

    // Les composants de la fenetre: (JComponent)
    NetworkView networkView;
    NeuralNetwork.TitleCanvas headerCnv;
    NeuralNetwork.NetworkUI networkUI;
    NeuralNetwork.ExternalUI externalUI;
    NeuralNetwork.InitialExternalUI initialExternalUI;
    //La classe NeuronUI n'etant pas implemantee, il n'y a aucun besoin de l'afficher
    //Modifie par Sebastien Baehni
    //NeuralNetwork.NeuronUI neuronUI;
    NeuralNetwork.ActivityUI activityUI;
	
    // Les diffrentes courbes & canvas d'affichage:
    GraphCanvas		activityCnv;
    LineOfPoints	activityCurve;
    LineOfPoints	holdedActivityCurve;

    // Une reference sur moi
    NeuralNetwork neuralNetwork;

    // Application start point.............
    public static void main(String args[]) {
	// On cherche les dimensions de l'ecran de maniere a placer la fenetre au milieu de
	// l'ecran. Rajoute par Sebastien Baehni
	Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
	// On recr l'environnement d'une applet, except l'appel  init().
	NeuralNetwork applet = new NeuralNetwork();
	NeuralNetwork.PrimaryFrame window = applet.new PrimaryFrame("Reseau de spiking neurones");
	applet.realInit(); // applet.init() pour simuler un browser.
	window.getContentPane().add(BorderLayout.CENTER,applet); 
	window.pack();
	window.setLocation(Math.abs((dimension.width-window.getSize().width)/2),Math.abs((dimension.height-window.getSize().height)/2));
	window.show();
    }

    // Constructeur ..................	
    public NeuralNetwork()  { isAnApplet = false; }

    // Applet Life-Cycle: Start Point
    public final void init() { isAnApplet = true; realInit(); }

    public final void start() {}	

    // Initialisation .........................
    public final void realInit() {
	// Elements globaux susceptible d'etre utilis par tous les objets de l'app.
	defaultFont		= new Font("SanSerif", Font.PLAIN, 11);
	boldFont		= new Font("SanSerif", Font.BOLD, 11);
	bigFont			= new Font("Dialog", Font.PLAIN, 10);
	bigBoldFont		= new Font("Dialog", Font.BOLD, 10);
	smallMonoFont	= new Font("Monospaced", Font.PLAIN, 9);
	loweredBorder 	= BorderFactory.createLoweredBevelBorder();
	raisedBorder	= BorderFactory.createRaisedBevelBorder();
		
	network = null;
	netX = 0;
	netY = 0;
	populationActivity = new PopulationActivity(0,0.0);

	/* Creation des elements de l'interface */

	cp = getContentPane();
	cp.setLayout(new GridBagLayout());

	headerCnv = new NeuralNetwork.TitleCanvas();
	headerCnv.addActionListener(headerCnv);
	computeBtn = new NeuralNetwork.StartJButton();
	stopBtn = new NeuralNetwork.StopJButton();

	time = new DoubleGI(0.0,5,"Temps courant",DoubleGI.LABEL_AT_TOP,JLabel.CENTER);
	time.setFontLabels(defaultFont);
	time.setDecimales(5);
	time.setLimitedDecimales(true);
	time.field.setOpaque(true);
	time.field.setEditable(false);
	time.field.setHorizontalAlignment(JLabel.CENTER);
	time.setToolTipText("Horloge de la simulation.");

	tMax = new DoubleGI(200,10,"Temps [ms]",DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	tMax.setFontLabels(defaultFont);
	tMax.setValidityDomaine(EPSILON,Double.MAX_VALUE);
	tMax.setToolTipText("Temps maximum de la simulation.");

	deltaT = new DoubleGI(0.5,10,"delta t [ms]",DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	deltaT.onBack();
	deltaT.setFontLabels(defaultFont);
	deltaT.setValidityDomaine(EPSILON,Double.MAX_VALUE);
	deltaT.setToolTipText("Pas d'integration (discretisation).");
		
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(tMax);
	controlGrp.add(deltaT);
		
	// Espace d'affichage du rseau ...................
	networkView = new NetworkView(500,300,defaultFont);
	networkView.setBorder(new EtchedBorder());

	// Controles du panneau central
	//Modifie par Sebastien Baehni. On n'ajoute pas une classe non implementee
	//neuronUI = new NeuralNetwork.NeuronUI();
	networkUI = new NeuralNetwork.NetworkUI();
	externalUI = new NeuralNetwork.ExternalUI();
	initialExternalUI = new NeuralNetwork.InitialExternalUI();
	// Panneau d'affichage et controle de l'activit de la population.
	activityUI = new NeuralNetwork.ActivityUI();

	// Panneau des controls (et non de controle !) ...........
	tabbedPane = new JTabbedPane();
	tabbedPane.addTab(networkUI.getTitle(), networkUI.getIcon(), networkUI, networkUI.getToolTip());
	tabbedPane.addTab(externalUI.getTitle(), externalUI.getIcon(), externalUI, externalUI.getToolTip());
	tabbedPane.addTab(initialExternalUI.getTitle(), initialExternalUI.getIcon(),
			  initialExternalUI, initialExternalUI.getToolTip());
	//Modifie par Sebastien Baehni. On ajoute pas un tab que l'on ne peut jamais selectionner.
	//tabbedPane.addTab(neuronUI.getTitle(), neuronUI.getIcon(), neuronUI, neuronUI.getToolTip());
	tabbedPane.setSelectedIndex(0);
	//Modifie par Sebastien Baehni. Idem.
	//tabbedPane.setEnabledAt(3,false);
	tabbedPane.setFont(defaultFont);
		
	/* Composition de la fenetre */
	Constraints gbConstraints = new Constraints();
	cp.add(headerCnv,
	       gbConstraints.setAndGet(0,0,
				       1,1,
				       Constraints.HORIZONTAL,
				       0,0,
				       0,0,0,0,
				       Constraints.WEST,
				       0.1, 0.0));

	//  Composition du groupe des controles................

	cp.add(controlGrp,
	       gbConstraints.setAndGet(1,0,
				       1,1,
				       Constraints.HORIZONTAL,
				       0,0,
				       0,0,4,4,
				       Constraints.CENTER,
				       0.4, 0.0));

	cp.add(time,
	       gbConstraints.setAndGet(2,0,
				       1,1,
				       Constraints.HORIZONTAL,
				       0,0,
				       0,0,4,4,
				       Constraints.WEST,
				       0.2, 0.0));

	cp.add(computeBtn,
	       gbConstraints.setAndGet(3,0,
				       Constraints.RELATIVE,1,
				       Constraints.HORIZONTAL,
				       0,0,
				       0,0,1,0,
				       Constraints.EAST,
				       0.3, 0.0));
	cp.add(stopBtn,
	       gbConstraints.setAndGet(4,0,
				       Constraints.REMAINDER,1,
				       Constraints.HORIZONTAL,
				       0,0,
				       0,0,1,0,
				       Constraints.EAST,
				       0.3, 0.0));
	cp.add(networkView,
	       gbConstraints.setAndGet(0, 1,
				       Constraints.REMAINDER, 1,
				       Constraints.BOTH,
				       0,0,
				       2,2,2,2,
				       Constraints.CENTER,
				       1.0, 0.3));
	cp.add(tabbedPane,
	       gbConstraints.setAndGet(0, 2,
				       1, 1,
				       Constraints.NONE,
				       0,0,
				       2,0,2,2,
				       Constraints.CENTER,
				       0.0, 1.0)); // 0.1, 0.7));
	cp.add(activityUI,
	       gbConstraints.setAndGet(1,2,
				       Constraints.REMAINDER,1,
				       Constraints.BOTH,
				       0,0,
				       2,0,2,2,
				       Constraints.CENTER,
				       1.0, 1.0)); // 0.9, 0.7));


	// Activation & Paramtrage des tooltip.
	ToolTipManager.sharedInstance().setEnabled(true);
	ToolTipManager.sharedInstance().setInitialDelay(1000);
	ToolTipManager.sharedInstance().setDismissDelay(8000);
	ToolTipManager.sharedInstance().setReshowDelay(2000);

	neuralNetwork = this;
    }    	

    public void run() {
	double minT = durationInitialPhase.getValue()*-1e-3; // Dure de la phase initiale;
	double maxT = tMax.getValue()*1e-3; // Dure maximum simule.
	double dt = deltaT.getValue()*1e-3; // delta t. (Largeur de la portion temporelle)
	Graphics timeGrpCtx = time.signifiant.getGraphics();

	boolean initialPhase = minT<0.0;

	populationActivity.setDeltaT(dt);
	Clock.sharedInstance.setDeltaT(dt);
		
	// Connection des neurones au gnrateur de la phase initiale.
	initialExternalUI.applyGenerator();
		
	// Rinitialisation du flux de donnes... par le biais d'une rinit. de ses agents.
	if (initialPhase) {
	    Clock.sharedInstance.setInitialTime(durationInitialPhase.getValue()*-1e-3);
	    Clock.sharedInstance.setMaximalTime(0.0);
	    initialGenerator.resetTime();
	} else {
	    Clock.sharedInstance.setInitialTime(0.0);
	    Clock.sharedInstance.setMaximalTime(maxT);
	    generator.resetTime();
	}

	Clock.sharedInstance.resetTime();
	populationActivity.resetTime();
	activityCurve.resetTime();
	for (int i = network.length; i>0; ) {
	    i--;
	    for (int j = network[0].length; j > 0; )
		network[i][--j].resetTime();
	}

	// Calcul des zones d'affichages des courbes... (estimation du rectangle englobant)
	// Borne pour l'activit: [(0,maxT),(0,1/dt)]

	activityCnv.changeVirtualBounds(0.02, 0, maxT, 0.05, 0, 1/dt);

	// Initialisation diverses.....
	activityCurve.ensureCapacity((int)(maxT/dt)); 
			
	// Actualisation de l'affichage
	activityCnv.update();

	// Le temps courant
	double currentTime = 0;
	
	if (initialPhase) {
	    // Phase initiale

	    while (Clock.sharedInstance.tic()) {
				// Traitement de la plage temporelle par les DataFlowAgent de la phase initiale		
		initialGenerator.computeNextTic();
		currentTime = Clock.sharedInstance.getTime();
		for (int i = network.length; i>0; ) {
		    i--;
		    for (int j = network[0].length; j>0; )
			network[i][--j].computeNextTic();
		}

				// Mise  jour des sortie de tous les DataFlowProducer (pseudo-simultanit)
		Clock.sharedInstance.updateOutput(); // pas vraiment ncessaire
		initialGenerator.updateOutput();
		for (int i = network.length; i>0; ) {
		    i--;
		    for (int j = network[0].length; j > 0; )
			network[i][--j].updateOutput();
		}

		time.setValue(currentTime*1e3);
		// Corrige par Sebastien Baehni
		//time.signifiant.update(timeGrpCtx);
		time.signifiant.repaint();
		networkView.repaintNeurons(); // Actualisation affichage.
	    }
	    Clock.sharedInstance.setInitialTime(0.0);
	    Clock.sharedInstance.setMaximalTime(maxT);
	    generator.resetTime();
	}


	// Phase finale (principale)
	NeuronBaseModel.resetFireCounter();
	externalUI.applyGenerator();
		
	while (Clock.sharedInstance.tic()) {
	    generator.computeNextTic();
	    currentTime = Clock.sharedInstance.getTime();
	    populationActivity.computeNextTic();
	    activityCurve.computeNextTic();
	    for (int i = network.length; i>0; ) {
		i--;
		for (int j = network[0].length; j>0; )
		    network[i][--j].computeNextTic();
	    }

	    // Mise  jour des sortie de tous les DataFlowProducer (pseudo-simultanit)
	    Clock.sharedInstance.updateOutput(); // pas vraiment ncessaire
	    generator.updateOutput();
	    populationActivity.updateOutput();
	    for (int i = network.length; i>0; ) {
		i--;
		for (int j = network[0].length; j > 0; )
		    network[i][--j].updateOutput();
	    }

	    time.setValue(currentTime*1e3);
	    // Corrige par Sebastien Baehni
	    //time.signifiant.update(timeGrpCtx);
	    time.signifiant.repaint();
	    networkView.repaintNeurons(); // Actualisation affichage.
	}



	// Pour terminer, il faut (r)afficher les courbes, re-centres et r-chelonnes.
	time.setValue(currentTime*1e3);

	// 1) Valeurs limites exactes, obtenues via les 'courbes'
	Coordinate2D activityRange = activityCurve.getVerticalBounds();
	Coordinate2D holdedRange = holdedActivityCurve.getVerticalBounds();

	// 2) Modif. pour inclure les axes
	activityRange.setC0(Math.min(0.0,activityRange.getC0()));
	activityRange.setC1(Math.max(0.0,activityRange.getC1()));
	activityRange.setC0(Math.min(activityRange.getC0(),holdedRange.getC1()));
	activityRange.setC1(Math.max(activityRange.getC1(),holdedRange.getC1()));

	if ((activityRange.getC1()-activityRange.getC0()<EPSILON)&&
	    (Math.abs(activityRange.getC0())<EPSILON)) {
	    activityRange.setC1(1.0);
	    activityRange.setC0(0.);
	}

	// 3) Mise  jour de la fonction affine de tranf. des coord.
	activityCnv.changeVirtualBounds(0.02, 0, maxT,
					0.1, activityRange.getC0(),activityRange.getC1());
	// 4) R-affichage.
	repaint();
    }
	

    /* Gnrateur de courant pour la phase de simulation */	

    private class ExternalUI extends JPanel implements ItemListener,ListSelectionListener {
	/*
	  Ide initiale: les neurones connects sont affichs dans la liste, et l'utilisateur peut en
	  ajouter / enlever, en les slectionnant (sur le rseau et dans la liste), et appuyer sur les
	  boutons add/remove suivant l'action  effectuer.
	  Prob: il faut pouvoir slectionner un (pls) neurone via le rseau, ce qui n'est pas compltement trivial...
	  Solution: (provisoire) la liste contient l'ensemble des neurones, et ceux slectionns sont connects.
	*/

	public JComboBox	 generatorsChoice;
	public JList list; // of NeuronBaseModel
	public DefaultListModel connected = new DefaultListModel();

	//		JButton			addBtn;  implmentation  raliser.
	//		JButton			removeBtn;

	JPanel cards;
	
	/*
	  Un ensemble de bouttons radio permet de slectionner/dselectionner directement tous les neurones
	  du rseaux (donc de connecter/dconnecter directement ces neurones).
	  La slection particulire est  effectuer 'manuellement', dans la liste.
	*/

	JRadioButton allRb; // Slection = connexion de tous les neurones.
	JRadioButton noneRb; // Slection vide = dconnexion de tous les neurons
	JRadioButton customRb; // Slection de l'utilisateur.
	ButtonGroup neuronSelectionMode; // Exclusion mutuelle des boutons radio.
	ExternalUI.NeuronSelectMode listener; // Modification de la slection (couteur).
		
	/* Les differentes instances de generateurs */
	CircularGenerator circularGenerator; 
	CircularGeneratorGI circularGenInterface;
	PositiveGenerator positiveGenerator;
	PositiveGeneratorGI positiveGenInterface;
	SquareGenerator	squareGenerator;	
	SquareGeneratorGI squareGenInterface;
	PulsesGenerator	pulsesGenerator;
	PulsesGeneratorGI pulsesGenInterface;
	RandomPulsesGenerator randomPulsesGenerator;	
	RandomPulsesGeneratorGI	randomPulsesGenInterface;
	NoisyGenerator noisyGenerator;			
	NoisyGeneratorGI noisyGenInterface;
	StepGenerator stepGenerator;
	StepGeneratorGI	stepGenInterface;
	DiscreteNoisyGenerator discreteNoisyGenerator;	
	DiscreteNoisyGeneratorGI discreteNoisyGenInterface;
	// ... les autres generateurs 

	SignalGeneratorGI generatorInterface; // source de courant actuellement slectionne.

	ExternalUI() {
	    super();
	    setLayout(new GridBagLayout());
	    Constraints contraintes = new Constraints();

	    TitledBorder title = new TitledBorder(
						  new EmptyBorder(0,0,0,0), "Parametre du courant externe",
						  TitledBorder.CENTER, TitledBorder.DEFAULT_POSITION, bigFont);
	    setBorder(title);
	    init(); // Creation des gnrateurs et du ComboBox.

	    // Generateur & Interface initiaux ..........................
	    generator = circularGenerator;
	    generatorInterface = circularGenInterface;
	    generatorsChoice.setSelectedItem(generatorInterface.getSymbolic());

	    // Construction du groupe de bouton radio ...................
	    allRb = new JRadioButton("Tous");
	    allRb.setFont(defaultFont);
	    allRb.setMnemonic('T');
	    noneRb = new JRadioButton("Aucun");
	    noneRb.setFont(defaultFont);
	    noneRb.setMnemonic('A');
	    customRb = new JRadioButton("Personnalise");
	    customRb.setFont(defaultFont);
	    customRb.setMnemonic('P');
	    allRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    allRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    noneRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    noneRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    customRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    customRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    neuronSelectionMode = new ButtonGroup();
	    neuronSelectionMode.add(allRb);
	    neuronSelectionMode.add(customRb);
	    neuronSelectionMode.add(noneRb);
	    noneRb.setSelected(true);
		
	    // Ajout des couteurs aux diffrents boutons ........................
	    listener = new ExternalUI.NeuronSelectMode();
	    allRb.addActionListener(listener);
	    noneRb.addActionListener(listener);
	    customRb.addActionListener(listener);

	    // Liste de slection des neurones connects
	    list = new JList(connected);
	    list.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	    list.addListSelectionListener(this);
	    JScrollPane listPane = new JScrollPane(list);
	  
	    netSizeChange(); // Update list selection & neurons input

	    // Composition du Panel global:
	    add(generatorsChoice,
		contraintes.setAndGet(0,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,2,2,
				      Constraints.NORTH,
				      0.75, 0.0));
	    add(cards,
		contraintes.setAndGet(0,1,
				      1,1,
				      Constraints.BOTH,
				      0,0,
				      0,0,2,2,
				      Constraints.CENTER,
				      0.75, 1.0));
	    /*
	      Bug de swing ou nouvelle fonctionnalit ? 
	      Normalement, il devrait tre possible d'utiliser un JSeparator pour une sparation verticale
	      (c.f. Swing Short Course, Part I, MageLang Institute, Java Developer Connection, Sun).
	      Dans l'tat actuel des chose, cela n'est pas possible (le sparateur est TOUJOURS horizontal);
	      peut-tre cette fonctionnalit est prvue pour de futures versions... ou  t supprime, ou
	      implmente diffremment ( l'aide d'une autre classe, puisque le JSeparator est originellement
	      prvu pour prendre place dans un menu droulant (quoique l galement, il se peut que l'on ait
	      besoin d'un sparateur vertical...)).
	    */
	    add(new JSeparator(),
		contraintes.setAndGet(1,0,
				      1,Constraints.REMAINDER,
				      Constraints.VERTICAL,
				      0,0, // Il faudrait rserver plus d'espace en x pour l'affichage....
				      2,2,4,4,
				      Constraints.CENTER,
				      0.1, 1.0));
	    add(allRb,
		contraintes.setAndGet(2,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,2,0,
				      Constraints.CENTER,
				      0.05, 0.0));
	    add(noneRb,
		contraintes.setAndGet(3,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,0,0,
				      Constraints.CENTER,
				      0.05, 0.0));
	    add(customRb,
		contraintes.setAndGet(4,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,0,0,
				      Constraints.CENTER,
				      0.05, 0.0));

	    add(listPane,
		contraintes.setAndGet(2,1,
				      Constraints.REMAINDER, Constraints.REMAINDER,
				      Constraints.BOTH,
				      0,0,
				      5,0,2,2,
				      Constraints.CENTER,
				      0.15, 1.0));

	}

	public void valueChanged(ListSelectionEvent e) {
	    // Modifie par Sebastien Baehni
	    int[] indices = list.getSelectedIndices();
	    if (indices.length == connected.getSize()) {
		allRb.setSelected(true);
	    }
	    else if(indices.length == 0) {
		noneRb.setSelected(true);
	    }
	    else {
		customRb.setSelected(true);
	    }	
	}
		
	public void itemStateChanged(ItemEvent e) {
	    ((CardLayout)cards.getLayout()).show(cards,
						 Integer.toString(generatorsChoice.getSelectedItem().hashCode()));
	    switch (generatorsChoice.getSelectedIndex()) {
	    case 0 : 	generator = circularGenerator;
		generatorInterface = circularGenInterface;
		break;
	    case 1 : 	generator = stepGenerator;
		generatorInterface = stepGenInterface;
		break;
	    case 2 : 	generator = pulsesGenerator;
		generatorInterface = pulsesGenInterface;
		break;
	    case 3 : 	generator = randomPulsesGenerator;
		generatorInterface = randomPulsesGenInterface;
		break;
	    case 4 : 	generator = noisyGenerator;
		generatorInterface = noisyGenInterface;
		break;
	    case 5 : 	generator = positiveGenerator;
		generatorInterface = positiveGenInterface;
		break;
	    case 6 : 	generator = squareGenerator;
		generatorInterface = squareGenInterface;
		break;
	    case 7 : 	generator = discreteNoisyGenerator;
		generatorInterface = discreteNoisyGenInterface;
		break;
	    }
	}
		
	public void init() {
	    generatorsChoice = new JComboBox();
	    generatorsChoice.setBorder(new CompoundBorder(generatorsChoice.getBorder(),new EmptyBorder(2,2,2,2)));
	    generatorsChoice.setRenderer(new NeuralNetwork.MyCellRenderer());
	    generatorsChoice.setMaximumRowCount(4);
	    generatorsChoice.setLightWeightPopupEnabled(true);
	    generatorsChoice.addItemListener(this);
	    cards = new JPanel();
	    cards.setLayout(new CardLayout());

	    /* Creation des generateurs */
	    // Signal priodique, fct. circulaire (sinusoidal)
	    circularGenerator = new CircularGenerator(); // instanciation
	    circularGenerator.init(11.e-8,0.1e-7,100.0,0.); // initialisation
	    circularGenInterface = new CircularGeneratorGI(circularGenerator); // interface
	    circularGenInterface.setFontLabels(defaultFont);
	    cards.add(	circularGenInterface.getInterface(),
			Integer.toString(circularGenInterface.getSymbolic().hashCode()));
	    // Signal step
	    stepGenerator = new StepGenerator();
	    stepGenerator.init(11e-8,0.1e-6,0.5);
	    stepGenInterface = new StepGeneratorGI(stepGenerator);
	    stepGenInterface.setFontLabels(defaultFont);
	    cards.add(stepGenInterface.getInterface(),
		      Integer.toString(stepGenInterface.getSymbolic().hashCode()));
	    // Signal impulsions temps constants
	    pulsesGenerator = new PulsesGenerator(11e-8,3,0.01e-6,1);
	    pulsesGenInterface = new PulsesGeneratorGI(pulsesGenerator);
	    pulsesGenInterface.setFontLabels(defaultFont);
	    cards.add(pulsesGenInterface.getInterface(),
		      Integer.toString(pulsesGenInterface.getSymbolic().hashCode()));
	    // Signal impulsions loi exponentielle
	    randomPulsesGenerator = new RandomPulsesGenerator(11e-8,75.0,0.01e-6,1,System.currentTimeMillis());	   
	    randomPulsesGenInterface = new RandomPulsesGeneratorGI(randomPulsesGenerator);
	    randomPulsesGenInterface.setFontLabels(defaultFont);
	    cards.add(randomPulsesGenInterface.getInterface(),
		      Integer.toString(randomPulsesGenInterface.getSymbolic().hashCode()));
	    // Modle fct de bruit continu
	    noisyGenerator = new NoisyGenerator(11e-8,0.5e-6,10,System.currentTimeMillis()); // instanciation
	    noisyGenInterface = new NoisyGeneratorGI(noisyGenerator); // interface
	    noisyGenInterface.setFontLabels(defaultFont);
	    cards.add(noisyGenInterface.getInterface(),
		      Integer.toString(noisyGenInterface.getSymbolic().hashCode()));
	    // Modle fct de bruit discret
	    discreteNoisyGenerator = new DiscreteNoisyGenerator(); // instanciation
	    discreteNoisyGenerator.setOffset(11.e-8);
	    discreteNoisyGenerator.setAmplitude(0.5e-6);
	    discreteNoisyGenInterface = new DiscreteNoisyGeneratorGI(discreteNoisyGenerator); // interface
	    discreteNoisyGenInterface.setFontLabels(defaultFont);
	    cards.add(discreteNoisyGenInterface.getInterface(),
		      Integer.toString(discreteNoisyGenInterface.getSymbolic().hashCode()));
	    // Signal priodique, fct. circulaire positive (sinusoide redresse)
	    positiveGenerator = new PositiveGenerator();
	    positiveGenerator.init(11e-8,3e-7,100.0,0.);
	    positiveGenInterface = new PositiveGeneratorGI(positiveGenerator);
	    positiveGenInterface.setFontLabels(defaultFont);
	    cards.add(positiveGenInterface.getInterface(),
		      Integer.toString(positiveGenInterface.getSymbolic().hashCode()));
	    // Signal priodique, fct. carre (crnaux)
	    squareGenerator = new SquareGenerator();
	    squareGenerator.init(11.e-8, 5.e-6, 0.e-6, new double[]
		{0.03, 0.01, 0.02, 0.01, 0.03, 0.01, 0.02, 0.01});
	    squareGenInterface = new SquareGeneratorGI(squareGenerator);
	    squareGenInterface.setFontLabels(defaultFont);
	    cards.add(squareGenInterface.getInterface(),
		      Integer.toString(squareGenInterface.getSymbolic().hashCode()));
	    // ...

	    // Ajout des diffrents modles de gnrateurs au ComboBox:
	    generatorsChoice.addItem(circularGenInterface.getSymbolic());
	    generatorsChoice.addItem(stepGenInterface.getSymbolic());
	    generatorsChoice.addItem(pulsesGenInterface.getSymbolic());
	    generatorsChoice.addItem(randomPulsesGenInterface.getSymbolic());
	    generatorsChoice.addItem(noisyGenInterface.getSymbolic());
	    generatorsChoice.addItem(positiveGenInterface.getSymbolic());
	    generatorsChoice.addItem(squareGenInterface.getSymbolic());
	    generatorsChoice.addItem(discreteNoisyGenInterface.getSymbolic());
	}
		
	public void netSizeChange() {	   
	    connected.removeAllElements();	  
	    for (int i = 0; i<netY; i++) {
		for (int j = 0; j<netX; j++) { 
		    connected.addElement(network[i][j].toString());		   
		}
	    }
	    noneRb.setSelected(true);
	    list.clearSelection();
	}

	public String getTitle()	{ return ("Courant externe"); }
	public Icon getIcon() 		{ return null; }
	public String getToolTip()	{ return ("Panneau de controle de la source externe."); }
		
	public void applyGenerator() {
	    generatorInterface.synchronizeSignifie(generator);
	    int index = 0;
	    for (int i = 0; i<netY; i++)
		for (int j= 0; j<netX; j++) {
		    network[i][j].removeExternalInputs();
		    if (list.isSelectedIndex(index++)) // if inTheList, then
			network[i][j].addExternalInput(generator);
		}
	}		
	
	protected class NeuronSelectMode implements ActionListener {
	    public void actionPerformed(ActionEvent event) {
		if (allRb.isSelected())
		    list.setSelectionInterval(0, connected.getSize()-1);
		else {
		    list.clearSelection();
		    noneRb.setSelected(true);
		}
	    }
	}
    }			


    /* Gnrateur externe pour la phase initiale */

    private class InitialExternalUI extends JPanel implements ItemListener,ListSelectionListener {
	/*
	  Pour raison de simplicit, le code de la classe ExternalUI est simplement reproduit, avec quelques modif.
	  Une (bien) meilleure solution serait de mixer les deux classes, en n'instanciant 2x que les interfaces
	  (et pas les gnrateurs)...
	*/

	public JComboBox generatorsChoice;
	public JList list; // of NeuronBaseModel
	public DefaultListModel connected = new DefaultListModel();

	JPanel cards;
	JRadioButton allRb; // Slection = connexion de tous les neurones.
	JRadioButton noneRb; // Slection vide = dconnexion de tous les neurons
	JRadioButton customRb; // Slection de l'utilisateur.
	ButtonGroup neuronSelectionMode; // Exclusion mutuelle des boutons radio.
	InitialExternalUI.NeuronSelectMode listener; // Modification de la slection (couteur).
		
	/* Les differentes instances de generateurs */
	CircularGenerator circularGenerator;		
	CircularGeneratorGI circularGenInterface;	
	PositiveGenerator positiveGenerator;
	PositiveGeneratorGI positiveGenInterface;
	SquareGenerator	squareGenerator;
	SquareGeneratorGI squareGenInterface;
	PulsesGenerator	pulsesGenerator;
	PulsesGeneratorGI pulsesGenInterface;
	RandomPulsesGenerator randomPulsesGenerator;
	RandomPulsesGeneratorGI randomPulsesGenInterface;
	NoisyGenerator noisyGenerator;
	NoisyGeneratorGI noisyGenInterface;
	StepGenerator stepGenerator;
	StepGeneratorGI	stepGenInterface;
	DiscreteNoisyGenerator discreteNoisyGenerator;
	DiscreteNoisyGeneratorGI discreteNoisyGenInterface;
	// ... les autres generateurs 
	SignalGeneratorGI generatorInterface; // source de courant actuellement slectionne.

	InitialExternalUI() {
	    super();
	    setLayout(new GridBagLayout());
	    Constraints contraintes = new Constraints();

	    TitledBorder title = new TitledBorder(
						  new EmptyBorder(0,0,0,0), "Generateur de courant pour la phase initiale",
						  TitledBorder.CENTER, TitledBorder.DEFAULT_POSITION, bigFont);
	    setBorder(title);
	    init(); // Creation des gnrateurs et du ComboBox.

	    // Generateur & Interface initiaux ..........................
	    initialGenerator = noisyGenerator;
	    generatorInterface = noisyGenInterface;
	    generatorsChoice.setSelectedItem(generatorInterface.getSymbolic());

	    // Construction du groupe de bouton radio ...................
	    allRb = new JRadioButton("Tous");	
	    allRb.setFont(defaultFont);
	    noneRb = new JRadioButton("Aucun");		
	    noneRb.setFont(defaultFont);
	    customRb = new JRadioButton("Personnalise");
	    customRb.setFont(defaultFont);
	    allRb.setMnemonic('T');	
	    noneRb.setMnemonic('A');	
	    customRb.setMnemonic('P');
	    allRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    allRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    noneRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    noneRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    customRb.setVerticalTextPosition(JRadioButton.BOTTOM);
	    customRb.setHorizontalTextPosition(JRadioButton.CENTER);
	    neuronSelectionMode = new ButtonGroup();
	    neuronSelectionMode.add(allRb);
	    neuronSelectionMode.add(customRb);
	    neuronSelectionMode.add(noneRb);
	    noneRb.setSelected(true);
	
	    durationInitialPhase = new DoubleGI(0.,10,"Temps [ms]",DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	    durationInitialPhase.setFontLabels(defaultFont);
	    durationInitialPhase.setValidityDomaine(0.,Double.MAX_VALUE);
	    durationInitialPhase.setToolTipText("Duree de la phase initiale (determination d'une activit initiale).");

	
	    // Ajout des couteurs aux diffrents boutons ........................
	    listener = new InitialExternalUI.NeuronSelectMode();
	    allRb.addActionListener(listener);
	    noneRb.addActionListener(listener);
	    customRb.addActionListener(listener);

	    // Liste de slection des neurones connects
	    list = new JList(connected);
	    list.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	    list.addListSelectionListener(this);
	    JScrollPane listPane = new JScrollPane(list);
	   
	    netSizeChange(); // Update list selection & neurons input

	    // Composition du Panel global:
	    add(generatorsChoice,
		contraintes.setAndGet(0,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,2,2,
				      Constraints.NORTH,
				      0.75, 0.0));
	    add(cards,
		contraintes.setAndGet(0,1,
				      1,1,
				      Constraints.BOTH,
				      0,0,
				      0,0,2,2,
				      Constraints.CENTER,
				      0.75, 0.85));


	    add(new JSeparator(),
		contraintes.setAndGet(0,2,
				      1,1,
				      Constraints.BOTH,
				      0,0,
				      2,2,2,0,
				      Constraints.CENTER,
				      0.75, 0.05));

	    add(durationInitialPhase,
		contraintes.setAndGet(0,3,
				      1,1,
				      Constraints.BOTH,
				      0,0,
				      0,0,2,0,
				      Constraints.CENTER,
				      0.75, 0.1));


	    add(new JSeparator(),
		contraintes.setAndGet(1,0,
				      1,Constraints.REMAINDER,
				      Constraints.VERTICAL,
				      0,0, // Il faudrait rserver plus d'espace en x pour l'affichage....
				      2,2,4,4,
				      Constraints.CENTER,
				      0.1, 1.0));

	    add(allRb,
		contraintes.setAndGet(2,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,2,0,
				      Constraints.CENTER,
				      0.05, 0.0));
	    add(noneRb,
		contraintes.setAndGet(3,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,0,0,
				      Constraints.CENTER,
				      0.05, 0.0));
	    add(customRb,
		contraintes.setAndGet(4,0,
				      1,1,
				      Constraints.NONE,
				      0,0,
				      0,0,0,0,
				      Constraints.CENTER,
				      0.05, 0.0));

	    add(listPane,
		contraintes.setAndGet(2,1,
				      Constraints.REMAINDER, Constraints.REMAINDER,
				      Constraints.BOTH,
				      0,0,
				      5,0,2,2,
				      Constraints.CENTER,
				      0.15, 1.0));

	}

	public void valueChanged(ListSelectionEvent e) {
	    // Modifie par Sebastien Baehni
	    int[] indices = list.getSelectedIndices();
	    if (indices.length == connected.getSize()) {
		allRb.setSelected(true);
	    }
	    else if(indices.length == 0) {
		noneRb.setSelected(true);
	    }
	    else {
		customRb.setSelected(true);
	    }	
	}
		
	public void itemStateChanged(ItemEvent e) {
	    ((CardLayout)cards.getLayout()).show(cards,
						 Integer.toString(generatorsChoice.getSelectedItem().hashCode()));
	    switch (generatorsChoice.getSelectedIndex()) {
	    case 0 : 	initialGenerator = circularGenerator;
		generatorInterface = circularGenInterface;
		break;
	    case 1 : 	initialGenerator = stepGenerator;
		generatorInterface = stepGenInterface;
		break;
	    case 2 : 	initialGenerator = pulsesGenerator;
		generatorInterface = pulsesGenInterface;
		break;
	    case 3 : 	initialGenerator = randomPulsesGenerator;
		generatorInterface = randomPulsesGenInterface;
		break;
	    case 4 : 	initialGenerator = noisyGenerator;
		generatorInterface = noisyGenInterface;
		break;
	    case 5 : 	initialGenerator = positiveGenerator;
		generatorInterface = positiveGenInterface;
		break;
	    case 6 : 	initialGenerator = squareGenerator;
		generatorInterface = squareGenInterface;
		break;
	    case 7 : 	initialGenerator = discreteNoisyGenerator;
		generatorInterface = discreteNoisyGenInterface;
		break;
	    }
	}
		
	public void init() {
	    generatorsChoice = new JComboBox();
	    generatorsChoice.setBorder(new CompoundBorder(generatorsChoice.getBorder(),new EmptyBorder(2,2,2,2)));
	    generatorsChoice.setRenderer(new NeuralNetwork.MyCellRenderer());
	    generatorsChoice.setMaximumRowCount(4);
	    generatorsChoice.setLightWeightPopupEnabled(true);
	    generatorsChoice.addItemListener(this);
	    cards = new JPanel();
	    cards.setLayout(new CardLayout());

	    /* Creation des generateurs */
	    // Signal priodique, fct. circulaire (sinusoidal)
	    circularGenerator = new CircularGenerator(); // instanciation
	    circularGenerator.init(11.e-8,0.1e-7,100.0,0.); // initialisation
	    circularGenInterface = new CircularGeneratorGI(circularGenerator); // interface
	    circularGenInterface.setFontLabels(defaultFont);
	    cards.add(	circularGenInterface.getInterface(),
			Integer.toString(circularGenInterface.getSymbolic().hashCode()));
	    // Signal step
	    stepGenerator = new StepGenerator();
	    stepGenerator.init(11e-8,0.1e-6,0.5);
	    stepGenInterface = new StepGeneratorGI(stepGenerator);
	    stepGenInterface.setFontLabels(defaultFont);
	    cards.add(stepGenInterface.getInterface(),
		      Integer.toString(stepGenInterface.getSymbolic().hashCode()));
	    // Signal impulsions temps constants
	    pulsesGenerator = new PulsesGenerator(11e-8,3,0.01e-6,1);	  
	    pulsesGenInterface = new PulsesGeneratorGI(pulsesGenerator);
	    pulsesGenInterface.setFontLabels(defaultFont);
	    cards.add(pulsesGenInterface.getInterface(),
		      Integer.toString(pulsesGenInterface.getSymbolic().hashCode()));
	    // Signal impulsions loi exponentielle
	    randomPulsesGenerator = new RandomPulsesGenerator(11e-8,75.0,0.01e-6,1,System.currentTimeMillis());	  
	    randomPulsesGenInterface = new RandomPulsesGeneratorGI(randomPulsesGenerator);
	    randomPulsesGenInterface.setFontLabels(defaultFont);
	    cards.add(randomPulsesGenInterface.getInterface(),
		      Integer.toString(randomPulsesGenInterface.getSymbolic().hashCode()));
	    // Modle fct de bruit continu
	    noisyGenerator = new NoisyGenerator(11e-8,0.5e-6,10,System.currentTimeMillis()); // instanciation	 
	    noisyGenInterface = new NoisyGeneratorGI(noisyGenerator); // interface
	    noisyGenInterface.setFontLabels(defaultFont);
	    cards.add(noisyGenInterface.getInterface(),
		      Integer.toString(noisyGenInterface.getSymbolic().hashCode()));
	    // Modle fct de bruit discret
	    discreteNoisyGenerator = new DiscreteNoisyGenerator(); // instanciation
	    discreteNoisyGenerator.setOffset(11.e-8);
	    discreteNoisyGenerator.setAmplitude(0.5e-6);
	    discreteNoisyGenInterface = new DiscreteNoisyGeneratorGI(discreteNoisyGenerator); // interface
	    discreteNoisyGenInterface.setFontLabels(defaultFont);
	    cards.add(discreteNoisyGenInterface.getInterface(),
		      Integer.toString(discreteNoisyGenInterface.getSymbolic().hashCode()));
	    // Signal priodique, fct. circulaire positive (sinusoide redresse)
	    positiveGenerator = new PositiveGenerator();
	    positiveGenerator.init(11e-8,3e-7,100.0,0.);
	    positiveGenInterface = new PositiveGeneratorGI(positiveGenerator);
	    positiveGenInterface.setFontLabels(defaultFont);
	    cards.add(positiveGenInterface.getInterface(),
		      Integer.toString(positiveGenInterface.getSymbolic().hashCode()));
	    // Signal priodique, fct. carre (crnaux)
	    squareGenerator = new SquareGenerator();
	    squareGenerator.init(11.e-8, 5.e-6, 0.e-6, new double[]
		{0.03, 0.01, 0.02, 0.01, 0.03, 0.01, 0.02, 0.01});
	    squareGenInterface = new SquareGeneratorGI(squareGenerator);
	    squareGenInterface.setFontLabels(defaultFont);
	    cards.add(squareGenInterface.getInterface(),
		      Integer.toString(squareGenInterface.getSymbolic().hashCode()));
	    // ...

	    // Ajout des diffrents modles de gnrateurs au ComboBox:
	    generatorsChoice.addItem(circularGenInterface.getSymbolic());
	    generatorsChoice.addItem(stepGenInterface.getSymbolic());
	    generatorsChoice.addItem(pulsesGenInterface.getSymbolic());
	    generatorsChoice.addItem(randomPulsesGenInterface.getSymbolic());
	    generatorsChoice.addItem(noisyGenInterface.getSymbolic());
	    generatorsChoice.addItem(positiveGenInterface.getSymbolic());
	    generatorsChoice.addItem(squareGenInterface.getSymbolic());
	    generatorsChoice.addItem(discreteNoisyGenInterface.getSymbolic());
	}
		
	public void netSizeChange() {
	    connected.removeAllElements();
	    for (int i = 0; i<netY; i++) {
		for (int j = 0; j<netX; j++) {
		    connected.addElement(network[i][j].toString());
		}
	    }
	    noneRb.setSelected(true);
	    list.clearSelection();	
	}
		
	public String getTitle() 	{ return ("Phase initiale"); }
	public Icon getIcon() 		{ return null; }
	public String getToolTip()	{ return ("Panneau de controle de la phase initiale."); }
		
	public void applyGenerator() {
	    generatorInterface.synchronizeSignifie(initialGenerator);
	    int index = 0;
	    for (int i = 0; i<netY; i++)
		for (int j= 0; j<netX; j++) {
		    network[i][j].removeExternalInputs();
		    if (list.isSelectedIndex(index++)) // if inTheList, then
			network[i][j].addExternalInput(generator);
		}
	}		
	
	protected class NeuronSelectMode implements ActionListener {
	    public void actionPerformed(ActionEvent event) {
		if (allRb.isSelected())
		    list.setSelectionInterval(0, connected.getSize()-1);
		else {
		    list.clearSelection();
		    noneRb.setSelected(true);
		}
	    }
	}
    }			


    /* Non implmente.. mais l'ide est de permettre l'affichage / modification de l'tat particulier
       d'un neurone du rseau (les autres classes -neurones et connexions- sont prvues pour permettre
       un tel paramtrage.
	   
       Zone de gauche: Identit du neurone, interface (type de modle, etc)
       Zone de droite: Table des connexions (JTableModel), avec destinataire, w, delay.
       -> ces deux derniers paramtres sont donc  retirer du panneau networkUI...
    */
    private class NeuronUI extends JPanel {
	NeuronUI() { super(); }
	public String getTitle() { return ("Neuron Info"); }
	public Icon getIcon() { return null; }
	public String getToolTip() { return ("Non Implment! (Panneau de control d'un neurone)"); }
    }

    /* Paramtrage des neurones et du rseau lui-mme.
       Il manque une hirarchie de classes gerant la topologie du rseau, et retournant une SymbolicIcon pour
       le comboBox, ainsi qu'une image 'descriptive'... et des controles (?)
    */
    private class NetworkUI extends JPanel implements ItemListener, ActionListener {

	// Elements de l'interface rseau  proprement parler
	String[]	topologies = {"Global", "4 voisins", "8 voisins"};
	JComboBox	topologieChoice;
	JButton		validateBtn;
	LongGI		netHeightCtrl;
	LongGI		netWidthCtrl;

	DoubleGI	JoCtrl;
	DoubleGI	delayCtrl;
		
	int 		currentTopo;
	int 		currentModel;
		
	// Elements de l'interface 'neurones'
	JComboBox		neuronsChoice;
	JPanel			cardsNeuron;
	NeuronBaseModelGI	neuronInterface; // interface utilisateur du modle de neurone
	
	IntegrateAndFireGI	ifInterface;
	SRMLongMemoryGI		srInterface;
	SRMShortMemoryGI	srShortInterface;
	// ... les autres modeles de neurones

	NetworkUI() {
	    super();
	    setLayout(new GridBagLayout());
	    Constraints contraintes = new Constraints();
	    initNeuronUIs(); // Construction des intefaces de modeles.................................			
	    initTopologieUIs();

	    netHeightCtrl = new LongGI(5,5,"Nb. lines",LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	    netHeightCtrl.setFontLabels(defaultFont);
	    netHeightCtrl.setValidityDomaine(1,Integer.MAX_VALUE);
	    netHeightCtrl.setToolTipText("Taille du reseau: nombre de lignes.");

	    netWidthCtrl = new LongGI(5,5,"Nb. cols.",LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	    netWidthCtrl.setFontLabels(defaultFont);
	    netWidthCtrl.setValidityDomaine(1,Integer.MAX_VALUE);
	    netWidthCtrl.setToolTipText("Taille du reseau: nombre de rangees.");

	    JoCtrl = new DoubleGI(0.001,10,"w (Jo)",DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	    JoCtrl.setFontLabels(defaultFont);
	    JoCtrl.setToolTipText("Coefficient d'efficacite des synapses.");

	    delayCtrl = new DoubleGI(10.,10,"Delai [ms]",DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	    delayCtrl.setFontLabels(defaultFont);
	    delayCtrl.setValidityDomaine(0.,Double.MAX_VALUE);
	    delayCtrl.setToolTipText("Delai de transmission des axones.");


	    PrimitiveTypeGroup controls = new PrimitiveTypeGroup();
	    controls.add(netHeightCtrl);
	    controls.add(netWidthCtrl);
	    controls.add(JoCtrl);
	    controls.add(delayCtrl);
	    JLabel ctrlTitle = new JLabel("Parametres du reseau");
	    ctrlTitle.setFont(defaultFont);

	    validateBtn = new JButton("Validation"); // new JButton();
	    validateBtn.setFont(defaultFont);
	    validateBtn.setBorderPainted(true);
	    validateBtn.setOpaque(true);
	    validateBtn.setFocusPainted(false);
	    validateBtn.setRolloverEnabled(false);
	    validateBtn.getAccessibleContext().setAccessibleName("NetValidate");
	    validateBtn.setToolTipText("Generation du reseau.");
	    validateBtn.addActionListener(this);
	    setEnabled(true);
	    JLabel leftAreaTitle = new JLabel("Parametres du reseau");
	    leftAreaTitle.setFont(bigFont);
	    JLabel rightAreaTitle = new JLabel("Parametres des neurones");
	    rightAreaTitle.setFont(bigFont);

	    add(leftAreaTitle,
		contraintes.setAndGet(	0,0,
					1,1,
					Constraints.VERTICAL,
					0,0,
					0,5,2,0,
					Constraints.CENTER,
					0.5, 0.0));
	    add(topologieChoice,
		contraintes.setAndGet(	0,1,
					1,1,
					Constraints.BOTH,
					5,2,
					0,5,2,0,
					Constraints.CENTER,
					0.5, 0.0));
	    add(ctrlTitle,
		contraintes.setAndGet(	0,2,
					1,1,
					Constraints.HORIZONTAL,
					0,0,
					2,2,2,0,
					Constraints.WEST,
					0.5, 0.0));
	    add(controls,
		contraintes.setAndGet(	0,3,
					1,1,
					Constraints.BOTH,
					0,0,
					0,0,2,0,
					Constraints.CENTER,
					0.5, 0.3));
	    add(validateBtn,
		contraintes.setAndGet(	0,7,
					1,1,
					Constraints.NONE,
					0,0,
					0,0,2,0,
					Constraints.CENTER,
					0.5, 0.3));
	    /*
	      Bug de swing ou nouvelle fonctionnalit ? 
	      Normalement, il devrait tre possible d'utiliser un JSeparator pour une sparation verticale
	      (c.f. Swing Short Course, Part I, MageLang Institute, Java Developer Connection, Sun).
	      Dans l'tat actuel des chose, cela n'est pas possible (le sparateur est TOUJOURS horizontal);
	      peut-tre cette fonctionnalit est prvue pour de futures versions... ou  t supprime, ou
	      implmente diffremment ( l'aide d'une autre classe, puisque le JSeparator est originellement
	      prvu pour prendre place dans un menu droulant (quoique l galement, il se peut que l'on ait
	      besoin d'un sparateur vertical...)).   A suivre....
	    */
	    add(new JSeparator(),
		contraintes.setAndGet(	1,0,
					1,Constraints.REMAINDER,
					Constraints.VERTICAL,
					0,0, // Il faudrait rserver plus d'espace en x pour l'affichage....
					2,2,5,5,
					Constraints.CENTER,
					0.1, 1.0));
	    add(rightAreaTitle,
		contraintes.setAndGet(	2,0,
					1,1,
					Constraints.NONE,
					0,0,
					0,0,4,0,
					Constraints.NORTH,
					0.4, 0.0));
	    add(neuronsChoice,
		contraintes.setAndGet(	2,1,
					1,1,
					Constraints.NONE,
					0,0,
					0,0,4,0,
					Constraints.CENTER,
					0.4, 0.0));
	    add(cardsNeuron,
		contraintes.setAndGet(	2,2,
					1,Constraints.REMAINDER,
					Constraints.BOTH,
					0,0,
					0,0,4,0,
					Constraints.CENTER,
					0.4, 1.0));

	    /* Neurone & Interface initiaux */
	    neuronInterface = ifInterface;
	    currentTopo = -1;
	    currentModel = -1;
	    netX = 0;
	    netY = 0; // on s'assure que la cration aura lieu...
	    actionPerformed(null);
	}
		
	public void setEnabled(boolean state) {
	    validateBtn.setEnabled(state);
	    validateBtn.setBorder( (state ? raisedBorder : loweredBorder));
	} 


	public void actionPerformed(ActionEvent event) {	   
	    // Version bricole: les actions  effectuer en rponse aux modif de l'interface doivent
	    // etre enchaines plus proprement... il faut enregistrer des listeners de diffrents
	    // type, et notifier les changements au fur et  mesure...
	    setEnabled(false);
	    int id = 0;
	    int netWidth = (int)netHeightCtrl.getValue();
	    int netHeight = (int)netWidthCtrl.getValue();
	  
	    boolean sizeNetChange = ((netWidth!=netX)||(netHeight!=netY));
	    boolean topologieChange = (topologieChoice.getSelectedIndex()!= currentTopo);
	    boolean modelChange = (currentModel != neuronsChoice.getSelectedIndex());
	    currentModel = neuronsChoice.getSelectedIndex();
	    netX = netWidth;
	    netY = netHeight;
	    double delay = delayCtrl.getValue()*1e-3;
	    double w = JoCtrl.getValue()*1e-6; // JoCtrl.getValue()/(netX*netY)
	    if (sizeNetChange||modelChange) {
		if (sizeNetChange) {
		    populationActivity.setPopulationSize(netX*netY);
		    network = new NeuronBaseModel[netY][netX];
		}
		networkView.removeItems();
		networkView.setNetworkSize(netX,netY);
		for (int i = 0; i< netY; i++)
		    for (int j=0; j<netX; j++) {
			switch (currentModel) {
			case 0 : network[i][j] = new IFDrawable(id++,networkView);
			    break;
			case 1 : network[i][j] = new SRMLongDrawable(id++,networkView);
			    break;
			case 2 : network[i][j] = new SRMShortDrawable(id++,networkView);
			    break;
			}
		    }
	    }
	    if (sizeNetChange||topologieChange) {
		currentTopo = topologieChoice.getSelectedIndex();
		networkView.setTopologie(currentTopo);
		for (int i = 0; i< netY; i++)
		    for (int j=0; j<netX; j++)
			network[i][j].removeInputs();
				
		switch (currentTopo) {
		case 0: // full connected
		    for (int i = 0; i< netY; i++)
			for (int j=0; j<netX; j++)
			    for (int ii = 0; ii<netY; ii++)
				for (int jj = 0; jj<netX; jj++)
				    network[i][j].addInput(network[ii][jj],w,delay);
		    break;

		case 2:	// 8 voisins
		    for (int i = 0; i< netY; i++)
			for (int j=0; j<netX; j++) {
			    network[i][j].addInput(network[(i+netY-1)%netY][(j+netX-1)%netX],w,delay);
			    network[i][j].addInput(network[(i+1)%netY][(j+1)%netX],w,delay);
			    network[i][j].addInput(network[(i+1)%netY][(j+netX-1)%netX],w,delay);
			    network[i][j].addInput(network[(i+netY-1)%netY][(j+1)%netX],w,delay);
			} // pas de break !
		case 1:	// 4 voisins
		    for (int i = 0; i< netY; i++)
			for (int j=0; j<netX; j++) {
			    network[i][j].addInput(network[(i+netY-1)%netY][j],w,delay);
			    network[i][j].addInput(network[(i+1)%netY][j],w,delay);
			    network[i][j].addInput(network[i][(j+netX-1)%netX],w,delay);
			    network[i][j].addInput(network[i][(j+1)%netX],w,delay);
			}
		    break;
		}
	    }
	    for (int i = 0; i< netY; i++)
		for (int j=0; j<netX; j++) {
		    neuronInterface.synchronizeSignifie(network[i][j]);
		    network[i][j].setInputs(w,delay);
		}
			
	    if (sizeNetChange) {
		if (externalUI != null)
		    externalUI.netSizeChange();
		if (initialExternalUI != null)
		    initialExternalUI.netSizeChange();
	    }

	    if (sizeNetChange || modelChange || topologieChange)
		networkView.repaint();

	    // Pas propre du tout... normalement, c'est aux neurones de se charger
	    // de dessiner leurs connexions... (problme: elles sont doubles...)

	    double nbConnexions = 0;
	    switch (currentTopo) {
	    case 0: nbConnexions = netX*netY;
		break;
	    case 1:	nbConnexions = 4;
		break;
	    case 2:	nbConnexions = 8;
		break;
	    }
	    setEnabled(true);
	}

	public void itemStateChanged(ItemEvent e) {
	    Object source = e.getSource();
	    if (source == neuronsChoice) {
		((CardLayout)cardsNeuron.getLayout()).show(cardsNeuron,
							   Integer.toString(neuronsChoice.getSelectedItem().hashCode()));
		switch (neuronsChoice.getSelectedIndex()) {
		case 0 : 	neuronInterface = ifInterface;
		    break;
		case 1 : 	neuronInterface = srInterface;
		    break;
		case 2 : 	neuronInterface = srShortInterface;
		    break;
		}
	    }
	}
		
	protected void initNeuronUIs() {
	    neuronsChoice = new JComboBox();
	    neuronsChoice.setBorder(new CompoundBorder(neuronsChoice.getBorder(),
						       new EmptyBorder(4,4,4,4)));
	    neuronsChoice.setRenderer(new NeuralNetwork.MyCellRenderer());
	    //			neuronsChoice.setMaximumRowCount(3);
	    neuronsChoice.setLightWeightPopupEnabled(true);
	    neuronsChoice.addItemListener(this);

	    cardsNeuron = new JPanel();
	    cardsNeuron.setLayout(new CardLayout());

	    /* Cration des interfaces de modles */
	    // Modele Integrate&Fire
	    ifInterface = new IntegrateAndFireGI(0.1,  0.,	// Threshold average & gap
						 0.005, 0.,	// RefractoryTime average & gap
						 1.e6,		// Resistance
						 0.02,		// Tau M
						 0.02,		// Tau S
						 0.00,		// ResetPotential
						 0.00);		// NoiseCurrent amplitude
	    ifInterface.setFontLabels(defaultFont);
	    neuronsChoice.addItem(ifInterface.getSymbolic());
	    cardsNeuron.add(ifInterface.getInterface(),Integer.toString(ifInterface.getSymbolic().hashCode()));
	    // Spike Response (Long Memory)
	    srInterface = new SRMLongMemoryGI(0.1,  0.,	// Threshold average & gap
					      0.005, 0.,	// RefractoryTime average & gap
					      1.e6,			// Resistance
					      0.02,			// Tau S
					      -0.07,		// Eta 0
					      0.05,			// Tau Eta
					      0.00);		// NoiseCurrent amplitude
	    srInterface.setFontLabels(defaultFont);
	    neuronsChoice.addItem(srInterface.getSymbolic());
	    cardsNeuron.add(srInterface.getInterface(),Integer.toString(srInterface.getSymbolic().hashCode()));
	    // Spike Response (Short Memory)
	    srShortInterface = new SRMShortMemoryGI(0.1,  0.,	// Threshold average & gap
						    0.005, 0.,	// RefractoryTime average & gap
						    1.e6,		// Resistance
						    0.02,		// Tau S
						    -0.07,		// Eta 0
						    0.05,		// Tau Eta
						    0.00);		// NoiseCurrent amplitude
	    srShortInterface.setFontLabels(defaultFont);
	    neuronsChoice.addItem(srShortInterface.getSymbolic());
	    cardsNeuron.add(srShortInterface.getInterface(),Integer.toString(srShortInterface.getSymbolic().hashCode()));
	    // ...
	}


	protected void initTopologieUIs() {
	    topologieChoice = new JComboBox();
	    topologieChoice.setFont(defaultFont);
	    topologieChoice.setBorder(new CompoundBorder(
							 topologieChoice.getBorder(),new EmptyBorder(5,5,5,5)));
	    topologieChoice.setLightWeightPopupEnabled(true);
	    topologieChoice.addItemListener(this);
	    for (int i=0; i<topologies.length;i++) 
		topologieChoice.addItem(topologies[i]);
	}

	public String getTitle()	{ return ("Parametres du reseau"); }
	public Icon getIcon() 		{ return null; }
	public String getToolTip() 	{ return ("Panneau de controle du reseau de neurones."); }

    }


    /*
      Classe assurant l'affichage de l'activit de la population.
      Incomplet galement: le but tant de pouvoir 'remonter' le temps de la simulation (une fois celle-ci termine)
      (au moyen d'un slider dans ce panel, et de bouton type radio), afin de voir l'tat du rseau (qui doit supporter
      une telle fonction), les neurones mmettant des impulsions, v. la propagation des impulsions, et une barre
      (curseur -XOR) vertical sur le graph de l'activit, indiquant le moment visualis.
		
      Offrire une telle possibilit (examen post-simulation) ncessite un travail considrable
      (nombreuses rpercutions sur les autres classes).
    */
    private class ActivityUI extends JPanel {
	ActivityUI.HoldButton		holdBtn;
	ActivityUI.ResetHoldedButton	resetBtn;

	ActivityUI() {
	    super();
	    setLayout(new GridBagLayout());
	    Constraints contraintes = new Constraints();
	    holdBtn = new ActivityUI.HoldButton();
	    resetBtn = new ActivityUI.ResetHoldedButton();
	    activityCnv = new GraphCanvas(400, 200,
					  0.02, 0, tMax.getValue()*1e-3,
					  0.05, 0, 1/(deltaT.getValue()*1e-3));

	    JLabel title = new JLabel("Activite de la population [kHz]");
	    title.setFont(bigFont);

	    activityCurve = new LineOfPoints(Color.red);
	    activityCurve.setInput(populationActivity);
	    holdedActivityCurve = new LineOfPoints(Color.red);
	    activityCnv.setAxesLabelFactor(1e3,1e-3);
	    activityCnv.setFontLabels(smallMonoFont);
	    activityCnv.addItem(holdedActivityCurve);
	    activityCnv.addSynchronizedItem(activityCurve);

	    add(title,
		contraintes.setAndGet(	0,0,
					1,1,
					Constraints.HORIZONTAL,
					0,0,
					0,3,0,5,
					Constraints.WEST,
					1.0, 0.0));
	    add(holdBtn,
		contraintes.setAndGet(	1,0,
					1,1,
					Constraints.NONE,
					0,0,
					0,3,5,5,
					Constraints.CENTER,
					0.0, 0.0));
	    add(resetBtn,
		contraintes.setAndGet(	2,0,
					1,1,
					Constraints.NONE,
					0,0,
					0,3,5,5,
					Constraints.CENTER,
					0.0, 0.0));  
	    add(activityCnv,
		contraintes.setAndGet(	0,1,
					Constraints.REMAINDER, Constraints.REMAINDER,
					Constraints.BOTH,
					0,0,
					0,0,0,0,
					Constraints.CENTER,
					1.0, 1.0));
	}
		
	public void enableHolding() {
	    holdBtn.setEnabled(true);
	}


	private class HoldButton extends JButton implements ActionListener {
	    HoldButton() {
		super("Memorise");
		setFont(defaultFont);
		setBorderPainted(true);
		setOpaque(true);
		setFocusPainted(false);
		setRolloverEnabled(false);
		addActionListener(this);
		getAccessibleContext().setAccessibleName("Memorise");
		setToolTipText("Memorise la courbe.");
		setEnabled(false);
	    }
	    public void setEnabled(boolean state) {
		super.setEnabled(state);
		setBorder( (state ? raisedBorder : loweredBorder));
	    } 
	    // Interface: ActionListener...
	    public void actionPerformed(ActionEvent event) {
				// version pas propre... (prob. si autre rfrence  neuronCurve... couleurs init)
		setEnabled(false);
		//Corrige par Sebastien Baehni
		//		update(getGraphics());
		repaint();
		holdedActivityCurve.holdCurve(activityCurve);
		resetBtn.setEnabled(true);
	    }
	}

	private class ResetHoldedButton extends JButton implements ActionListener {
	    ResetHoldedButton() {
		super("Efface");
		setFont(defaultFont);
		setBorderPainted(true);
		setOpaque(true);
		setFocusPainted(false);
		setRolloverEnabled(false);
		addActionListener(this);
		getAccessibleContext().setAccessibleName("Efface");
		setToolTipText("Efface la courbe memorisee.");
		setEnabled(false);
	    }
	    public void setEnabled(boolean state) {
		super.setEnabled(state);
		setBorder( (state ? raisedBorder : loweredBorder));
	    } 
	    // Interface: ActionListener...
	    public void actionPerformed(ActionEvent event) {
		holdedActivityCurve.resetTime();
		activityCnv.update();
		setEnabled(false);
		holdBtn.setEnabled(true);
	    }
	}
    }			

    private class StartJButton extends JButton implements ActionListener {
	StartJButton() {
	    super();
	    setIcon(Tools.loadImageIcon(getClass(),	"/images/computeBtn_R.gif", ""));
	    setPressedIcon(Tools.loadImageIcon(getClass(),"/images/computeBtn_P.gif",""));
	    setDisabledIcon(Tools.loadImageIcon(getClass(),"/images/computeBtn_D.gif",""));
	    setRolloverIcon(Tools.loadImageIcon(getClass(),"/images/computeBtn_S.gif",""));
	    setBorderPainted(false);
	    setOpaque(false);
	    setFocusPainted(false);
	    setRolloverEnabled(true);
	    addActionListener(this);
	    getAccessibleContext().setAccessibleName("Start");
	    setToolTipText("Demarre la simulation.");
	}

	// Interface: ActionListener...
	public void actionPerformed(ActionEvent event) {
	    setEnabled(false); // Dsactivation du bouton
	    new Thread(neuralNetwork).start(); // Effectuer la simulation
	    setEnabled(true); // Ractivation du bouton
	    activityUI.enableHolding();
	}
    }

    /**
     * Bouton d'arret de la simulation.
     */
    private class StopJButton extends JButton implements ActionListener {
	StopJButton() {
	    super();
	    setIcon(Tools.loadImageIcon(getClass(),	"/images/stop.gif", ""));
	    setPressedIcon(Tools.loadImageIcon(getClass(),"/images/stop_p.gif",""));
	    setDisabledIcon(Tools.loadImageIcon(getClass(),"/images/stop_d.gif",""));
	    setRolloverIcon(Tools.loadImageIcon(getClass(),"/images/stop_r.gif",""));
	    setBorderPainted(false);
	    setOpaque(false);
	    setFocusPainted(false);
	    setRolloverEnabled(true);
	    addActionListener(this);
	    getAccessibleContext().setAccessibleName("Stop");
	    setToolTipText("Stoppe la simulation.");
	}
	
	// Interface: ActionListener...
	public void actionPerformed(ActionEvent event) {
	    setEnabled(false); // Dsactivation du bouton
	    Clock.sharedInstance.setTime(Clock.sharedInstance.getMaximalTime());
	    setEnabled(true); // Ractivation du bouton
	    activityUI.enableHolding();
	}
    }  
    
    private class TitleCanvas extends JButton implements ActionListener {
	private final int NB_STATES = 2;
	int state;
	Icon[] icons;
		
	TitleCanvas() {
	    super();
	    state = 0;
	    icons = new Icon[NB_STATES];
	    for (int i = 0; i < NB_STATES; i++)
		icons[i] = Tools.loadImageIcon(getClass(), "/images/Title_n_"+i+".gif",null);
	    setOpaque(false);
	    setFocusPainted(false);
	    setBorderPainted(false);
	    setRolloverEnabled(false);
	    //			addActionListener(this);
	    getAccessibleContext().setAccessibleName("Title");
	    setIcon(icons[state]);
	}

	// Interface: ActionListener...
	public void actionPerformed(ActionEvent event) {
	    state = (state + 1) % NB_STATES;
	    setIcon(icons[state]);
	}
    }

    private class PrimaryFrame extends JFrame implements WindowListener { 
	PrimaryFrame(String title) {
	    super(title);
	    addWindowListener(this);
	}
	// Interface WindowListener implementation .........................
	public void windowActivated(WindowEvent we) {}
	public void windowDeactivated(WindowEvent we) {}
	public void windowDeiconified(WindowEvent we) {}
	public void windowIconified(WindowEvent we) {}
	public void windowOpened(WindowEvent we) {}
	public void windowClosing(WindowEvent we) {
	    dispose();
	}
	public void windowClosed(WindowEvent we) {
	    System.exit(0);
	}
    }


    public class MyCellRenderer implements ListCellRenderer {
	AbstractBorder border;
	public MyCellRenderer() {
	    border = new EmptyBorder(4,4,4,4);
	}
			
	public Component getListCellRendererComponent(JList list, Object value,
						      int index, boolean isSelected, boolean cellHasFocus) {
	    JLabel symbol = null;
	    if (isSelected) {
		symbol = (JLabel) ((Pair)value).second;
		symbol.setBackground(UIManager.getColor("ComboBox.selectedBackground"));
		symbol.setForeground(UIManager.getColor("ComboBox.selectedForeground"));
	    } else {
		symbol = (JLabel) ((Pair)value).first;
		symbol.setBackground(UIManager.getColor("ComboBox.background"));
		symbol.setForeground(UIManager.getColor("ComboBox.foreground"));
	    }
	    symbol.setBorder(border);
	    if(UIManager.getLookAndFeel().getName().equals("CDE/Motif"))
		symbol.setOpaque((index!=-1));
	    else
		symbol.setOpaque(true);
	    return symbol;
	}
    }
}
