package spikingneuron.drawable;

import java.awt.*;
import javax.swing.JComponent;
import spikingneuron.*;
import spikingneuron.math.*;
import spikingneuron.generators.*;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Aggrgation d'un context d'affichage et de la zone utilisateur reprsente.
* </TT></STRONG><FONT SIZE=3>
* <P>
* componentHandle pourrait etre remplac par Graphics... mais l'enregistrement du contexte d'affichage
* doit se faire lorsque l'lment est visible (dj affich), car avant l'appel  la mthode show(),
* aucun handle Graphics n'est valable ! De plus, ce contexte d'affichage est susceptible d'tre modifi
* au cours du temps, ce qui rend son utilisation dangereuse... (lors de redimensionnement).
* En fait, il faut implmenter un couteur pour les vnements en provenance des Components, et dfinir
* un protocol de validation/modification des context d'affichage. <BR>
* Avec un lightweight composant, l'obtention rpte du context d'affichage ralentit considrablement
* l'application (passage par beaucoup de classes ...) (En fait, lorsque le GraphCanvas est un
* Canvas (heavyweight composant), des appels rpts  getGraphics() sont supportable (faible ralentissement).
* Lors du passage  swing, et donc  un JComponent, le ralentissement est devenu trop important
* pour pouvoir tre acceptable. D'o l'actuelle implmentation, qui n'est ni 'propre' ni sans dangers.
* (Tous les problmes seraient rsolu si les affichages ne se faisaient que dans le mthodes paint()... 
* (donc, en utilisant une progress barre pendant le calcul, et en affichant les courbes au final). Mais tel
* n'est pas le cas, il est souhait de voir les courbes se 'construire' et donc, il faut dessiner en dehors
* des mthodes paint(). <BR>
* <BR>
* -> On mmorise  donc le contexte d'affichage Graphics du composant, et on le rutilise tant qu'il n'est
* pas null. Lorsque le context est susceptible de changer (c'est l qu'il y a danger car il n'y a pas de mthode
* genre GraphicChangeListener) il faut imprativement le modifier/riniitaliser, au moyen de la mthode
* <CODE>setGraphics</CODE>.
* <P>
* LA Solution est d'appliquer systmatiquement la technique du double buffer, avec couteurs d'EventComponent.
* (dessiner dans une image en mmoire, et ne l'afficher que lorqu'elle est prete).
* <P>
*/
public class DisplayContext {
    protected Screen2D viewHandle;
    protected Graphics componentGrph;
    protected JComponent componentHandle;

	
    public DisplayContext(JComponent c, Screen2D view) {
	componentHandle = c;
	viewHandle = view;
	componentGrph = c.getGraphics();
    }
	
    public void setComponent(JComponent c) {
	componentHandle = c;
	componentGrph = c.getGraphics();
    }

    public void setView(Screen2D view) {
	viewHandle = view;

    }	

    // A invoquer  CHAQUE FOIS que le context graphique est susceptible
    // d'avoir chang.	
    public void resetGraphics() {
	componentGrph = null;
    }
	
    // A invoquer  CHAQUE FOIS que le context graphique est susceptible
    // d'avoir chang.	
    public void setGraphics(Graphics g) {
	componentGrph = g;
    }
    public Graphics getGraphics() {
	if (componentGrph==null)
	    componentGrph = componentHandle.getGraphics();
	//		return componentHandle.getGraphics();
	return componentGrph;
    }
	
    public Screen2D getView() {
	return viewHandle;
    }
}
		
