package spikingneuron.drawable;

import java.util.Vector;
import java.awt.Graphics;
import spikingneuron.*;
import spikingneuron.math.*;
import spikingneuron.generators.*;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base (<B>abstraite</B>) pour tous les lments dessinables dans un GraphCanvas.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Implementation brouillon... il faut voir ce qui existe dans awt, genre ImageObserver, imageProducer,
* ainsi que dans Swing (update, redraw...) et soit utiliser ces methodes (voir aussi ce que java2D API
* reserve), soit implementer un systme de producteur-consomateur d'images, et gestion d'evenement
* de reaffichage (repaint (delai) + notifyEventModif)... lorsque les lments reprsents change d'tat.
* <BR> Hierarchie  revoir... tous ces lments devraient implmenter <CODE>DataFlowAgent</CODE>
* ( dfaut d'une interface plus spcifique, genre <I>DataFlowConsumer</I> ou <I>DataFlowObserver</I>...)
* <P>
*/
public abstract class Drawable {

    protected boolean synchronizedDisplay; // Indique si l'lment notifie directement son raffichage.
    protected Vector contexts; // of DisplayContext

    // Constructeurs .....................................
    protected Drawable() {
	synchronizedDisplay = false;
	contexts = new Vector(5,5);
    }
	
    // Accesseurs .............................
    public void setDisplaySynchro(boolean synchro) {
	synchronizedDisplay = synchro;
    }
	
    public void addDisplayContext(DisplayContext dspCtx) {
	contexts.addElement(dspCtx);
    }
	
    public void removeDisplayContext(DisplayContext dspCtx) {
	contexts.removeElement(dspCtx);
    }
	
    // Divers ....................................
    public void redraw() {
	DisplayContext dspCtx;
	for (int i=0; i<contexts.size(); i++) {
	    dspCtx = (DisplayContext)contexts.elementAt(i);
	    redrawAt(dspCtx.getGraphics(), dspCtx.getView());
	}
    }

    public void redrawAt(DisplayContext dspCtx) {
	redrawAt(dspCtx.getGraphics(), dspCtx.getView());
    }

    public abstract void redrawAt(Graphics g, Screen2D view);
	
    protected void notifyChanges() { /* ... */ }
}


/*----------------------------------------------------
  Mthodes abstraites:
 --------------------
 public abstract void redrawAt(Graphics g, Screen2D view)
 ------------------------------------------------------- */
