package spikingneuron.drawable;

import java.awt.Color;
import java.awt.Graphics;
import spikingneuron.math.Screen2D;


/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Modlise une ligne horizontale traitille.
* </TT></STRONG><FONT SIZE=3>
*/
public class HLine extends Drawable {

    public static final int TIRET_SIZE = 5;
    public static final int TIRET_SPACING = 8;

    public Color lineColor;
    public double ordonnee;
    public boolean initialised;
	
    // Constructeurs .........................
    public HLine(Color colorLine) {
	super();
	ordonnee = 0.0;
	initialised = false;
	lineColor = colorLine;
    }
	
    // Accesseurs ..........................
    public void setOrdonnee(double ordonnee) {
	this.ordonnee = ordonnee;
	initialised = true;
    }
	
    public double getOrdonnee() {
	if (initialised)
	    return ordonnee;
	else
	    return Double.NaN;
    }
	
    // Drawable extend ............................	
    public void redrawAt(Graphics g, Screen2D view) {
	int usrY;
	int maxX;
	int x;
	if (initialised) {
	    g.setColor(lineColor);
	    usrY = view.scrY(ordonnee);
	    maxX = view.getScrMaxX()-TIRET_SPACING;
	    x = view.getScrMinX();
	    while ((x+=TIRET_SPACING)<maxX)
		g.drawLine(x,usrY,x+=TIRET_SIZE,usrY);
	}
    }

}
