package spikingneuron.drawable;

import java.awt.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import java.util.Enumeration;
import spikingneuron.math.Screen2D;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.Tools;
import spikingneuron.tools.DataFlowAgent;
import spikingneuron.tools.RealFlowProducer;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Modlise une courbe constitue de points, relis entre eux.
* </TT></STRONG><FONT SIZE=3>
* <P>
* La courbe peut tre une copie d'une courbe existante, avec modification des couleurs de trac
* -> courbe mmorise, trac de manire plus 'lgre'.
*/
public class LineOfPoints extends Drawable implements DataFlowAgent {
    /*
      Pour un trace fluide, il faut appeler ensureCapacity avant d'ajouter
      des points au graphique. (Attention au depassement d'alloc. memoire)
	
    */
    public static final int GROWING_INCREMENT = 1000;
    public static final int INITIAL_CAPACITY = 5000;

    public Color lineColor;

    protected Vector pointsStock; // of Coordinate2D
    protected Coordinate2D lastPoint; //Point lastPoint;
    protected RealFlowProducer input; // input producer
    protected Coordinate2D verticalBounds; // Bounding Box


    // Constructeurs .........................
    public LineOfPoints(Color colorLine) {
	super();
	this.input = null;
	lineColor = colorLine;
	verticalBounds = new Coordinate2D(0.0,0.0);
	pointsStock = new java.util.Vector(INITIAL_CAPACITY,GROWING_INCREMENT);
    }

    public LineOfPoints(Color colorLine, int nbPoints) {
	super();
	this.input = null;
	lineColor = colorLine;
	verticalBounds = new Coordinate2D(0.0,0.0);
	pointsStock = new Vector(nbPoints,nbPoints);
    }

    // Accesseurs ..........................
    public void setInput(RealFlowProducer input) {
	this.input = input;
    }

    // Ces deux methodes sont a placer dans la hierarchie Drawable...	
    public Coordinate2D getVerticalBounds() {
	/* Ne prend pas en compte la limite superieur du spike */
	return verticalBounds;
    }
    public Coordinate2D getHorizontalBounds() {
	if (pointsStock.size()>0)
	    return new Coordinate2D(0.0,( ((Coordinate2D)pointsStock.lastElement()).getC0()));
	else
	    return new Coordinate2D(0.0,0.0);
    }

    // Divers ................................
    public void holdCurve(LineOfPoints stump) {
	pointsStock.removeAllElements();
	//		input = stump.input;
	if (stump.lastPoint != null)
	    lastPoint = (Coordinate2D)stump.lastPoint.clone();
	else
	    lastPoint = null;
	if (stump.verticalBounds != null)
	    verticalBounds = (Coordinate2D)stump.verticalBounds.clone();
	else
	    verticalBounds = null;
	if (pointsStock != null)
	    for (Enumeration e = stump.pointsStock.elements();e.hasMoreElements();)
		pointsStock.addElement(e.nextElement());

	lineColor = Tools.brightness(Tools.brightness(stump.lineColor,80),1.5);
    }


    public void ensureCapacity(int nbPoints) {
	pointsStock.ensureCapacity(nbPoints);
    }

    // Drawable extend ............................	
    public void redrawAt(Graphics g, Screen2D view) {
	Point older;
	Point newer;
	if ((g!=null)&&(pointsStock.size()>=2)) {
	    g.setColor(lineColor);
	    older = view.scrPoint((Coordinate2D)pointsStock.elementAt(0));
	    for (int i=1; i<pointsStock.size(); i++) {
		newer = view.scrPoint((Coordinate2D)pointsStock.elementAt(i));
		g.drawLine(older.x,older.y,newer.x,newer.y);
		older = newer;
	    }
	}
    }

    // DataFlowAgent interface implement .............................
    public void resetTime() {
	verticalBounds.set(0.0,0.0);
	pointsStock.removeAllElements();
	notifyChanges();
    }
	
	
    public void computeNextTic() {
	DisplayContext dspCtx;
	Point lastScrPoint;
	Point newScrPoint;
	double value = input.getRealOutput();
	Coordinate2D point = new Coordinate2D(Clock.sharedInstance.getTime(),value);

	if ((!pointsStock.isEmpty())&& synchronizedDisplay)
	    for (Enumeration e = contexts.elements();e.hasMoreElements();) {
		dspCtx = (DisplayContext)e.nextElement();
		Screen2D view = dspCtx.getView();
		lastScrPoint = view.scrPoint(lastPoint);
		newScrPoint = view.scrPoint(point);
		if (!newScrPoint.equals(lastScrPoint)) {
		    Graphics g = dspCtx.getGraphics();
		    if (g!=null) {
			g.setColor(lineColor);
			g.drawLine(lastScrPoint.x,lastScrPoint.y,newScrPoint.x,newScrPoint.y);
		    }
		}
	    }
	if (value<verticalBounds.getC0())
	    verticalBounds.setC0(value);
	else if (value>verticalBounds.getC1())
	    verticalBounds.setC1(value);
	pointsStock.addElement(point);
	lastPoint = point;
    }
}
