package spikingneuron.drawable;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import java.util.Enumeration;
import spikingneuron.math.Screen2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;
import spikingneuron.tools.RealFlowProducer;
import spikingneuron.neurons.NeuronBaseModel;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 Mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Modlise l'ensemble des marques d'impulsions.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Pour chaque impulsion, un trait vertical est trac. La couleur du trac, ainsi que la
* taille (longueur) du trait sont paramtrable. A chaque tic, l'instance test si le
* signal d'entre (potentiel membranaire) correspond  un spike.
* <P>
*/
public class SpikesCurve extends Drawable implements DataFlowAgent {
    // devrait implmenter un SpikeListener plutot qu'un DataFlowAgent...

    public Color lineColor;
    public double heightLineRatio; // p.r. Screen2D

    protected Vector spikes; // of Double (spike)
    protected RealFlowProducer input;

    // Constructeurs .........................
    public SpikesCurve(Color colorLine) {
	super();
	this.input = null;
	this.lineColor = colorLine;
	spikes = new java.util.Vector(50,10);
    }
	
    // Accesseurs ..........................
    public void setHeightLineRatio(double ratio) {
	this.heightLineRatio = ratio;
    }
	
    public void setInput(RealFlowProducer input) {
	this.input = input;
    }

	
    // Drawable extend ............................	
    public void redrawAt(Graphics g, Screen2D view) {
	int startY, stopY, y0, height, x;
	if (g!=null) {
	    g.setColor(lineColor);
	    height = view.getScrSize().height;
	    y0 = view.getScrMinY();
	    startY = y0 + (int)(height*(1.0-heightLineRatio)/2.0);
	    stopY = y0 + (int)(height*(1.0+heightLineRatio)/2.0);
	    for (Enumeration e = spikes.elements();e.hasMoreElements();) {
		x = view.scrX( ((Double)e.nextElement()).doubleValue() );
		g.drawLine(x,startY,x,stopY);
	    }
	}
    }

    // DataFlowAgent interface implement .............................
    public void resetTime() {
	spikes.removeAllElements();
	notifyChanges();
    }

    public void computeNextTic() {
	Graphics g;
	Screen2D view;
	DisplayContext dspCtx;
	double time;
	int startY, stopY, y0, height, x;
	if ((input!=null)&&(input.getRealOutput()==NeuronBaseModel.SPIKE_POTENTIAL)) {
	    time = Clock.sharedInstance.getTime();
	    if (synchronizedDisplay)
		for (Enumeration e = contexts.elements();e.hasMoreElements();) {
		    dspCtx = (DisplayContext)e.nextElement();
		    g = dspCtx.getGraphics();
		    view = dspCtx.getView();
		    if (g!=null) {
			g.setColor(lineColor);
			height = view.getScrSize().height;
			y0 = view.getScrMinY();
			startY = y0 + (int)(height*(1.0-heightLineRatio)/2.0);
			stopY = y0 + (int)(height*(1.0+heightLineRatio)/2.0);
			x = view.scrX(time);
			g.drawLine(x,startY,x,stopY);
		    }
		}
	    spikes.addElement(new Double(time));
	}
    }
}
