package spikingneuron.generators;

import java.lang.Math;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Gnrateur de courant sinusoidal.
* </TT></STRONG><FONT SIZE=3>
* <P><TT>
* I(t) = <I>Offset</I> + <I>Amplitude</I>*Sin(<I>Pulsation</I>t + <I>Dephasage</I>) </TT></BR>
* <P>
*/
public class CircularGenerator extends SignalGenerator {

    public static final String IDENTITY = "Generateur sinusoidal";

    protected double offset;
    protected double amplitude;
    protected double pulsation;
    protected double dephasage;

    // Constructeurs ...........................	
    public CircularGenerator() {
	super();
	offset = 0.0;
	amplitude = 0.0;
	pulsation = 0.0;
	dephasage = 0.0;
	signal = offset;
	updateOutput();
    }

    public CircularGenerator(double I0, double A, double w, double phi0) {
	super();
	offset = I0;
	amplitude = A;
	pulsation = w;
	dephasage = phi0;
	signal = I0;
	updateOutput();
    }
	
    // Accesseurs .............................
    public void init(double I0, double A, double w, double phi0) {
	offset = I0;
	amplitude = A;
	pulsation = w;
	dephasage = phi0;
	signal = I0;
	updateOutput();
    }
	
    public double getOffset() {
	return offset;
    }
    public double getAmplitude() {
	return amplitude;
    }
    public double getPulsation() {
	return pulsation;
    }
    public double getDephasage() {
	return dephasage;
    }

    public void setOffset(double offset) {
	this.offset = offset;
    }
    public void setAmplitude(double amplitude) {
	this.amplitude = amplitude;
    }
    public void setPulsation(double pulsation) {
	this.pulsation = pulsation;
    }
    public void setDephasage(double dephasage) {
	this.dephasage = dephasage;
    }
	

    // Divers ..............................
    public String getIdentity() {
	return CircularGenerator.IDENTITY;
    }

    public Coordinate2D getRange() {
	return new Coordinate2D(offset-Math.abs(amplitude), offset+Math.abs(amplitude));
    }

    // DataFlowAgent interface implement ...............
    public void resetTime() {
	signal = offset;
	updateOutput();
    }

    public void computeNextTic() {
	signal = offset + amplitude * Math.sin(dephasage + Clock.sharedInstance.getTime()*pulsation);
    }
}

