package spikingneuron.generators;

import java.util.Random;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Gnrateur de bruit blanc (pseudo), discret.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Le gnrateur de bruit 'continu' (somme de sinus) pose certains problmes: <BR>
* suivant la frquence d'chantillonnage du signal, ce dernier n'est plus du tout alatoire
* (il ne l'est pas de toute faon, mais il ne s'apparente plus du tout  un signal stochastique),
* et devient une sinusoide plus ou moins dforme (Phnomne tout  fait normal si l'on considre
* la faon de construire ce signal). Par consquent, un gnrateur 'discret', plus basique,  t
* dfinit. Pour chaque tic, une valeur alatoire (uniformment distribue dans une plage donne) est
* gnre. <BR>
* <I> Un tel gnrateur posait problme, mais je ne sais plus de quel ordre... 
* Le fait que le signal change radicalement si l'on modifie la rsolution ne me semble  priori pas
* draisonnable, p. rapport  ce qu'est rellement le bruit.
* <P>
*/
public class DiscreteNoisyGenerator extends SignalGenerator {

    public static final String IDENTITY = "Generateur de bruit discret";

    protected double offset;
    protected double amplitudeMax;
    protected long seed;

    protected Random random;

    private double amplitude2; // AmplitudeMax * 2
    private double increment; // Offset - amplitudeMax

    // Constructeurs ...........................	
    public DiscreteNoisyGenerator() {
	super();
	offset = 0.0;
	amplitudeMax = 0.0;
	seed = System.currentTimeMillis();
	random = new Random(seed);
	signal = offset;
	computeInternalVar();
	updateOutput();
    }

    public DiscreteNoisyGenerator(double I0, double A, long seed) {
	super();
	offset = I0;
	amplitudeMax = A;
	this.seed = seed;
	random = new Random(seed);
	signal = I0;
	computeInternalVar();
	updateOutput();
    }
		
    // Accesseurs .............................
    public double getOffset() {
	return offset;
    }

    public double getAmplitude() {
	return amplitudeMax;
    }

    public long getSeed() {
	return seed;
    }

    public void setOffset(double offset) {
	this.offset = offset;
	computeInternalVar();
    }

    public void setAmplitude(double amplitude) {
	this.amplitudeMax = amplitude;
	computeInternalVar();
    }

    public void setSeed(long seed) {
	this.seed = seed;
	random.setSeed(seed);
    }
	

    // Divers ..............................
    protected void computeInternalVar() {
	amplitude2 = 2 * amplitudeMax;
	increment = offset - amplitudeMax;
    }

	
    public String getIdentity() {
	return DiscreteNoisyGenerator.IDENTITY;
    }

    public Coordinate2D getRange() {
	return new Coordinate2D(offset-amplitudeMax, offset+amplitudeMax);
    }

    // DataFlowAgent interface implement ...............
    public void resetTime() {
	signal = offset;
	updateOutput();
    }

    public void computeNextTic() {
	signal = random.nextDouble()*amplitude2 + increment;
    }
}
