package spikingneuron.generators;

import java.lang.Math;
import spikingneuron.tools.Clock;
import spikingneuron.math.Coordinate2D;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Gnrateur de courant sinusoidal <I>'redress'</I>.
* </TT></STRONG><FONT SIZE=3>
* <P><TT>
* I(t) = Abs (<I>Offset</I> + <I>Amplitude</I>*Sin(<I>Pulsation</I>t + <I>Dephasage</I>)) </TT></BR>
* <P>
*/
public class PositiveGenerator extends CircularGenerator {

    public static final String IDENTITY = "Generateur sinusoidal positif";

    // Constructeurs .........................
    public PositiveGenerator() { super(); }
    public PositiveGenerator(double I0, double A, double w, double phi0) {
	super(I0,A,w,phi0);
    }

    // Divers ..............................
    public String getIdentity() {
	return PositiveGenerator.IDENTITY;
    }
    public Coordinate2D getRange() {
	return new Coordinate2D(Math.abs(offset-Math.abs(amplitude)),
				Math.abs(offset+Math.abs(amplitude)));
    }

    public void computeNextTic() {
	signal = Math.abs(offset + 
			  amplitude * Math.cos(dephasage + Clock.sharedInstance.getTime()*pulsation));
    }
}
