package spikingneuron.generators;

import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.RealFlowProducer;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 Septembre 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base (<B>abstraite</B>) des diffrents modles de gnrateurs de courants.
* </TT></STRONG><FONT SIZE=3>
* <P>
* La classe implment l'interface <CODE>RealFlowProducer</CODE>, le flux de rels tant la squence
* des valeurs du courant externe, en Ampres. <BR>
* La classe laisse une totale libert quand  l'implmentation des diffrents gnrateurs. Elle est par
* consquent trs tnue; les sous-classe doivent dterminer, pour chaque plage temporelle, la valeur
* de l'atrtibut <CODE>signal</CODE>.
* <P>
*/
public abstract class SignalGenerator implements RealFlowProducer {
    public static final String IDENTITY = "Abstract Generator";

    protected double signal;
    protected double output;

    // Constructeurs .....................
    protected SignalGenerator() {
	signal = 0.0;
	output = 0.0;
    }

    // Divers ............................................................
    public String getIdentity() { return SignalGenerator.IDENTITY; }

    // Coord 2d, (Max,Min)
    public abstract Coordinate2D getRange();

    // DataFlowAgent interface implement .....................................
    public abstract void resetTime();

    public double getRealOutput()	{ return output;	}
    public void updateOutput()		{ output = signal;	}
	
    /**
     * Dtermine la valeur du signal pour la prochaine plage temporelle.
     * Les sous-classe ont la responsabilit d'implmenter cette mthode, qui doit mettre  jour
     * l'attribut <CODE>signal</CODE>.
     */
    public abstract void computeNextTic();
}

/*----------------------------------------------------
  Mthodes abstraites:
 --------------------
 public abstract void resetTime()      : reinitialisation du signal.
 public abstract void computeNextTic() : calcul de la prochaine tranche temporelle.
 ------------------------------------------------------- */
