package spikingneuron.generators;

import java.lang.Math;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 27 Mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Gnrateur de courant 'step'.
* </TT></STRONG><FONT SIZE=3>
* <P><TT>
* I(t) = <I>iInitial</I> * H(<I>rt</I> - t)  +  <I>iFinal</I> * H(t - <I>rt</I>) </TT><BR>
* <I>rt</I> = raiseTime, moment de survenance du step. <BR>
* Rt est dtermin en fonction du temps total de simulation,
* au moyen du rapport <CODE> raiseTimeRatio</CODE>.
* <P>
* Algorithme  modifier dans le cas d'une dure de simulation non dterministe.
*/
public class StepGenerator extends SignalGenerator {

    public static final String IDENTITY = "Step Generator";

    protected double iInitial; // [A]
    protected double iFinal; // [A]
    protected double raiseTimeRatio; // [time occ / totalTime]

    private boolean initialized; 
    private double raiseTime; // temps du flanc

    // Constructeurs ...........................	
    public StepGenerator() {
	super();
	iInitial = 0.0;
	iFinal = 0.0;
	raiseTimeRatio = 0.0;
	signal = 0.0;
	updateOutput();
	initialized = false;
	raiseTime = 0.0;
    }

    // Accesseurs & Modificateurs .............................

    public void init(double i0, double i1, double raiseTimeRatio) {
	iInitial = i0;
	iFinal = i1;
	this.raiseTimeRatio = raiseTimeRatio;
    }
	
    public double getInitialCurrent()	{ return iInitial; }
    public double getFinalCurrent()		{ return iFinal; }
    public double getRaiseTimeRatio()	{ return raiseTimeRatio; }

    public void setInitialCurrent(double current)	{ this.iInitial = current; }
    public void setFinalCurrent(double current) 	{ this.iFinal = current; }

    /**
     * @param ratio Rapport entre le temps de survenance du step et le temps total. DV = [0.0, 1.0]
     */
    public void setRaiseTimeRatio(double ratio) { this.raiseTimeRatio = ratio; }
	

    // Divers ..............................
    public String getIdentity() {
	return StepGenerator.IDENTITY;
    }

    public Coordinate2D getRange() {
	return new Coordinate2D(Math.min(iInitial, iFinal),
				Math.max(iInitial, iFinal));
    }

    // DataFlowAgent interface implement ...............
    public void resetTime() {
	signal = iInitial;
	updateOutput();
	raiseTime = Clock.sharedInstance.getInitialTime();
	initialized = false;
    }

    public void computeNextTic() {
	double t = Clock.sharedInstance.getTime();
	if (!initialized) {
	    initialized = true;
	    raiseTime += Clock.sharedInstance.getDuration() * raiseTimeRatio;
	}
	signal =  ((t<raiseTime) ? iInitial : iFinal);
    }
}
