package spikingneuron.math;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 Mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe implmentant une coordonne 2D, par le biais d'un vecteur.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class Coordinate2D extends Vector  {

	// Constructeurs .....................	
	public Coordinate2D() {
		super(2,0.0);
	}
	
	public Coordinate2D(double x, double y) {
		super(2);
		elements[0] = x;
		elements[1] = y;
	}
 
	public Coordinate2D(Coordinate2D stump) {
		super(stump);
	}
	
	public java.lang.Object clone() {
		return new Coordinate2D(this);
	}

	// Divers ...................................
	public void translate(double x, double y) {
		elements[0] += x;
		elements[1] += y;
	}
	
	public void translate(Coordinate2D pnt) {
		add(pnt);
	}
	
	public void setLocation(double x, double y) {
		elements[0] = x;
		elements[1] = y;
	}
	
	public void setLocation(Coordinate2D pnt) {
		this.setElements(pnt);
	}
	
	public void setAbscissa(double x) {
		elements[0] = x;
	}
	public void setX(double x) {
		elements[0] = x;
	}
	public void setC0(double c0) {
		elements[0] = c0;
	}
	
	public void setOrdinate(double y) {
		elements[1] = y;
	}
	public void setY(double y) {
		elements[1] = y;
	}
	public void setC1(double c1) {
		elements[1] = c1;
	}
	
	public double getAbscissa() {
		return elements[0];
	}
	public double getX() {
		return elements[0];
	}
	public double getC0() {
		return elements[0];
	}
	public double getOrdinate() {
		return elements[1];
	}
	public double getY() {
		return elements[1];
	}
	public double getC1() {
		return elements[1];
	}
	
	public void set(double c0, double c1) {
		elements[0] = c0;
		elements[1] = c1;
	}

	/**
	* Retourne la distance euclidienne (val. absolue) entre l'instance et <CODE>pnt</CODE>.
	* @return Un vecteur 2D dont les composantes sont des rels positifs.
	*/
	public Coordinate2D getDistance(Coordinate2D pnt) {
		Coordinate2D ret = new Coordinate2D(pnt);
		ret.sub(this);
		ret.abs();
		return ret;
	}
	
	/**
	* Retourne la distance (signe) entre l'instance et <CODE>pnt</CODE>.
	* @return Un vecteur 2D dont les composantes sont des rels signs.
	*/
	public Coordinate2D getRelDistance(Coordinate2D pnt) {
		Coordinate2D ret = new Coordinate2D(pnt);
		ret.sub(this);
		return ret;
	}
	
	public static Coordinate2D getDistance(Coordinate2D pnt1, Coordinate2D pnt2) {
		Coordinate2D ret = new Coordinate2D(pnt1);
		ret.sub(pnt2);
		ret.abs();
		return ret;
	}
	
	public static Coordinate2D getRelDistance(Coordinate2D pnt1, Coordinate2D pnt2) {
		Coordinate2D ret = new Coordinate2D(pnt1);
		ret.sub(pnt2);
		return ret;
	}
}
