package spikingneuron.math;

import java.awt.*;
import java.lang.Math;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe assurant la transformation des coord. cran en coord. cartsiennes.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Transfo. linaire de l'espace, avec inversion de l'axe y.
* La nouvelle API java (java 2D API) rends cette classe obsolte.
* <P>
*/
public  class Screen2D {
	// Coord Utilisateur <-> Ecran
	
	public Point scrUpperLeft;
	public Point scrLowerRight;
	public Coordinate2D usrUpperLeft;
	public Coordinate2D usrLowerRight;
	public Coordinate2D ratio;
	public boolean reverseAbscissa;
	
	private void computeRatio() {
		ratio.setX( (double)(scrLowerRight.x - scrUpperLeft.x) / 
			(usrLowerRight.getX() - usrUpperLeft.getX()) );
		if (reverseAbscissa)
			ratio.setY( (double)(scrLowerRight.y - scrUpperLeft.y) /
			(usrUpperLeft.getY() - usrLowerRight.getY()) );
		else										
			ratio.setY( (double)(scrLowerRight.y - scrUpperLeft.y) / 
			(usrLowerRight.getY() - usrUpperLeft.getY()));
	}
	
	// Constructeurs......................................
	public Screen2D(int scrX0, int scrY0, int scrX1, int scrY1,
		double usrX0,double usrY0,double usrX1, double usrY1,
		boolean reverseAbscissa) {
		
		this.reverseAbscissa = reverseAbscissa;
		this.scrUpperLeft = new Point(scrX0, scrY0);
		this.scrLowerRight = new Point(scrX1, scrY1);
		this.usrUpperLeft = new Coordinate2D(usrX0, usrY0);
		this.usrLowerRight = new Coordinate2D(usrX1,usrY1);
		this.ratio = new Coordinate2D();			  
		computeRatio();
	}
	
	public Screen2D(Point scrUpperLeft, Point scrLowerRight,
		Coordinate2D usrUpperLeft, Coordinate2D usrLowerRight,
		boolean reverseAbscissa) {
		
		this.reverseAbscissa = reverseAbscissa;
		this.scrUpperLeft = new Point(scrUpperLeft);
		this.scrLowerRight = new Point(scrLowerRight);
		this.usrUpperLeft = new Coordinate2D(usrUpperLeft);
		this.usrLowerRight = new Coordinate2D(usrLowerRight);
		this.ratio = new Coordinate2D();			  
		computeRatio();
	}
	
	public Screen2D(Dimension scrSize, Coordinate2D usrSize,
					boolean mathAbscissa) {
		
		this.reverseAbscissa = reverseAbscissa;
		this.scrUpperLeft = new Point(0,0);
		this.scrLowerRight = new Point(scrSize.width-1 , scrSize.height-1);
		this.usrUpperLeft = new Coordinate2D(0.0,0.0);
		this.usrLowerRight = new Coordinate2D(usrSize);
		this.ratio = new Coordinate2D();			  
		computeRatio();
	}
	
	public Screen2D(Point scrLocation, Dimension scrSize,
		Coordinate2D usrLocation, Coordinate2D usrSize,
		boolean mathAbscissa) {
		
		this.reverseAbscissa = reverseAbscissa;
		this.scrUpperLeft = new Point(scrLocation);
		this.scrLowerRight = new Point(scrLocation.x+scrSize.width-1 ,
									   scrLocation.y+scrSize.height-1);
		this.usrUpperLeft = new Coordinate2D(usrLocation);
		this.usrLowerRight = new Coordinate2D(usrLocation);
		this.usrLowerRight.add(usrSize);
		this.ratio = new Coordinate2D();			  
		computeRatio();
	}
	
	// Accesseurs & Modificateurs (Set & Get) ..................
	public boolean mathOrientation() {
		return reverseAbscissa;
	}

	public Dimension getScrSize() {
		return new Dimension( (scrLowerRight.x - scrUpperLeft.x + 1),
			(scrLowerRight.y - scrUpperLeft.y + 1) );
	}
	public Point getScrLocation() {
		return scrUpperLeft;
	}
	public Point getScrUpperLeft() {
		return scrUpperLeft;
	}
	public Point getScrLowerRight() {
		return scrLowerRight;
	}
	public int getScrMaxX() {
		return scrLowerRight.x;
	}
	public int getScrMinX() {
		return scrUpperLeft.x;
	}
	public int getScrMaxY() {
		return scrLowerRight.y;
	}
	public int getScrMinY() {
		return scrUpperLeft.y;
	}

	public int getScrWidth() {
		return (scrLowerRight.x - scrUpperLeft.x + 1);
	}
	
	public int getScrHeight() {
		return (scrLowerRight.y - scrUpperLeft.y + 1);
	}

	public void setScrSize(Dimension newSize) {
		this.scrLowerRight.setLocation( (scrUpperLeft.x + newSize.width - 1),
			(scrUpperLeft.y + newSize.height - 1) );
		computeRatio();
	}
	public void setScrLocation(Point newLocation) {
		scrLowerRight.x += (newLocation.x - scrUpperLeft.x);
		scrLowerRight.y += (newLocation.y - scrUpperLeft.y);
		scrUpperLeft.setLocation(newLocation);
	}
	public void setScr(Point upperLeft, Point lowerRight)	{
		this.scrUpperLeft.setLocation(upperLeft);
		this.scrLowerRight.setLocation(lowerRight);
		computeRatio();
	}
	public void setScr(int x0, int y0, int x1, int y1)	{
		this.scrUpperLeft.setLocation(x0, y0);
		this.scrLowerRight.setLocation(x1, y1);
		computeRatio();
	}
	
	public Coordinate2D getUsrSize() {
		return Coordinate2D.getDistance(usrUpperLeft, usrLowerRight);
	}
	public Coordinate2D getUsrLocation() {
		return usrUpperLeft;
	}
	public Coordinate2D getUsrUpperLeft() {
		return usrUpperLeft;
	}
	public Coordinate2D getUsrLowerRight() {
		return usrLowerRight;
	}
	public double getUsrMaxX() {
		return usrLowerRight.getX();
	}
	public double getUsrMinX() {
		return usrUpperLeft.getX();
	}
	public double getUsrMaxY() {
		if (reverseAbscissa)
			return usrUpperLeft.getY();
		else
			return usrLowerRight.getY();
	}
	public double getUsrMinY() {
		if (reverseAbscissa)
			return usrLowerRight.getY();
		else
			return usrUpperLeft.getY();
	}
	
	public void setUsrSize(Coordinate2D newSize) {
		usrLowerRight.setX(usrUpperLeft.getX() + newSize.getX());
		if (reverseAbscissa)
			usrLowerRight.setY(usrUpperLeft.getY() - newSize.getY());
		else
			usrLowerRight.setY(usrUpperLeft.getY() + newSize.getY());
	}
	public void setUsrLocation(Coordinate2D newLocation) {
		usrLowerRight.translate(Coordinate2D.getRelDistance(newLocation,
			usrUpperLeft));
		usrUpperLeft.setLocation(newLocation);
	}
	public void setUsr(Coordinate2D upperLeft, Coordinate2D lowerRight)	{
		this.usrUpperLeft.setLocation(upperLeft);
		this.usrLowerRight.setLocation(lowerRight);
		computeRatio();
	}
	public void setUsr(double x0, double y0, double x1, double y1) {
		this.usrUpperLeft.setLocation(x0, y0);
		this.usrLowerRight.setLocation(x1,y1);
		computeRatio();
	}
	
	// Transfo coordonnes utilisateurs -> Coord ecran ..............
	public int scrX(double usrX) {
		return (int)(scrUpperLeft.x +
			Math.round(ratio.getX()*(usrX-usrUpperLeft.getX())) );
	}
	
	public int scrY(double usrY) {
		if (reverseAbscissa)
			return (int)(scrUpperLeft.y +
			Math.round(ratio.getY()*(usrUpperLeft.getY()-usrY)) );
		else
			return (int)(scrUpperLeft.y +
			Math.round(ratio.getY()*(usrY-usrUpperLeft.getY())) );
	}
	
	public int scrWidth(double usrWidth) {
		return (int)Math.round(usrWidth * ratio.getX());
	}
	
	public int scrHeight(double usrHeight) {
		return (int)Math.round(usrHeight * ratio.getY());
	}
	
	public Dimension scrDim(Coordinate2D usrDim) {
		return new Dimension(scrWidth(usrDim.getX()), scrHeight(usrDim.getY()));
	}
	
	public Dimension scrDim(double usrWidth, double usrHeight) {
		return new Dimension(scrWidth(usrWidth), scrHeight(usrHeight));
	}
	
	public Point scrPoint(double usrX, double usrY) {
		return new Point(scrX(usrX), scrY(usrY));
	}
	
	public Point scrPoint(Coordinate2D usrPnt) {
		return new Point(scrX(usrPnt.getX()), scrY(usrPnt.getY()));
	}
	
	
	// Transfo coordonnes ecran -> utilisateurs ................
	public double usrX(int scrX) {
		return usrUpperLeft.getX()+ ((double)(scrX-scrUpperLeft.x)/ratio.getX());
	}
	
	public double usrY(int scrY) {
		if (reverseAbscissa)
			return usrUpperLeft.getY()-((double)(scrY-scrUpperLeft.y)/ratio.getY());
		else
			return usrUpperLeft.getY()+((double)(scrY-scrUpperLeft.y)/ratio.getY());
	}
	
	public double usrWidth(int scrWidth) {
		return ((double)scrWidth/ratio.getX());
	}
	
	public double usrHeight(int scrHeight) {
		return ((double)scrHeight/ratio.getY());
	}
	
	public Coordinate2D usrDim(Dimension scrDim) {
		return new Coordinate2D(usrWidth(scrDim.width),usrHeight(scrDim.height));
	}
	
	public Coordinate2D usrDim(int scrWidth, int scrHeight) {
		return new Coordinate2D(usrWidth(scrWidth),usrHeight(scrHeight));
	}
	
	public Coordinate2D usrPoint(int scrX, int scrY) {
		return new Coordinate2D(usrX(scrX), usrY(scrY));
	}
	
	public Coordinate2D usrPoint(Point scrPnt) {
		return new Coordinate2D(usrX(scrPnt.x), usrY(scrPnt.y));
	}
}
