package spikingneuron.math;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 Mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe implmentant un vecteur mathmatique, de taille quelconque.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Seule les oprations de base sont implmentes.
* Les classes Vector et Matrix sont complmentaires (et toutes 2  completer pour une
* utilisation dans des prob. d'algbre linaire).
* <P>
*/
public class Vector implements java.lang.Cloneable{
	/* Manque: exception lors de dimensions negative, depassement capacites... */

	public double[] elements;
	
	
	static Vector add(Vector v1, Vector v2) {
		/* assert v1.size = v2.size */
		Vector v3 = new Vector(v1);
		for (int i=0; i<v3.elements.length;i++)
			v3.elements[i] += v2.elements[i];
		return v3;
	}
	
	static Vector sub(Vector v1, Vector v2) {
		/* assert v1.size = v2.size */
		Vector v3 = new Vector(v1);
		for (int i=0; i<v3.elements.length;i++)
			v3.elements[i] -= v2.elements[i];
		return v3;
	}
	
	static Vector mul(Vector v1, Vector v2) {
		/* assert v1.size = v2.size */
		Vector v3 = new Vector(v1);
		for (int i=0; i<v3.elements.length;i++)
			v3.elements[i] *= v2.elements[i];
		return v3;
	}
	
	static Vector div(Vector v1, Vector v2) {
		/* assert v1.size = v2.size */
		Vector v3 = new Vector(v1);
		for (int i=0; i<v3.elements.length;i++)
			v3.elements[i] /= v2.elements[i];
		return v3;
	}
	
	// Constructeurs ....................................................................
	
	Vector(int size) {
		/* assert size >= 0 */
		elements = new double[size];
		for (int i=0; i<size;i++)
			elements[i] = 0.0;
	}
	
	Vector(int size, double value) {
		elements = new double[size];
		for (int i=0; i<size;i++)
			elements[i] = value;
	}
	
	Vector(Vector stump) {
		try {
			elements = (double[])stump.elements.clone();
			if (false) throw new CloneNotSupportedException();  // Compatibility with older compilers
		}
		catch (CloneNotSupportedException e) {
			elements = new double[stump.elements.length];
			for (int i=0; i<elements.length; i++)
				elements[i] = stump.elements[i];
		}
	}
	
	public java.lang.Object clone() {
		return new Vector(this);
	}
	
	public int getSize() 	{
		return elements.length;
	}
	
	public void setElement(int index, double value) {
		elements[index] = value;
	}
	
	public void setElements(Vector v) {
		try {
			elements = (double[])v.elements.clone();
			if (false) throw new CloneNotSupportedException();  // Compatibility with older compilers
		}
		catch (java.lang.CloneNotSupportedException e) {
			elements = new double[v.elements.length];
			for (int i=0; i<elements.length; i++)
				elements[i] = v.elements[i];
		}
	}
	
	public double getElement(int index) {
		return elements[index];
	}
	
	public double exchangeElement(int index, double value) {
		double oldValue = elements[index];
		elements[index] = value;
		return oldValue;
	}
	
	public void abs() {
		for (int i=0; i<elements.length;i++)
			elements[i] = java.lang.Math.abs(elements[i]);
	}
	
	public void add(Vector v) {
		for (int i=0; i<elements.length;i++)
			elements[i] += v.elements[i];
	}
	
	public void add(double l) {
		for (int i=0; i<elements.length;i++)
			elements[i] += l;
	}
	
	public void sub(Vector v) {
		for (int i=0; i<elements.length;i++)
			elements[i] -= v.elements[i];
	}
	
	public void sub(double l) {
		for (int i=0; i<elements.length;i++)
			elements[i] -= l;
	}
	
	public void mul(Vector v) {
		for (int i=0; i<elements.length;i++)
			elements[i] *= v.elements[i];
	}
	
	public void mul(double l) {
		for (int i=0; i<elements.length;i++)
			elements[i] *= l;
	}
	
	public void div(Vector v) {
		for (int i=0; i<elements.length;i++)
			elements[i] /= v.elements[i];
	}
	
	public void div(double l) {
		for (int i=0; i<elements.length;i++)
			elements[i] /= l;
	}
	
	/* norme */
	/* prod. scal */
	/* prod vect */
	/* prod mixte */
	/* normalisation */
	/* projection */
	/* angle */
	/* concatenation */
	/* chang. taille */
}
