package spikingneuron.neurons;

import spikingneuron.tools.Clock;
import spikingneuron.tools.RealFlowProducer;
import spikingneuron.tools.SpikeFlowProducer;
import spikingneuron.neurons.NeuronBaseModel;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 21 Juin 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe implmentant le calcul de l'activit d'une population de neurones.
* </TT></STRONG><FONT SIZE=3>
* <P>
* On suppose que tous les neurones instancis font partie de la population, et on utilise le compteur
* (statique) de la classe <CODE>NeuroneBaseModel</CODE> pour sommer le nombre de spike de la population.
* Cela permet de simplifier (et d'acclrer) le calcul de l'activit, tout en restant relativement propre
* (et cohrent avec la modlisation). <BR>
* Rem: on pourrait utiliser la meme tech. pour obtenir la taille de la population... mais cela n'a pas t
* ralis, afin de permettre l'instanciation de neurones sans forcment les inclures dans la population.
* (attention, il ne faut pas qu'ils mettent de spikes). <BR>
* Cette classe s'inscrit dans la hirarchie des <CODE>FlowProducer</CODE>, afin de pouvoir l'utiliser
* ventuellement pour le calcul du potentiel membranaire d'un neurone dans le cas d'une topologie de connexion
* complte.
* <P>
*/

public class PopulationActivity implements RealFlowProducer {

    protected double output;    // activit pour la tranche temporelle prcdante
    protected double activity;  // activit courante.
    protected double dt;        // frq. du calcul de l'activit. (dt >= dt simulation)

    protected int populationSize; // taille de la population.
    protected double nextSample;  // Temps d'chance du prochain chantillonnage.
    private double factor; // Acc. des calculs.
	
    // Constructeurs .........................
    public PopulationActivity(int size, double dt) {
	this.dt = dt;
	this.populationSize = size;
	output = 0.0;
	activity = 0.0;
	nextSample = dt;
    }
	
    // Accesseurs & modificateur ..................
    public void setPopulationSize(int newSize) { populationSize = newSize; }
	
    public int getPopulationsize() { return populationSize; }
	
    public void setDeltaT(double newDt) { dt = newDt; }
    //  if (newDt<Clock.sharedInstance.getDeltaT()) raise someException...;
	
    public double getDeltaT() { return dt; }
	
    // RealFlowProducer implementation .......................	
    public double getRealOutput() { return output; }
    public void updateOutput() { output = activity;}
		
    public void resetTime() {
	output = 0.0;
	activity = 0.0;
	nextSample = dt + Clock.sharedInstance.getInitialTime();
	factor = (dt*populationSize);
	NeuronBaseModel.resetFireCounter();
    }
	
    public void computeNextTic() {
	if (Clock.sharedInstance.getTime() >= nextSample) {
	    activity = ((double)NeuronBaseModel.getFireCounter())/factor;
	    NeuronBaseModel.resetFireCounter();
	    nextSample += dt;
	}
    }
}
