package spikingneuron.neurons;

import java.awt.*;
import java.awt.image.ImageObserver;
import spikingneuron.tools.Clock;
import spikingneuron.drawable.LayeredDrawable;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Modle <B><I>Spike Response Model, long memory</I></B> avec reprsentation
* visuelle de chaque instance.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Les extensions 'Drawable' des modles de neurones sont fortement dpendantes de la
* classe NetworkView. (Modlisation extrmement brouillon !).
*/
public class SRMLongDrawable extends SRMLongMemory implements LayeredDrawable {

    protected NetworkView view;
    protected Rectangle boundle;
    protected Graphics g;
    protected Point center;
    protected Point textPos;
    protected int   diametre;

    protected int colorId;
    protected double  colorRatio;
    protected boolean initialized;
	
	
    // Constructors .....................
    public SRMLongDrawable(int id, NetworkView view) {
	super(id);
	this.view = view;
	boundle = view.addItem(this);
	g = view.getBufferedGraphics();
	diametre = Math.min(20,Math.min(boundle.width-2,boundle.height-2));
	center = new Point(boundle.x+(boundle.width-diametre)/2, boundle.y+(boundle.height-diametre)/2);
	textPos = new Point(center.x - diametre/2, center.y + diametre);
	colorId = 0;
	colorRatio = 0.0;
	initialized = false;
    }

    // Techn. du doubleBuffer, avec le problme de l'impossibilit d'obtenir un context d'affichage tant
    // que la fentre n'est pas dessine (mme avec une image bitMap).
    public void setBufferGraphics(Graphics g) { this.g = g; }	

    public void paintAt(Integer layer) {
	if (layer == LayeredDrawable.LAYER_ONE) {
	    g.setColor(NetworkView.neuronsColor[colorId]);
	    g.fillOval(center.x,center.y,diametre-1,diametre-1);
	    g.setColor(Color.black);
	    g.drawOval(center.x,center.y,diametre,diametre);
	    g.drawOval(center.x,center.y,diametre-1,diametre-1);
	    g.drawString(toString(),textPos.x,textPos.y);
	} else {
	    g.drawImage(view.getNeuronBackImage(),boundle.x, boundle.y,
			boundle.width, boundle.height,view);
	}
    }

    public void updateOutput() {
	int oldColorId = colorId;
	super.updateOutput();
	if ((output == SPIKE_POTENTIAL) || (output == REFRACTORY_POTENTIAL) || !initialized) {
	    initialized = true;
	    colorRatio = NetworkView.MAX_COLORS/(threshold - (meanThreshold + eta0));
	    if (output == SPIKE_POTENTIAL)
		colorId = NetworkView.SPIKE_COLOR;
	    else
		if (output == REFRACTORY_POTENTIAL)
		    colorId = NetworkView.REFRACTORY_COLOR;
		else {
		    colorId = (int)((output-(meanThreshold + eta0))*colorRatio);
		    colorId = Math.max(0, Math.min(NetworkView.MAX_COLORS,colorId));
		}

				
	} else {
	    colorId = (int)((output-(meanThreshold + eta0))*colorRatio);
	    colorId = Math.max(0, Math.min(NetworkView.MAX_COLORS,colorId));
	}
			
	if (colorId!=oldColorId)
	    view.addChangedItem(this);
    }
			
    public void resize(Graphics g,Rectangle newRect) {
	boundle = newRect;
	diametre = Math.min(15,Math.min(boundle.width-2,boundle.height-2));
	center.x = boundle.x+(boundle.width-diametre)/2;
	center.y = boundle.y+(boundle.height-diametre)/2;
	textPos.x = center.x - diametre/2;
	textPos.y = center.y + diametre;
	this.g = g;
    }
}
