package spikingneuron.neurons;

import java.util.Enumeration;
import spikingneuron.tools.Clock;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe modlisant les neurones appartenant au modle <I>Spike Response Model
* (long memory)</I>.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Ce modle dcrit la raction au propres impulsions comme la superposition des kernels
* (eta) de toutes les impulsions.
* <P>
*/
public class SRMLongMemory extends SpikeResponseModel {

    public static final String IDENTITY = "SpikeResponse (Long Mem.)";

    // Constructors ..................................................
    public SRMLongMemory(int id) {
	super(id);
    }
	
    // Divers .......................................................
    public String getIdentity() {
	return SRMLongMemory.IDENTITY;
    }

    protected double myFiringResponse(double t) {
	// il faut sommer les eta de tous les spikes:
	double kernel = 0;
	for (Enumeration firingTimes = spikeTrain.elements(); firingTimes.hasMoreElements() ;)
	    kernel += eta(t - refractoryTime - ((Double)firingTimes.nextElement()).doubleValue());
	return kernel;
    }
}
