package spikingneuron.neurons;

import spikingneuron.tools.Clock;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe modlisant les neurones appartenant au modle <I>Spike Response Model,
* short memory</I>.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Ce modle dcrit la raction au propres impulsions du neurone en ne prenant en compte
* que la dernire mise: soit le kernel eta du dernier spike.
* <P>
*/

public class SRMShortMemory extends SpikeResponseModel {

    public static final String IDENTITY = "SpikeResponse (Short Mem.)";

    // Constructors ....................................................
    public SRMShortMemory(int id) {
	super(id);
    }
	
    // Divers ...........................................................
    public String getIdentity() {
	return SRMShortMemory.IDENTITY;
    }

    protected double myFiringResponse(double t) {
	if (spikeTrain.isEmpty())
	    return 0.0;
	else
	    return eta(t - integrationStartTime); // faster
	//			return eta(t - refractoryTime -
	//		 			((Double)spikeTrain.lastElement()).doubleValue());
    }
}
