package spikingneuron.tools;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Modlisation d'une horloge.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Cette classe permet d'instancier des horloges, assurant l'coulement d'un temps commun (unique)
*  plusieurs objets. L'implmentation tant 'passive' (pas de flux d'excution propre), il est laiss
*  la responsabilit de l'utilisateur de cette classe de simuler l'avance du temps, par l'invocation
* d'un couple de mthodes.<BR>
* Le temps est dcoup en intervalles (par opposition  une succession d'instants) de dure
* <CODE>delta t</CODE>, et dont la limite suprieure (limite  droite) est donne par l'horloge
* (mmorise dans l'attribut <CODE>time</CODE>).
* <P><TT>
* <B>Remarques: </B></TT><UL TYPE = disc>
* <LI> Une implmentation passive d'un tel objet est pour le moins trange, la nature de l'lment en faisant
* un objet actif par excellence. Cette observation peut galement tre faite pour d'autres classes de
* l'application (les gnrateurs et les neurones). Le choix d'une telle implmentation (il va de soit que tous
* ces lments doivent tres programms en utilisant une mme approche) a t impos pour des raisons 
* d'efficacit (au dtriment de l'esthtisme de la modlisation, et de la lisibilit du code). Dans le cas
* d'un rseau de neurones interconnects, le nombre de <I>threads</I> devient trop important
* (rseau carr: il faut n*n threads pour les neurones) pour que l'application soit utilisable. En fait,
* c'est l'initialisation des threads qui pose le principal problme (temps d'initialisation prohibitif,
* mais une fois l'initialisation effectue, les systmes d'exploitations semblent assez bien supporter la
* coexistence de plusieurs milliers de threads, ce qui n'est pas le cas des navigateurs...).
* <LI> Cette solution  t adopte avant le codage du programme rseau... or on s'aperoit que grer un rseau
* de plusieurs milliers de neurones est illusoire... donc on aurait certainement pu implmenter une version
* concurrente, avec quelque centaines d'objets actifs...
* <LI> Une instance, <CODE><B>sharedInstance</B></CODE> est dfinie en tant qu'attribut publique de la classe.
* </UL><BR>
*/
public class Clock implements DataFlowAgent{
    // Le fait d'implementer DataFlowAgent est  la limite du licite...

    public static final Clock sharedInstance = new Clock();

    protected double time;
    protected double delta;
    protected double initialTime;
    protected double maxTime;

    // Constructeurs .....................	
    public Clock() {
	time = 0.0;
	delta = 0.0;
	maxTime = 0.0;
	initialTime = 0.0;
    }
	
    public Clock(double dt) {
	time = 0.0;
	delta = dt;
	maxTime = 0.0;
	initialTime = 0.0;
    }
	
    public Clock(double initialTime, double dt) {
	time = initialTime;
	delta = dt;
	maxTime = 0.0;
	this.initialTime = initialTime;
    }
	
    public Clock(double initialTime, double dt, double maximalTime) {
	time = initialTime;
	delta = dt;
	maxTime = maximalTime;
	this.initialTime = initialTime;
    }
	

    // Accesseurs ...............................
    public void set(double time, double dt, double initialTime, double maximalTime) {
	this.delta = dt;
	this.time = time;
	this.maxTime = maximalTime;
	this.initialTime = initialTime;
    }
    public void setTime(double time) { this.time = time; }
    public void setDeltaT(double dt) { this.delta = dt;	 }
    public void setInitialTime(double initialTime) { this.initialTime = initialTime; }
    public void setMaximalTime(double maximalTime) { this.maxTime = maximalTime; }
	
    public double getTime() 	{ return time;  }
    public double getDeltaT()	{ return delta; }
    public double getInitialTime() { return initialTime; }
    public double getMaximalTime() { return maxTime; }
	
    public double getDuration() { return maxTime-initialTime; }

    // Divers .....................
	
    public boolean tic() { // Gestion des limites (mise en sommeil de la tache)...
	if (time<maxTime) {
	    computeNextTic();
	    return true;
	} else return false;
    }
		

    // DataFlowAgent interface implements ............

    /* L'horloge ne fonctionne pas comme les autres DataFlowAgent
       (c'est d'ailleur pourquoi le fait d'implementer cette interface
       n'est pas vraiment correct): la sortie est immdiatement mise 
       jour lorsque qu'un nouveau tic est 'gnr' (updateOutput est
       sans effet). La sortie (etat) de chaque simulatedElement est
       initialise par dfaut pour t=0. Pour ne pas devoir recalculer
       cette valeur (c'est-a-dire etat(t=0)) aprs le premier tic,
       il est ncessaire que celui-ci soit immdiatement reflt par
       l'horloge, sans retard. (on peut dire que le temps t=0 s'est dj
       coul lors de l'initialisation).
    */
    public void updateOutput()		{}
    public void resetTime()			{ time = initialTime; }
     public void computeNextTic()	{ time += delta; }
    public double getRealOutput()	{ return time; }
}
