package spikingneuron.tools;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface de base des lments interagissant avec le flux de donnes.
* </TT></STRONG><FONT SIZE=3>
* Le flux de donnes (v.s. flux de contrle) n'est pas physiquemment modlis; il ne s'agit en fait que de
* valeurs (actuellement des flottants), symbolisant des tats instantan d'objets. Cette interface ne
* concerne donc pas ce flux, mais les acteurs en interaction avec lui: producteurs, consommateurs, observateurs...
* <BR><BR><TT><B>Remarques: </B></TT><UL TYPE = disc>
* <LI>	Avec une telle implmentation, le flux de donnes est compos exclusivement de flottants (Le type
* 		de donnes devrait tre tendu au type <SAMP>Object</SAMP>, mais cela ncessite l'emploi systmatique
*		des <SAMP>class wrappers</SAMP>).
* <LI>	L'application n'admettant aucun objet actif, il n'est pas ncessaire de modliser un flux rel de
*		donnes. (Donnes temporellement estampilles, horloge active avec veil des tche, etc.).
* <LI>	Le couple d'actions qui permet de simuler la simultanit implique que l'tat futur de l'instance
*		soit calcul  partir de l'tat actuel des entres: <BR>
* <TT>	(etat(t+dt) = f (input(t)) et non f (input(t+dt)).</TT>
* </UL><BR>
*/

public interface DataFlowAgent {

    /**
     * Indique  l'instance que le 'temps'  t rinitialis.
     * L'invocation de cette mthode a comme consquence une rinitialisation
     * de tous les paramtres en relation avec le flux de donnes, notamment l'tat
     * de sortie de l'objet, dans le cas d'un producteur.
     * <BR>*/
    public abstract void resetTime();

    /** 
     * Indique  l'objet que le temps s'est coul, et qu'il faut actualiser
     * son tat, en gnral en fonction de ses entres.
     * <BR><TT><B>Remarques: </B></TT><UL TYPE = circle>
     * <LI>Dans une version concurrente (avec objet actifs), cette mthode
     * n'a plus lieu d'tre. Elle est implicitement ralise par le couple
     * d'actions mise en attente - veil. (Lorsque le traitement des entres
     * est termin, l'objet se place en attente sur un signal de l'horloge.
     * Lorsqu'une nouvelle portion de temps est atteinte, l'horloge veil
     * tous les processus en attente, ce qui correspond  l'excution de
     * cette mthode.
     * </UL><BR>*/
    public abstract void computeNextTic();

}
