package spikingneuron.tools;

import java.awt.Font;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.FontMetrics;

import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentAdapter;
import java.util.Vector;
import java.util.Enumeration;

import javax.swing.border.Border;
import javax.swing.JPanel;
import javax.swing.JComponent;
import javax.swing.UIManager;

import spikingneuron.drawable.Drawable;
import spikingneuron.drawable.DisplayContext;
import spikingneuron.math.Screen2D;
import spikingneuron.math.Coordinate2D;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 2 Juillet 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Implmente une zone pour le trac de courbe.
* </TT></STRONG><FONT SIZE=3>
* <P>
* GrapheCanvas est un (J)Component permettant le trac d'une ou plusieurs courbes, avec systmes
* d'axes (orthog.) et graduations. <BR>
* Extension: Utiliser un ScrollPane, les facilits introduites par Java2D API.
* Les lments  dessiner (axes, grille, graduations...) devraient tre implment en tant que
* classes indpendante, <I>'Drawable'</I>.
* <P>
*/
public class GraphCanvas extends JPanel { // <- JComponent <- Canvas

    private static final double LOG_E = 0.4342944818;

    public Color pntColor;
    public Color axesColor;			// Couleur des axes
    public Color gridColor;			// Couleur de la grille (non implmente)
    public Color borderColor;		// Couleur de la bordure
    public Color backgroundColor;	// Couleur du fond

    public boolean axes;		// trac des axes ?
    public boolean grid;		// trac d'une grille ?
    public boolean border;		// trac de la bordure ?
	
    public Font fontLabel;		// police des labels
	
    public double xFactor;		// Coef. pour les labels de l'axe 'x'
    public double yFactor;		// Coef. pour les labels de l'axe 'y'

    protected Dimension dim;
    protected Insets borderSize;
    protected Screen2D view;
    protected Vector drawableItems; // of Drawable
    protected FontMetrics fontLabelMetrics;
    protected DisplayContext displayCtx;	

    public GraphCanvas(int initialWidth, int initialHeight,
		       double extendX, double minX, double maxX,
		       double extendY, double minY, double maxY) {
	super(true);
	setOpaque(true);
		
        fontLabel = this.getFont();
        if (fontLabel == null)
	    fontLabel = UIManager.getFont("Panel.font");
	fontLabelMetrics = getFontMetrics(fontLabel);

	axes = true;
	grid = false;
	border = true;
	pntColor = Color.red;
	axesColor = Color.darkGray;
	gridColor = Color.gray;
	borderColor = Color.black;
	backgroundColor = Color.white;
		
	xFactor = 1.;
	yFactor = 1.;

	drawableItems = new java.util.Vector(100,20);
	dim = new Dimension(initialWidth, initialHeight);
	borderSize = getInsets();

	// Changement de dimension gr par une classe interne anonyme.
	this.addComponentListener(new ComponentAdapter() {
		public void componentResized(ComponentEvent event) {
		    dim = getSize();
		    view.setScr(borderSize.left + 2,
				borderSize.top,
				dim.width - borderSize.right - 1,
				dim.height - borderSize.bottom - 1);
		    displayCtx.resetGraphics();
		}
	    });
	double xMargins = extendX *(maxX-minX);
	double yMargins = extendY *(maxY-minY);
	minX -= xMargins;
	minY -= yMargins;
	maxX += xMargins;
	maxY += yMargins;
	view = new Screen2D(borderSize.left + 2,
			    borderSize.top,
			    dim.width - borderSize.right - 1,
			    dim.height - borderSize.bottom - 1,
			    minX,maxY,maxX,minY,true);
	displayCtx = new DisplayContext(this, view);
    }

    public Dimension getPreferredSize() {
	return dim;
    }
    public synchronized Dimension getMinimumSize() {
	return dim;
    }
	
    /*
     * Repris par Sbastien Baehni.
     * On ne peut pas faire de getBorderInsets(this). 
     * Ceci pour la simple raison que lorsque l'on cre un GraphCanvas,
     * le constructeur appel super(true), qui lui, appelle aprs un
     * certain nombre de pas, la classe LookAndFeel de swing. Celle-ci
     * appelle alors la mthode setBorder de JPanel, mais avant va regarder
     * si il existe une mthode setBorder dans le code. Or comme elle existe,
     * il l'utilise, mais aprs test, il s'avre que le border que LAF lui
     * passe est null => NullPointerException. Il faudrait incorporer 
     * le code de setBorder de JComponent (cf. sources java). 
     * J'ai remarqu que si on supprimait cette mthode, rien de spcial ne 
     * changeait dans l'interface graphique d'ou ...
     */
    /*public void setBorder(Border border) {
      super.setBorder(border);
      borderSize = border.getBorderInsets(this);
      }*/
	
    // Accesseurs & Modificateurs non implments !
	
    public void changeVirtualBounds(double extendX, double minX, double maxX,
				    double extendY, double minY, double maxY) {
	double xMargins = extendX *(maxX-minX);
	double yMargins = extendY *(maxY-minY);
	view.setUsr(minX-xMargins,maxY+yMargins,maxX+xMargins,minY-yMargins);
    }							

    public void setAxesLabelFactor(double xFactor, double yFactor) {
	this.xFactor = xFactor;
	this.yFactor = yFactor;
    }
	
	
    public void addItem(Drawable item) {
	drawableItems.addElement(item);
    }		

    public void addSynchronizedItem(Drawable item)	{
	drawableItems.addElement(item);
	item.addDisplayContext(displayCtx);
	item.setDisplaySynchro(true);
    }
	
    public void removeItem(Drawable item) {
	drawableItems.removeElement(item);
    }
	
    public void update() {
	//		invalidate(); repaint();	
	update(getGraphics());
    }
	

    public void setFontLabels(Font newFont) {
	fontLabel = newFont;
	fontLabelMetrics = getFontMetrics(fontLabel);
    }
	
	
    public void paint (Graphics g) {
	// Avec Swing (1.0.3), les evenement 'resize' ne sont pas toujours correctement gnrs ! 
	if (!dim.equals(getSize())) {
	    dim = getSize();
	    view.setScr(borderSize.left + 2,
			borderSize.top,
			dim.width - borderSize.right - 1,
			dim.height - borderSize.bottom - 1);
	    displayCtx.setGraphics(g);
	}
	//super.paint(g); // Border, Child & Background
	super.repaint();
	
	g.setColor(backgroundColor);
	g.fillRect(view.getScrMinX(),
		   view.getScrMinY(),
		   view.getScrWidth(),
		   view.getScrHeight());
	
	if (border) { // Swing: addBorder
	    g.setColor(borderColor);
	    g.drawRect(view.getScrMinX() - 1,
		       view.getScrMinY() - 1,
		       view.getScrWidth() + 2,
		       view.getScrHeight() + 2);
	}
	if (axes) {
	    Coordinate2D sz = view.getUsrSize();
	    double graduateX = Math.pow(10,Math.round(LOG_E*Math.log(sz.getX()))-1);
	    double graduateY = Math.pow(10,Math.round(LOG_E*Math.log(sz.getY()))-1);
	    drawAxes(g,graduateX,graduateY,7,7,10,true,true);
	}
	//		if (grid) {
	//			g.setColor(gridColor);
	//			...
	//		}
	
	
	/*
	  A terme, tous les elements affichables devraient etre inclus dans la
	  hierarchie Drawable. La mthode paint se rsumera alors  :
	*/
	for (Enumeration item=drawableItems.elements(); item.hasMoreElements();)
	    ((Drawable)item.nextElement()).redrawAt(g,view);
	
    }


    protected void drawAxes(Graphics g, double stepX, double stepY, int sizeX, int sizeY,
			    int sizeArrow, boolean textGradX, boolean textGradY) {

	/* Les axes sont tracs sur les origines, ou au bord de la fenetre si les orig. ne sont
	   pas dans la zone de visualisation.
	   Manque: rendre propre (dans une classe), texte des graduations principales,
	   graduation secondaires, type des extremites, lgendes des axes,
	   grille.
	*/
		
	boolean gradueX = (stepX>0.)&&(sizeX>0);
	boolean gradueY = (stepY>0.)&&(sizeY>0);
		
	int nbGradXP, nbGradXN, nbGradYP, nbGradYN; // nb de graduations

	g.setColor(axesColor);
	boolean inWindowX, inWindowY;
	boolean positiveX = true;
	boolean positiveY = true;
	// Determination des axes a tracer:
	inWindowX = ((view.getUsrMinY()<0.)&&(view.getUsrMaxY()>0.));
	inWindowY = ((view.getUsrMinX()<0.)&&(view.getUsrMaxX()>0.));
	// Trace de l'axe X 
	int origY; // ordonnee du trace de l'axe X
	int gradY0, gradY1; // ordonnees limites des graduations
	int maxX = view.getScrMaxX()-2;
	if (inWindowX) {
	    origY = view.scrY(0.0);
	    gradY0 = origY + sizeX / 2;
	    gradY1 = origY - sizeX / 2;
	} else {
	    positiveY = !(view.getUsrMaxY() < 0.0);
	    if (!positiveY) {
		origY = view.getScrMaxY(); // +2;
		gradY0 = origY;
		gradY1 = origY + sizeY / 2;
	    } else {
		origY = view.getScrMinY(); // -2;
		gradY0 = origY - sizeY / 2;
		gradY1 = origY;
	    }
	}
	// Trace de l'axe x
	g.drawLine(view.getScrMinX(),origY,maxX,origY);
	// Trace de l'extremite, s'il y a lieu
	if (sizeArrow>0) {
	    Polygon arrow = new Polygon();
	    arrow.addPoint(maxX,origY);
	    arrow.addPoint(maxX-sizeArrow, origY-sizeArrow/2);
	    arrow.addPoint(maxX-sizeArrow, origY+sizeArrow/2);
	    g.fillPolygon(arrow);
	}
	// Trace les graduation, s'il y a lieu
	nbGradXP = 0;
	nbGradXN = 0;
	if (gradueX) {
	    double max = view.getUsrMaxX();
	    double min = view.getUsrMinX();
	    double x = 0.0;
	    int scrX;
	    while ( (x+=stepX)<max) {
		scrX = view.scrX(x);
		g.drawLine(scrX,gradY0,scrX,gradY1);
		nbGradXP++;
	    }
	    x = 0.0;
	    while ( (x-=stepX)>min) {
		scrX = view.scrX(x);
		g.drawLine(scrX,gradY0,scrX,gradY1);
		nbGradXN++;
	    }
	}
	// Trace de l'axe Y 
	int origX; // abscisse du trace de l'axe Y
	int gradX0, gradX1; // abscisses limites des graduations
	int maxY = view.getScrMinY()+2;
	if (inWindowY) {
	    origX = view.scrX(0.0);
	    gradX0 = origX - sizeY / 2;
	    gradX1 = origX + sizeY / 2;
	} else {
	    positiveX = !(view.getUsrMaxX()<0.);
	    if (!positiveX) {
		origX = view.getScrMaxX(); // -2;
		gradX0 = origX - sizeY / 2;
		gradX1 = origX;
	    } else {
		origX = view.getScrMinX(); // +2;
		gradX0 = origX;
		gradX1 = origX + sizeY / 2;
	    }
	}
	// Trace de l'axe y
	g.drawLine(origX,view.getScrMaxY(),origX,maxY);
	// Trace de l'extremite, s'il y a lieu
	if (sizeArrow>0) {
	    Polygon arrow2 = new Polygon();
	    arrow2.addPoint(origX,maxY);
	    arrow2.addPoint(origX-sizeArrow/2, maxY+sizeArrow);
	    arrow2.addPoint(origX+sizeArrow/2, maxY+sizeArrow);
	    g.fillPolygon(arrow2);
	}
	// Trace les graduation, s'il y a lieu
	nbGradYP = 0;
	nbGradYN = 0;
	if (gradueY) {
	    double max = view.getUsrMaxY();
	    double min = view.getUsrMinY();
	    double y = 0.0;
	    int scrY;
	    while ( (y+=stepY)<max) {
		scrY = view.scrY(y);
		g.drawLine(gradX0,scrY,gradX1,scrY);
		nbGradYP ++;
	    }
	    y = 0.0;
	    while ( (y-=stepY)>min) {
		scrY = view.scrY(y);
		g.drawLine(gradX0,scrY,gradX1,scrY);
		nbGradYN ++;
	    }
	}
	// Affiche les items gradues s'il y a lieu
	if (textGradY) {
	    g.setFont(fontLabel);
	    setForeground(Color.black);
	    int textLength;
	    int textHalfHeight = fontLabelMetrics.getHeight()/2 - 2;
	    if (gradueY) { // Synchro text et graduation
		double max = view.usrY(maxY+sizeArrow);
		double min = view.getUsrMinY();
		double y;
		boolean flag = true;
				// if (positiveX)
		int baseLineX = gradX1 + 3;
		y = 0.0;
		while ((y+=stepY)<max)
		    if (flag = !flag)
			// La conversion Double -> Float permet d'effacer les derives visibles avec
			// un type affichant trop de decimales... 0.0+10*0.1 = 0.999999999 p. ex.
			g.drawString(Float.toString((float)(y*yFactor)),baseLineX,view.scrY(y)+textHalfHeight);
		y = 0.0;
		flag = true;
		while ((y-=stepY)>min)
		    if (flag = !flag)
			g.drawString(Float.toString((float)(y*yFactor)),baseLineX,view.scrY(y)+textHalfHeight);
	    } else {} // Cas a traiter...
	}
	if (textGradX) {
	    g.setFont(fontLabel);
	    setForeground(Color.black);
	    int textLength;
	    if (gradueY) { // Synchro text et graduation
		int baseLineY;
		if (inWindowY || positiveY)
		    baseLineY = gradY0 + fontLabelMetrics.getHeight() - 2;
		else
		    baseLineY = gradY1; // a determiner
		double x = (nbGradXP / 2) * stepX;
		String str = new String(Float.toString((float)(x*xFactor)));
		textLength = fontLabelMetrics.stringWidth(str);
		g.drawString(str,view.scrX(x)-textLength/2,baseLineY);
	    } else {}
	}
    }
}
