package spikingneuron.tools;

import java.util.Enumeration;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 Juin 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface dfinissant un agent gnrant un flux de donnes de type <I>'Spike train'</I>.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public interface SpikeFlowProducer extends DataFlowProducer {

    /**
     * Limite de la taille du train d'impulsions dans le cas ou
     * <CODE>"SPIKE_TRAIN_LIMITED_SIZE"</CODE> est vrai, et valeur d'incrment
     * (<I>growing</I>) de l'espace reserv dans le cas contraire.
     */
    public static final int SPIKE_TRAIN_SIZE = 20;
	
    /**
     * Dtermine si la taille du train d'impulsions est borne ou non.
     */
    public static final boolean SPIKE_TRAIN_LIMITED_SIZE = true;

    /**
     * Retourne le train d'impulsions <I>(spike train)</I> de l'objet, dfinit comme un ensemble de
     * <I>'firing time'</I>, en secondes.
     * Deux appels successifs (dans une mme tranche de temps) doivent retourner une squence identique.
     * @return Un ensemble de Double, reprsentant les temps d'occurrence des impulsions.
     */
    public abstract Enumeration getSpikesOutput();
}
