package spikingneuron.tools;

import java.applet.Applet;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.awt.Color;
import javax.swing.ImageIcon;


/**
 *<FONT SIZE=2>
 * @version 1.0, Lausanne le 27 Juin 1998 
 * @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
 * <P><FONT SIZE=4><TT><STRONG>
 * Classe 'poubelle', contenant divers routines (mthodes statiques) pratiques. </STRONG><BR>
 * (Qui n'ont pas vraiment de place ailleurs).
 * </TT></STRONG><FONT SIZE=3>
 * <TT><B>Outils: </B></TT><UL TYPE = disc>
 * <LI>Cration d'icones  partir de fichier  images, ventuellement contenu dans un Jar.
 * <LI>Modification souples de couleurs (+/- claires).
 * <LI>... 
 * </UL><P><DL>
 * <DT><B>Initialisation: </B>
 * <DD>	Pour un chargement correct des images depuis une applet, il faut
 * 		initialiser ( 'vrai') l'attribut de classe <CODE>isAnApplet</CODE>.</DL>
 * <P>
 */
public class Tools {

    /**
     * Flag indiquant si le programme qui utilise la classe fonctionne en tant qu'applet (true), ou
     * en tant qu'application.
     * <BR><B>Ce flag est  initialiser explicitement par le programme 'client' .</B>
     * Le fait de rendre cet attribut statique implique naturellement des consquences quant  une
     * utilisation partage de la classe... mais cela ne devrait pas tre dramatique ! (On pourrait
     * passer ce flag en paramtre  la mthode <CODE>loadImageIcon</CODE>, qui est actuellement la 
     * seule  l'utiliser).
     * @see spikingneuron.tools.Tools#loadImageIcon(Applet,String,String)
     */
    public static boolean isAnApplet = false;

    /**
     * Charge une image en tant que ressource (depuis un fichier Jar).
     * <BR><CITE>Adaptation de <CODE>swing.LookAndFeel.makeIcon</CODE>.<BR></CITE>
     * Problme: avec une mthode traditionnel, il n'est pas possible (en tout cas, je n'y suis pas
     * arriv avec la version actuelle de JDK (1.1.6)) de charger une image stocke dans un fichier
     * Jar; le systme essayant systmatiquement de charger le fichier 'externe'. S'il ne le trouve
     * pas, une image vide est retourne. L'astuce consiste  utiliser le <I>class-loader</I> pour
     * charger la ressource, puisque le chargement de classes depuis un fichier Jar ne pose pas de
     * problme. De plus, de nombreux navigateur interdisent, pour des raisons de scurit, le 
     * chargement de fichiers par une applet (paramtrage souvent dlicat). Cette faon de procder
     * permet de contourner cette interdiction. <BR>
     * La manire de procder pour l'implmentation de cette mthode est tire de <I>swing</I>
     * (jdk 1.2 Beta 3), mthode <CODE>swing.LookAndFeel.makeIcon</CODE>, et fonctionne sans problme
     * avec jdk 1.1.5 (application), NetscapeCommunicator 4.05 Beta (AWT 1.1.5) et Microsoft 
     * Internet Explorer 4.0 (applet).
     * <P>
     * @param	baseClass
     * <DL><DD>		classe utilise pour charger la ressource. (Employer <CODE>getClass()</CODE> de
     *				<CODE>java.lang.Object</CODE> pour obtenir cette objet).</DL>
     *
     * @param	filename
     * <DL><DD>		Nom du fichier contenant l'image  charger. Cette image doit tre dans un format
     *				reconnu par java (GIF, JPEG...). Si le nom du fichier dbute par <TT>'/'</TT>, 
     *				le <I>class-loader</I> le considre comme nom absolu, et charge le fichier spcifi
     *				par <CODE>filename</CODE>. Sinon (autre caractre), le class-loader utilise 
     *				le nom du package de <CODE>baseClass</CODE> pour prfixer le nom de fichier.<BR>
     *				<B>Attention:</B>  la formation du nom avec comme prfixe le nom du package n'est
     *				pas vraiment vraiment rigoureux. Avec JDK 1.1.4, 1.1.5, c'est effectiviement le 
     *				nom du package qui est utilis, et seulement lui. Avec Microsoft ou Caf (je ne
     *				sais plus, mais l'un d'entre eux), c'est le nom du package + celui de la classe
     *				qui sont utilis en prfixe... et pour finir, il semble qu'avec JDK 1.2, ce soit
     *				galement le nom du package et celui de la classe qui soient utiliss, avec tout
     *				de mme une diffrence par rapport aux prcdents: le nom complet de la classe 
     *				est utilis... donc, si on fournit pour <CODE>baseClass</CODE> une 
     *				<I>inner-class</I>, la source devra se situer dans un rpertoire nomm
     *				<TT>package/parentClass$innerClass/filename</TT>. (Je ne sais pas ce que cela
     *				donne avec une classe anonyme, mais ce doit tre passionnant).</DL>
     *
     * @param	description
     * <DL><DD>		Brve description de l'image. (Peut-tre <TT>'null'</TT>).
     *				(Utilis avec java Accessibility ?) </DL>
     *
     * @return	L'image spcifie, sous la forme <CODE>ImageIcon</CODE><I> (Swing)</I>, ou <TT>null</TT>
     *			si la ressource n'a pas put tre charge (un message d'erreur est dans ce cas affich
     *			sur la sortie d'erreurs standard).
     */
    public static final ImageIcon loadImageIcon(final Class baseClass,
						final String filename,
						final String description) {
	byte[] buffer = null;
	try {
	    /* Copy resource into a byte array.  This is necessary because several
	     * browsers consider Class.getResource a security risk because it can be
	     * used to load additional classes.
	     * Class.getResourceAsStream just returns raw bytes, which we can convert
	     * to an image.
	     */
	    InputStream resource = baseClass.getResourceAsStream(filename);
	    if (resource == null) {
		System.err.println(baseClass.getName()+ "/"+ filename +" not found.");
		return null;
	    }
	    BufferedInputStream in = new BufferedInputStream(resource);
	    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
	    buffer = new byte[1024];
	    int n;
	    while ((n = in.read(buffer)) > 0) {
		out.write(buffer, 0, n);
	    }
	    in.close();
	    out.flush();
	    buffer = out.toByteArray();
	    if (buffer.length == 0) {
		System.err.println("warning: "+ filename +" is zero-length");
		return null;
	    }
	} catch (IOException ioe) {
	    System.err.println(ioe.toString());
	    return null;
	}
	return new ImageIcon(buffer, description);
    }
	

    /**
     * Charge une image depuis un fichier sur le disque.
     * Suivant la valeur de l'attribut <CODE>isAnApplet</CODE>, l'image va tre charge depuis un 
     * fichier rsident via un chemin d'accs standard, spcifi par <CODE>filename</CODE>, ou via un 
     * URL (<CODE>applet.codeBase</CODE>). Si une erreur survient (fichier non trouvable, url erronn...),
     * un message est affich sur la sortie erreur standard, et <TT>'null'</TT> est retourn.
     * <P>
     * @param	applet
     * <DL><DD>		Applet dsireuse de charger l'image.</DL>
     * @param	filename
     * <DL><DD>		Nom du fichier contenant l'image  charger si <CODE>isAnApplet</CODE> est faux.
     *				Cette image doit tre dans un format reconnu par java (GIF, JPEG...). <BR>
     *				Si <CODE>isAnApplet</CODE> est vrai, <I>spcifications</I> de l'URL utilis
     *				(<CITE>String representation</CITE>), l'URL tant celui de l'applet.</DL>
     * @param	description
     * <DL><DD>		Brve description de l'image. (Peut-tre <TT>'null'</TT>). (Utilis avec java
     *				Accessibility ?)</DL>
     * @return		L'image spcifie, sous la forme<CODE>ImageIcon</CODE> <I>(Swing)</I>, ou <TT>null</TT>
     *			si la ressource n'a pas put tre charge (un message d'erreur est dans ce cas affich
     *			sur la sortie standard 'Erreur').
     */
    public static final ImageIcon loadImageIcon(final Applet applet,
						final String filename,
						final String description) {
	if (isAnApplet) {
	    URL url;
	    try { url = new URL(applet.getCodeBase(),filename); }
	    catch(MalformedURLException e) {
		System.err.println("Error trying to load image " + filename);
		return null;
	    }
	    return new ImageIcon(url, description);
	}
	else
	    return new ImageIcon(filename, description);
    }


    /**
     * Retourne une version soit plus claire soit plus fonce d'une couleur donne.
     * Version plus souple de <CODE>java.awt.Color.brighter() & java.awt.Color.darker()</CODE>.
     * La nouvelle couleur est cre en appliquant le facteur pass en paramtre aux composantes
     * RGB de la couleur originale (les composantes sont multiplies par ce facteur).
     *<P>
     * @param	stump
     * <DL><DD>		Couleur originale.</DL>
     * @param	factor
     * <DL><DD>		Facteur employ. <B>Ne doit pas tre ngatif !</B><BR>
     *				[0,1[ -> retourne une couleur plus fonce (0 = noir, 1 = couleur originale).<BR>
     *				]1,+inf[ -> retourne une couleur plus claire.</DL>
     * @return		La nouvelle couleur base sur la couleur originale, mais de luminosit diffrente.
     * @see java.awt.Color#darker()
     * @see java.awt.Color#brighter()
     */
    public static Color brightness(Color stump, double factor) {
	return new Color(	Math.min( (int) (stump.getRed()*factor),	255),
				Math.min( (int) (stump.getGreen()*factor),	255),
				Math.min( (int) (stump.getBlue()*factor), 	255));
    }


    /**
     * Retourne une version soit plus claire soit plus fonce d'une couleur donne.
     * Version plus souple de <CODE>java.awt.Color.brighter() & java.awt.Color.darker()</CODE>.
     * La nouvelle couleur est cre en ajoutant un offset aux composantes
     * RGB de la couleur originale.
     * <P>
     * @param	stump
     * <DL><DD>		Couleur originale.</DL>
     * @param	offset
     * <DL><DD>		L'offset ajout  chaque composante RGB.<BR>
     *				[-255, 0[ -> retourne une couleur plus fonce.<BR>
     *				]0,+255[ -> retourne une couleur plus claire.</DL>
     * @return		Une nouvelle couleur, base sur la couleur originale, mais de luminosit diffrente.
     * @see java.awt.Color#darker()
     * @see java.awt.Color#brighter()
     */
    public static Color brightness(Color stump, int offset) {
	if (offset<0)
	    return new Color(	Math.max(stump.getRed()+offset, 	0),
				Math.max(stump.getGreen()+offset, 	0),
				Math.max(stump.getBlue()+offset,	0));
	else
	    return new Color(	Math.min(stump.getRed()+offset, 	255),
				Math.min(stump.getGreen()+offset, 	255),
				Math.min(stump.getBlue()+offset, 	255));
    }
	
    /**
     * Constructeur (vide) priv, interdisant l'instanciation d'un objet Tools.
     */
    private Tools() {}
}
