package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import spikingneuron.tools.Tools;
import java.awt.GridBagLayout;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.CircularGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur sinusoidal.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class CircularGeneratorGI extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    DoubleGI pulsationCtrl;
    DoubleGI dephasageCtrl;

    // Constructeurs ...........
    public CircularGeneratorGI() {
	super();

	description   = new JLabel(Tools.loadImageIcon(getClass(),
						       "/images/cg_descr.gif",""));
	offsetCtrl	  = new DoubleGI(00.0, 10, "Io  [uA]",
					 DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	amplitudeCtrl = new DoubleGI(01.0, 10, "A   [uA]",
				     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	pulsationCtrl = new DoubleGI(50.0, 10, "w   [Hz]",
				     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	dephasageCtrl = new DoubleGI(00.0, 10, "theta 0 [\u00BA]",
				     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	pulsationCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	makeInterface();
	makeToolTip();
    }

    public CircularGeneratorGI(CircularGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
	amplitudeCtrl.setToolTipText("Facteur d'amplitude.");
	pulsationCtrl.setToolTipText("Frequence d'oscillation (Pulsation).");
	dephasageCtrl.setToolTipText("Dephasage (angle initial de rotation).");
    }

    protected void makeInterface() {
	//		setBackground(Color.lightGray);
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(offsetCtrl);
	controlGrp.add(amplitudeCtrl);
	controlGrp.add(pulsationCtrl);
	controlGrp.add(dephasageCtrl);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(controlGrp,
	    gbConstraints.setAndGet(0,1,
				    Constraints.REMAINDER,1,
				    Constraints.BOTH,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 1.0));
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	CircularGenerator generator = (CircularGenerator)signifie;
	//		super.synchronizeInstance(generator);
	generator.setOffset(offsetCtrl.getValue()*1E-6);
	generator.setAmplitude(amplitudeCtrl.getValue()*1E-6);
	generator.setPulsation(pulsationCtrl.getValue());
	generator.setDephasage(dephasageCtrl.getValue()*Math.PI/180);
    }

    public void synchronizeSignifiant(Object signifie) {
	CircularGenerator generator = (CircularGenerator)signifie;
	offsetCtrl.setValue(generator.getOffset()*1E6);
	amplitudeCtrl.setValue(generator.getAmplitude()*1E6);
	pulsationCtrl.setValue(generator.getPulsation());
	dephasageCtrl.setValue(generator.getDephasage()*180/Math.PI);
    }

    /**
     */
    public void setFontLabels(Font textFont) {
	offsetCtrl.setFontLabels(textFont);
	amplitudeCtrl.setFontLabels(textFont);
	pulsationCtrl.setFontLabels(textFont);
	dephasageCtrl.setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return offsetCtrl.getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/cg_symbolic_S.gif",
					       "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/cg_symbolic_U.gif",
					       "Symbolic Unselected Icon representation")));
    }
}
