package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.DiscreteNoisyGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur de bruit (discret).
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class DiscreteNoisyGeneratorGI extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    LongGI seedCtrl;

    // Constructeurs ...........
    public DiscreteNoisyGeneratorGI() {
	super();
	description		= new JLabel(Tools.loadImageIcon(getClass(),"/images/dng_descr.gif",""));
	offsetCtrl		= new DoubleGI(00.0, 10, "Io  [uA]", DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	amplitudeCtrl	= new DoubleGI(1.0, 10, "A max[uA]", DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	seedCtrl		= new LongGI(0, 10,	  "Nb. Aleatoire", LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	seedCtrl.onBack();
	makeInterface();
	makeToolTip();
    }

    public DiscreteNoisyGeneratorGI(DiscreteNoisyGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
	amplitudeCtrl.setToolTipText("Facteur d'amplitude.");
	seedCtrl.setToolTipText("Graine du generateur aleatoire.");
    }

    protected void makeInterface() {
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(offsetCtrl);
	controlGrp.add(amplitudeCtrl);
	controlGrp.add(seedCtrl);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(controlGrp,
	    gbConstraints.setAndGet(0,1,
				    Constraints.REMAINDER,1,
				    Constraints.BOTH,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 1.0));
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	DiscreteNoisyGenerator generator = (DiscreteNoisyGenerator)signifie;
	generator.setOffset(offsetCtrl.getValue()*1E-6);
	generator.setAmplitude(amplitudeCtrl.getValue()*1E-6);
	generator.setSeed(seedCtrl.getValue());
    }

    public void synchronizeSignifiant(Object signifie) {
	DiscreteNoisyGenerator generator = (DiscreteNoisyGenerator)signifie;
	offsetCtrl.setValue(generator.getOffset()*1E6);
	amplitudeCtrl.setValue(generator.getAmplitude()*1E6);
	seedCtrl.setValue(generator.getSeed());
    }
    /**
     */
    public void setFontLabels(Font textFont) {
	offsetCtrl.setFontLabels(textFont);
	amplitudeCtrl.setFontLabels(textFont);
	seedCtrl.setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return offsetCtrl.getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),"/images/dng_symbolic_S.gif","Symbolic Selected Icon"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),"/images/dng_symbolic_U.gif","Symbolic Unselected Icon")));
    }
}
