package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JComponent;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface (Java) dfinissant le comportement d'une interface utilisateur.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Cette interface (java) reprsente une interface utilisateur, affichable sur l'cran dans un
* composant graphique. Cette interface peut-tre en relation avec une ou plusieurs entits (i.e.
* peut interfacer une ou plusieurs instances). <BR><UL TYPE = circle>
* <LI> Obtenir une rfrence sur le <CODE>JComponent</CODE> contenant
*      l'interface utilisateur, afin de pouvoir l'afficher  l'cran;
* <LI> Ordonner  l'interface de modifier les paramtres effectifs des diffrents objects interfacs,
*      en fonction des choix de l'utilisateur (ceci est utile dans le cas o il n'y a pas de
*      synchronisation automatique entre l'lment interfac et son interface utilisateur
*      -gnralement le cas lorsqu'il s'agit d'instances de classes diffrentes-);
* <LI> Ordonner  l'interface d'actualiser ses contrles en fonction de la
*      valeur des paramtres d'un des objets interfacs;
* <LI> Les mthodes de synchronisation sont utilise pour tablire le lien entre
*      l'lment signifi et son signifiant  l'cran. Une mthode plus pratique, mais
*      qui risque d'tre lente (ce serait  explorer), consiste  utiliser un objet
*      partag comme paramtre de signif et contrle de signifiant (un objet unique,
*      rfrenc dans deux instances de diffrentes classes). Dans ce cas, tous les
*      attributs (susceptible d'tres interfacs) doivent tre des objets... il faut
*      donc utiliser des types wrappers en lieu et place des types primitifs, non
*      rfrencables en Java. (Je <G>suppose</G> que le recours systmatique  de tels types
*      augmente le temps de calcul de manire non ngligeable).
* </UL><BR>
* <P>
*/

public abstract interface GraphicalInterface {

    /**
     * Obtention du JComponent contenant les lments graphiques de l'interface.
     * @return JComponent (Component)  afficher pour rendre l'interface visible.
     */
    public abstract JComponent getInterface();

    /**
     * Retourne un object symbolisant l'interface, ou plutot l'lment interfac.
     * Cet objet sera utilis pour slectionner l'interface dans une liste.
     * La nature de l'lment retourn n'tant pas spcifie, cela peut tre,
     * suivant les besoins, une chaine de texte (String), une image ...
     * Le type de retour devrait tre JComponent (voir JLabel), ou encore Pair(JComponent),
     * mais cela est trop restrictif...  voir suivant les cas...
     */
    public abstract Object getSymbolic();

    //	Pas implment, car pas utile pour cette application.
    //	/**
    //	* Retourne une icone symbolisant l'lment interfac (une paire d'icone).
    //	*/
    //	public abstract Pair getIconic();

    /**
     * Synchronise le(s) signifi(s) (acception linguistique) avec son interface
     * (i.e. les paramtres de(s) l'objet(s) interfac(s) sont modifis en
     * fonction de la valeur des contrles de l'interface).
     */
    public abstract void synchronizeSignifie(Object signifie) throws UnsupportedSynchronization;
    /**
     * Synchronise le(s) signifi(s) (acception linguistique) avec son interface
     * (i.e. les paramtres de(s) l'objet(s) interfac(s) sont modifis en
     * fonction de la valeur des contrles de l'interface).
     */
    public abstract void synchronizeSignifie() throws UnsupportedSynchronization;

    /**
     * Synchronise le signifiant en fonction de l'tat des paramtres du signifi
     * (i.e. les contrles de l'interface sont modifis en fonction de la valeur
     * des paramtres de(s) l'objet(s) interfac(s)).
     * Les interfaces intgrant le signifi ne supportent pas cette mthode.
     */
    public abstract void synchronizeSignifiant(Object signifie) throws UnsupportedSynchronization;

    /**
     * Synchronise le signifiant en fonction de l'tat des paramtres du signifi
     * (i.e. les contrles de l'interface sont modifis en fonction de la valeur
     * des paramtres de(s) l'objet(s) interfac(s)).
     * Les interfaces admettant plusieurs signifis ne supportent pas cette mthode,
     *  l'inverse de celles n'admettant qu'une instance interface.
     */
    public abstract void synchronizeSignifiant() throws UnsupportedSynchronization;

    /**
     * Dfinit la police utilise pour les labels de l'interface.
     */
    public abstract void setFontLabels(Font textFont);

    /**
     * Retourne la police utilise pour les labels de l'interface.
     */
    public abstract Font getFontLabels();
}
