package spikingneuron.userinterface;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur pour un entier long.
* </TT></STRONG><FONT SIZE=3>
* Le domaine de validit est spcifiable. <BR>
* Il serait peut-etre bon d'interdire l'entree de caracteres non-nummeriques,
* a l'exception des signes +-.,e. Pour cela, il faut redfinir l'interface
* KeyListener... mais ce n'est peut-etre pas trivial, car il faut traiter les cas
* de type Ret, Tab, Esc ... Cut&Paste etc.
*/
public class LongGI extends PrimitiveTypeGI implements ActionListener, FocusListener {
    public static final Long DEFAULT_VALUE;
    public Long value;
    public JTextField field;
    protected boolean limitedSize;
    protected boolean validateDomaine;
    protected int nbDecimales;
    protected long minValue;
    protected long maxValue;
	

    // Constructeurs .................................
    public LongGI() {
	super();
	nbDecimales = 10;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	super.signifiant = field = new JTextField();
	setValue(DEFAULT_VALUE);
	super.signifie = this.value;
	placeComponents(LABEL_NONE);
    }
    public LongGI(long value) {
	super();
	nbDecimales = 10;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	super.signifiant = field = new JTextField();
	setValue(value);
	super.signifie = this.value;
	placeComponents(LABEL_NONE);
    }
    public LongGI(Long value) {
	super();
	nbDecimales = 10;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	super.signifiant = field = new JTextField();
	setValue(value);
	super.signifie = this.value;
	placeComponents(LABEL_NONE);
    }
    public LongGI(long value, int fieldSize) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(LABEL_NONE);
    }
    public LongGI(Long value, int fieldSize) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(LABEL_NONE);
    }
    public LongGI(long value, int fieldSize, String label, int position) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	this.label = new JLabel(label);
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(position);
    }
    public LongGI(Long value, int fieldSize, String label, int position) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	this.label = new JLabel(label);
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(position);
    }
    public LongGI(long value, int fieldSize, String label, int position, int alignment) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	this.label = new JLabel(label, alignment);
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(position);
    }
    public LongGI(Long value, int fieldSize, String label, int position, int alignment) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	this.label = new JLabel(label, alignment);
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(position);
    }

    public LongGI(Long value, int fieldSize, JLabel label, int position) {
	super();
	nbDecimales = fieldSize;
	limitedSize = false;
	validateDomaine = false;
	minValue = Long.MIN_VALUE;
	maxValue = Long.MAX_VALUE;
	this.label = label;
	super.signifiant = field = new JTextField(fieldSize);
	setValue(value);
	super.signifie = this.value;
	placeComponents(position);
    }
	
    // Accesseurs ....................................
    public void setDecimales(int nbDecimales) {
	this.nbDecimales = nbDecimales;
	String str = value.toString();
	field.setText( limitedSize ? 
		       str.substring(0,Math.min(nbDecimales,str.length()))
		       : str);
    }
    public int getDecimale() {
	return nbDecimales;
    }
	
    public void setLimitedDecimales(boolean limitedDecimales) {
	this.limitedSize = limitedDecimales;
    }
    public boolean getLimitedDecimales() {
	return limitedSize;
    }
		
    public void setValue(long value) {
	this.value = new Long(value);
	String str = String.valueOf(value);
	field.setText( limitedSize ? 
		       str.substring(0,Math.min(nbDecimales,str.length()))
		       : str);
    }
    public void setValue(Long value) {
	this.value = value;
	String str = value.toString();
	field.setText( limitedSize ? 
		       str.substring(0,Math.min(nbDecimales,str.length()))
		       : str);
    }
    public long getValue() {
	return value.longValue();
    }
    public void setValidityDomaine(long min, long max) {
	minValue = java.lang.Math.min(min,max);
	maxValue = java.lang.Math.max(min,max);
	validateDomaine = true;
    }
    public long getMinValue() {
	return minValue;
    }
    public long getMaxValue() {
	return maxValue;
    }

    public boolean getCheckedValue() {
	return validateDomaine;
    }
    public void setCheckedValue(boolean performeCheck) {
	validateDomaine = performeCheck;
    }
	
    // GraphicalInterface implementation .....................
    public void synchronizeSignifiant(Object signifie) {
	setValue((Long)signifie);
    }
    public void synchronizeSignifie(Object signifie) {
	signifie = this.value;
    }
	
	
    // Divers ...............................
    protected void placeComponents(int labelPosition) {
	super.placeComponents(labelPosition);
	field.addActionListener(this);
	field.addFocusListener(this);
    }

    // Interface ActionListener implement ...........................
    public void actionPerformed(ActionEvent event) {
	/*
	  Touche Return (validation) lors de l'edition du champ.
	  Dans le cas ou l'entree n'est pas valable, l'ancienne
	  valeur est conservee.
	*/
	long value;
	try {
	    value = Long.valueOf(field.getText()).longValue();
	    if ( (validateDomaine && ( (value<minValue)||(value>maxValue))))
		throw new NumberFormatException();
	}
	catch (NumberFormatException exc) {
	    value = this.value.longValue();
	}
	setValue(value);
    }

    // Interface FocusListener implementation .....................
    public void focusGained(FocusEvent e) {}
	
    public void focusLost(FocusEvent e) {
	/* 	Touche TAB pour terminer l'edition, ou pointage d'un autre element
		Dans le cas ou l'entree n'est pas valable, l'ancienne
		valeur est conservee. */
		
	/* Toutes les pertes de focus sont traitees, meme s'il s'agit
	   d'une perte temporaire (Si le champ est en edition, et qu'un
	   bouton est actionne via la souris, le champ en edition perd
	   temporairement le focus. Dans le cas ou le bouton start est
	   press, cela implique que les valeurs actuelles du champs ne
	   sont pas prise en compte.
	*/
	long value;
	try {
	    value = Long.valueOf(field.getText()).longValue();
	    if ( (validateDomaine && ( (value<minValue)||(value>maxValue))))
		throw new NumberFormatException();
	}
	catch (NumberFormatException exc) {
	    value = this.value.longValue();
	}
	setValue(value);
    }
	

    static {
	DEFAULT_VALUE = new Long(0);
    }
}
