package spikingneuron.userinterface;

import java.awt.Font;
import com.objectspace.jgl.Pair;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import spikingneuron.neurons.NeuronBaseModel;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base (<B>abstraite</B>) pour les interfaces utilisateurs des neurones impulsionnels.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Signifiant & signifi totalement indpendant (Aucune rfrence n'est stocke...).
* @see spikingneuron.graphicalInterface.GraphicalInterface
*/
public abstract class NeuronBaseModelGI extends JPanel implements GraphicalInterface {

    protected Pair symbolic; // reprsentation symbolique.
    protected JComponent description;

    // Contrles des paramtres communs aux diffrents modles de neurones
    protected DoubleGI mThresholdCtrl; // mV
    protected DoubleGI gThresholdCtrl; // mV
    protected DoubleGI mRefractoryTimeCtrl; // ms
    protected DoubleGI gRefractoryTimeCtrl; // ms
    protected DoubleGI resistanceCtrl; // MOhms
    protected DoubleGI tauSynapticCtrl; //ms
    protected DoubleGI noiseCtrl; //mA

    // Constructeurs .................
    protected NeuronBaseModelGI() {
	// Constructeur classe drive doit nat. instancier ces obj.
	super();
	symbolic = new Pair(getSymbolicIcon(false), getSymbolicIcon(true));
	mThresholdCtrl		= null;		gThresholdCtrl		= null;
	mRefractoryTimeCtrl	= null;		gRefractoryTimeCtrl	= null;
	resistanceCtrl 		= null;		tauSynapticCtrl 	= null;
	noiseCtrl			= null;		description			= null;
    }

    // Divers ........................
    public void setFontLabels(Font textFont) {
	mThresholdCtrl.setFontLabels(textFont);
	gThresholdCtrl.setFontLabels(textFont);
	mRefractoryTimeCtrl.setFontLabels(textFont);
	gRefractoryTimeCtrl.setFontLabels(textFont);
	resistanceCtrl.setFontLabels(textFont);
	tauSynapticCtrl.setFontLabels(textFont);
	noiseCtrl.setFontLabels(textFont);
    }

    public Font getFontLabels() {
	return mThresholdCtrl.getFontLabels();
    }
					
    protected void makeToolTip() {
	mThresholdCtrl.setToolTipText("Valeur moyenne du seuil au-dela duquel un spike est emis [mV].");
	gThresholdCtrl.setToolTipText("Ecart-type du seuil d'emission des spikes [mV].");
	resistanceCtrl.setToolTipText("Valeur de la resistance du modele [MOhms].");
	tauSynapticCtrl.setToolTipText("Constante de temps de la synapse [ms].");
	noiseCtrl.setToolTipText("Amplitude maximale du courant de bruit [uA].");
	mRefractoryTimeCtrl.setToolTipText("Duree moyenne des periodes refractaires absolues [ms].");
	gRefractoryTimeCtrl.setToolTipText("Ecart-type de la dure des periodes refractaires absolues [ms].");
    }

    protected void synchronizeSignifie(NeuronBaseModel neuron) {
	neuron.setThreshold(mThresholdCtrl.getValue()*1E-3, gThresholdCtrl.getValue()*1E-3);
	neuron.setResistance(resistanceCtrl.getValue()*1E6);
	neuron.setTauSynaptic(tauSynapticCtrl.getValue()*1E-3);
	neuron.setNoiseAmplitude(noiseCtrl.getValue()*1E-6);
	neuron.setAbsoluteRefractoryTime(mRefractoryTimeCtrl.getValue()*1E-3, gRefractoryTimeCtrl.getValue()*1E-3);
    }

    protected void synchronizeSignifiant(NeuronBaseModel neuron) {
	mThresholdCtrl.setValue(neuron.getMeanThreshold()*1E3);
	gThresholdCtrl.setValue(neuron.getGapThreshold()*1E3);
	resistanceCtrl.setValue(neuron.getResistance()*1E-6);
	tauSynapticCtrl.setValue(neuron.getTauSynaptic()*1E3);
	noiseCtrl.setValue(neuron.getNoiseAmplitude()*1E6);
	mRefractoryTimeCtrl.setValue(neuron.getMeanAbsoluteRefractoryTime()*1E3);
	gRefractoryTimeCtrl.setValue(neuron.getGapAbsoluteRefractoryTime()*1E3);
    }

    // GraphicalInterface implementation ................
    public JComponent getInterface() {
	return this;
    }
    public Object getSymbolic() {
	// La mthode doit retourner un instance, mais pas en crer,
	// pour que le stockage dans CardLayout avec le hashCode comme
	// identifiant soit possible...
	return symbolic;		
    }
    public JComponent getDescription() {
	return description;
    }
			
    public void synchronizeSignifie() throws UnsupportedSynchronization {
	throw new UnsupportedSynchronization();
    }
    public void synchronizeSignifiant() throws UnsupportedSynchronization {
	throw new UnsupportedSynchronization();
    }
    public abstract void synchronizeSignifie(Object signifie);
    public abstract void synchronizeSignifiant(Object signifie);
    // Cette methode doit retourner un JLabel correctement construit,
    // avant que l'objet ne soit entirement construit.
    // Invocation de cette mthode avant invocation du constructeur...
    protected abstract JLabel getSymbolicIcon(boolean selectedIcon);
}

/*----------------------------------------------------
  Mthodes abstraites:
 --------------------
 public abstract void synchronizeSignifie(Object signifie) : synchro d'une instance
	public abstract void synchronizeSignifiant(Object signifie) : synchro en fct d'une instance
      protected abstract JLabel getSymbolicIcon(boolean) : JLabel utilis comme symbole
      public abstract void setFontLabels(Font textFont)  : utilise textFont pour tous les labels
      public abstract Font getFontLabels()               : retourne la font des labels
      ------------------------------------------------------- */
