package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JComponent;
import javax.swing.UIManager; 

import java.awt.Font;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 Mai 1998 
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base (<B>abstraite</B>) pour les interface des types primitifs.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Cette classe dfinit les bases pour interfacer un type primitif (entier, rel).
* Elle dfinit un attribut label (JLabel), un JComponent qui contient le signifiant,
* et un Objet qui rfrencie le signifi.
* <P>
*/
public abstract class PrimitiveTypeGI extends JPanel implements GraphicalInterface {
    protected static final int LABEL_NONE   = 0;
    public static final int LABEL_AT_TOP	= 1;
    public static final int LABEL_AT_BOTTOM = 2;
    public static final int LABEL_AT_LEFT   = 3;
    public static final int LABEL_AT_RIGHT  = 4;

    /*
      Paramtrage des couleurs ncessite:
      1) Extension du type Color pour gestion de la transparence (c.f. JFC & JDK 1.2)
      2) Classe gerant explicitement les couleurs texte/fond pour les labels & champs.
      -> extension de cette classe pour la gestion globale du format (Font,Style,Alignement...)
    */			
    public static final Color STANDARD_LABEL_FG_COLOR = UIManager.getColor("Label.foreground"); //Color.black;
    public static final Color STANDARD_LABEL_BK_COLOR = UIManager.getColor("Label.background"); //Color.lightGray;
    public static final Color STANDARD_FIELD_FG_COLOR = UIManager.getColor("TextField.foreground"); //Color.black;
    public static final Color STANDARD_FIELD_BK_COLOR = UIManager.getColor("TextField.background"); //Color.white;

    public static final Color HANGBACK_LABEL_FG_COLOR = Color.gray;
    public static final Color HANGBACK_LABEL_BK_COLOR = Color.lightGray;
    public static final Color HANGBACK_FIELD_FG_COLOR = Color.gray;
    public static final Color HANGBACK_FIELD_BK_COLOR = Color.lightGray;
    // Rem: les couleurs standards ne sont pas applique... les valeurs par dfaut
    // de l'UI manager sont utilises...
    // De meme, lorsqu'un label est mis en retrait, le fond du champ
    // (textfield dans la plupart des cas) n'est pas colori, le composant
    // n'est simplement pas opaque.

    /*
      Visibilit sur le composant et le label, afin de permettre leur
      paramtrage (font,couleur,editable,activ...) depuis l'extrieur.
      Attention: ne pas modifier le contenu du signifi ou du signifiant
      directement...
    */
    public JLabel label;          // -> JLabel
    public Object signifie;       // (acception linguistique)
    public JComponent signifiant; // (idem)

    /*
      Les sous-classes ont la respossabilite d'initialiser les differents champs.
      Le signifie sera par convention implemente dans un attribut public dont
      l'identificateur est 'value': public <Class-Wide> value
      Une methode sans parametre, retournant le signifie de type primitif,
      appellee 'getValue' sera egalement implementee.
	 
      Extension (avec swing): prevoir la possibilite de definir un label en tant
      que texte formatte (multi-fonts/multi-couleurs, icones etc).
      Utilisation: affichage du symbole mathematique en meme temps que le nom
      francais (genre pulsation w (en fait omega)).
      Si trop complique, affichage d'une icone uniquement (l'appelant devant alors
      dessiner le label au prealable dans une image off-screen, et en faire une icone).
    */

    // Constructeurs ............................	
    protected PrimitiveTypeGI() { 
	super();
	label = null;
	signifie = null;
	signifiant = null;
	setLayout(new BorderLayout(3,4)); // a bug ?
    }
	
    // Accesseurs ...............................
    public Object getWrappedValue() {
	return signifie;
    }

    // Divers ...................................
    protected void placeComponents(int labelPosition) {
	add(BorderLayout.CENTER, signifiant);
	switch (labelPosition) {
	case LABEL_AT_TOP	:	add(BorderLayout.NORTH,label); break;
	case LABEL_AT_BOTTOM :	add(BorderLayout.SOUTH,label); break;
	case LABEL_AT_LEFT   :	add(BorderLayout.WEST, label); break;
	case LABEL_AT_RIGHT  :	add(BorderLayout.EAST, label); break;
	}
    }
	
    public void setToolTipText(String text) {
	super.setToolTipText(text);
	label.setToolTipText(text);
	signifiant.setToolTipText(text);
    }
	
	
    // GraphicalInterface implmentation .........
    public JComponent getInterface() {
	return this;
    }	
    public Object getSymbolic() {
	return null;
    }

    public void synchronizeSignifie() {} // Synchro permanente.
    public abstract void synchronizeSignifie(Object signifie);
    public void synchronizeSignifiant() {} // Synchro permanente.
    public abstract void synchronizeSignifiant(Object signifie);

    public void setFontLabels(Font textFont) {
	if (label!=null)
	    label.setFont(textFont);
    }
		
    public Font getFontLabels() {
	if (label!=null)
	    return label.getFont();
	else
	    return null;
    }

    /**
     * Modifie l'aspect de l'interface en plaant le champ en 'retrait'.
     */		
    public void onBack() {
	label.setForeground(HANGBACK_LABEL_FG_COLOR);
	//		label.setBackground(HANGBACK_LABEL_BK_COLOR);
	signifiant.setForeground(HANGBACK_FIELD_FG_COLOR);
	//		signifiant.setBackground(HANGBACK_FIELD_BK_COLOR);
	signifiant.setOpaque(false);
    }

    /**
     * Modifie l'aspect de l'interface en plaant le champ en 'avant' = tat par dfaut.
     */		
    public void onFront() {
	label.setForeground(STANDARD_LABEL_FG_COLOR);
	label.setBackground(STANDARD_LABEL_BK_COLOR);
	signifiant.setForeground(STANDARD_FIELD_FG_COLOR);
	signifiant.setBackground(STANDARD_FIELD_BK_COLOR);
	signifiant.setOpaque(true);
    }   
}
/*----------------------------------------------------
  Mthodes abstraites:
 --------------------
 public abstract void synchronizeSignifie(Object signifie) : synchro d'une instance
 public abstract void synchroniseSignifiant(Object signifie) : synchro en fct d'une instance
 ------------------------------------------------------- */
